/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.colormap;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.biome.BiomeIdMapper;
import net.mehvahdjukaar.polytone.colormap.ColormapExpressionProvider;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ReferenceOrDirectCodec;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColormapNumberProvider {
    public static final BiMap<String, IColormapNumberProvider> CUSTOM_PROVIDERS = HashBiMap.create();
    public static final Codec<IColormapNumberProvider> REFERENCE_CODEC = class_5699.method_39508(a -> (String)CUSTOM_PROVIDERS.inverse().get(a), arg_0 -> CUSTOM_PROVIDERS.get(arg_0));
    public static final Codec<IColormapNumberProvider> CODEC = new ReferenceOrDirectCodec<ColormapExpressionProvider>(REFERENCE_CODEC, ColormapExpressionProvider.CODEC, true);
    public static final IColormapNumberProvider ZERO = IColormapNumberProvider.register("zero", new Const(0.0f));
    public static final IColormapNumberProvider ONE = IColormapNumberProvider.register("one", new Const(1.0f));
    public static final IColormapNumberProvider TEMPERATURE = IColormapNumberProvider.register("temperature", new IColormapNumberProvider(){

        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, BiomeIdMapper mapper) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((class_1959)biome).comp_844;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider LEGACY_TEMPERATURE = IColormapNumberProvider.register("legacy_temperature", new IColormapNumberProvider(){

        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, BiomeIdMapper mapper) {
            return biome == null ? 0.0f : biome.method_21740(pos);
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider DOWNFALL = IColormapNumberProvider.register("downfall", new IColormapNumberProvider(){

        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, BiomeIdMapper mapper) {
            return biome == null ? 0.0f : ColorUtils.getClimateSettings((class_1959)biome).comp_846;
        }

        @Override
        public boolean usesState() {
            return false;
        }
    });
    public static final IColormapNumberProvider BIOME_ID = IColormapNumberProvider.register("biome_id", (state, pos, biome, mapper) -> {
        class_2378 registry = (class_2378)((class_5455)Polytone.REGISTRY_ACCESS_HACK.get()).method_33310(class_7924.field_41236).get();
        return 1.0f - mapper.getIndex((class_2378<class_1959>)registry, biome);
    });
    public static final IColormapNumberProvider Y_LEVEL = IColormapNumberProvider.register("y_level", (state, pos, biome, m) -> (float)(pos == null ? 64 : pos.method_10264()) / 255.0f);

    public static <T extends IColormapNumberProvider> T register(String name, T provider) {
        CUSTOM_PROVIDERS.put((Object)name, provider);
        return provider;
    }

    public float getValue(@Nullable class_2680 var1, @Nullable class_2338 var2, @Nullable class_1959 var3, @Nullable BiomeIdMapper var4);

    default public boolean usesBiome() {
        return true;
    }

    default public boolean usesPos() {
        return true;
    }

    default public boolean usesState() {
        return true;
    }

    public record Const(float c) implements IColormapNumberProvider
    {
        @Override
        public float getValue(class_2680 state, @NotNull class_2338 pos, @Nullable class_1959 biome, BiomeIdMapper mapper) {
            return this.c;
        }

        @Override
        public boolean usesState() {
            return false;
        }

        @Override
        public boolean usesBiome() {
            return false;
        }

        @Override
        public boolean usesPos() {
            return false;
        }
    }
}

