/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.polytone.lightmap.ILightmapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_5699;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_765;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Lightmap {
    protected static final double DEFAULT_SKY_LERP = 0.5;
    protected static final double DEFAULT_TORCH_LERP = 0.0;
    public static final Decoder<Lightmap> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StrOpt.of(ILightmapNumberProvider.CODEC, "sky_getter", ILightmapNumberProvider.DEFAULT).forGetter(l -> l.skyGetter), (App)StrOpt.of(ILightmapNumberProvider.CODEC, "torch_getter", ILightmapNumberProvider.DEFAULT).forGetter(l -> l.torchGetter), (App)StrOpt.of(Codec.BOOL, "lightning_strike_columns", true).forGetter(l -> l.hasLightningColumn), (App)StrOpt.of(Lightmap.doubleRange(0.0, 1.0), "sky_lerp_factor", 0.5).forGetter(l -> l.skyLerp), (App)StrOpt.of(Lightmap.doubleRange(0.0, 1.0), "torch_lerp_factor", 0.0).forGetter(l -> l.torchLerp)).apply((Applicative)instance, Lightmap::new));
    private final ILightmapNumberProvider skyGetter;
    private final ILightmapNumberProvider torchGetter;
    private final boolean hasLightningColumn;
    private final double skyLerp;
    private final double torchLerp;
    private final ArrayImage[] textures = new ArrayImage[3];
    private final float[][] lastSkyLine = new float[16][3];
    private final float[][] lastTorchLine = new float[16][3];

    public static Codec<Double> doubleRange(double min, double max) {
        return class_5699.method_48112((Codec)Codec.DOUBLE, d -> d.compareTo(min) >= 0 && d.compareTo(max) <= 0 ? DataResult.success((Object)d) : DataResult.error(() -> "Value must be within range [" + min + ";" + max + "]: " + d));
    }

    public Lightmap(ILightmapNumberProvider skyGetter, ILightmapNumberProvider torchGetter, boolean lightningColumn, double skyLerp, double torchLerp) {
        this.skyGetter = skyGetter;
        this.torchGetter = torchGetter;
        this.hasLightningColumn = lightningColumn;
        this.skyLerp = skyLerp;
        this.torchLerp = torchLerp;
    }

    public Lightmap() {
        this(ILightmapNumberProvider.DEFAULT, ILightmapNumberProvider.RANDOM, true, 0.5, 0.0);
    }

    public void acceptImages(ArrayImage normal, ArrayImage rain, ArrayImage thunder) {
        this.textures[0] = normal;
        this.textures[1] = rain;
        this.textures[2] = thunder;
        for (ArrayImage v : this.textures) {
            if (v == null || v.width() > 2) continue;
            throw new IllegalStateException("Lightmap cannot have more with is too small! Was " + v.width());
        }
    }

    public void applyToLightTexture(class_765 instance, class_1011 lightPixels, class_1043 lightTexture, class_310 minecraft, class_638 level, float flicker, float partialTicks) {
        float lerpDelta;
        float skyDarken = level.method_23783(partialTicks);
        float rainLevel = level.method_8430(partialTicks);
        float thunderLevel = level.method_8478(partialTicks);
        float time = level.method_30274(partialTicks);
        float deltaTime = minecraft.method_1534();
        class_746 player = minecraft.field_1724;
        class_315 options = minecraft.field_1690;
        boolean skyFlashTime = level.method_23789() > 0;
        float skyLightIntensity = skyFlashTime ? 1.0f : skyDarken * 0.95f + 0.05f;
        float darknessEffect = ((Double)options.method_42472().method_41753()).floatValue();
        float darknessGamma = instance.method_42597(partialTicks) * darknessEffect;
        float darknessSubtract = instance.method_42596((class_1309)player, darknessGamma, partialTicks) * darknessEffect;
        float gamma = ((Double)options.method_42473().method_41753()).floatValue();
        float gammaAmount = Math.max(0.0f, gamma - darknessGamma);
        float waterVision = player.method_3140();
        float nightVisionScale = player.method_6059(class_1294.field_5925) ? class_757.method_3174((class_1309)player, (float)partialTicks) : (waterVision > 0.0f && player.method_6059(class_1294.field_5927) ? waterVision : 0.0f);
        Vector3f skyColor = new Vector3f(skyDarken, skyDarken, 1.0f).lerp((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f), 0.35f);
        float blockLightFlicker = flicker + 1.5f;
        class_2874 dimensionType = level.method_8597();
        float darkenWorldAmount = minecraft.field_1773.method_3195(partialTicks);
        Vector3f lightGray = new Vector3f(0.75f, 0.75f, 0.75f);
        float lightGrayAmount = 0.04f;
        ArrayImage image = this.selectImage(rainLevel, thunderLevel);
        float[][] torchLine = this.selectTorch(image, nightVisionScale, time, rainLevel, thunderLevel);
        float[][] skyLine = this.selectSky(image, nightVisionScale, time, rainLevel, thunderLevel, skyFlashTime);
        if (torchLine.length != 0 && this.lastTorchLine.length != 0 && this.torchLerp != 1.0) {
            lerpDelta = 1.0f - (float)Math.pow(this.torchLerp, deltaTime);
            Lightmap.lerpInplace(this.lastTorchLine, torchLine, deltaTime);
        }
        if (skyLine.length != 0 && this.lastSkyLine.length != 0 && this.skyLerp != 1.0) {
            lerpDelta = 1.0f - (float)Math.pow(this.skyLerp, deltaTime);
            Lightmap.lerpInplace(this.lastSkyLine, skyLine, deltaTime);
        }
        for (int skyY = 0; skyY < 16; ++skyY) {
            Vector3f skyBuffer = new Vector3f();
            if (skyLine.length != 0) {
                skyBuffer.add((Vector3fc)new Vector3f(skyLine[skyY]));
            } else {
                float skyBrightness = class_765.method_23284((class_2874)dimensionType, (int)skyY) * skyLightIntensity;
                skyBuffer.add((Vector3fc)skyColor).mul(skyBrightness);
                skyBuffer.mul(1.0f - lightGrayAmount);
            }
            for (int torchX = 0; torchX < 16; ++torchX) {
                float maxVal;
                Vector3f addition = new Vector3f();
                Vector3f torchBuffer = new Vector3f();
                if (torchLine.length != 0) {
                    torchBuffer.add((Vector3fc)new Vector3f(torchLine[torchX]));
                } else {
                    float torchR = class_765.method_23284((class_2874)dimensionType, (int)torchX) * blockLightFlicker;
                    float torchG = torchR * ((torchR * 0.6f + 0.4f) * 0.6f + 0.4f);
                    float torchB = torchR * (torchR * torchR * 0.6f + 0.4f);
                    torchBuffer.set(torchR, torchG, torchB);
                    addition.add((Vector3fc)new Vector3f((Vector3fc)lightGray).mul(lightGrayAmount));
                    torchBuffer.mul(1.0f - lightGrayAmount);
                }
                Vector3f combined = new Vector3f();
                combined.add((Vector3fc)torchBuffer).add((Vector3fc)skyBuffer).add((Vector3fc)addition);
                if (darkenWorldAmount > 0.0f) {
                    Vector3f discolored = new Vector3f((Vector3fc)combined).mul(0.7f, 0.6f, 0.6f);
                    combined.lerp((Vector3fc)discolored, darkenWorldAmount);
                }
                if (nightVisionScale > 0.0f && (image == null || image.height() < 32) && (maxVal = Math.max(combined.x(), Math.max(combined.y(), combined.z()))) < 1.0f) {
                    float percentage = 1.0f / maxVal;
                    Vector3f discolored = new Vector3f((Vector3fc)combined).mul(percentage);
                    combined.lerp((Vector3fc)discolored, nightVisionScale);
                }
                if (darknessSubtract > 0.0f) {
                    combined.add(-darknessSubtract, -darknessSubtract, -darknessSubtract);
                }
                Lightmap.clampColor(combined);
                Vector3f notGamma = new Vector3f(instance.method_23795(combined.x), instance.method_23795(combined.y), instance.method_23795(combined.z));
                combined.lerp((Vector3fc)notGamma, gammaAmount);
                combined.lerp((Vector3fc)lightGray, lightGrayAmount);
                Lightmap.clampColor(combined);
                combined.mul(255.0f);
                int x = (int)combined.x();
                int y = (int)combined.y();
                int z = (int)combined.z();
                lightPixels.method_4305(torchX, skyY, 0xFF000000 | z << 16 | y << 8 | x);
            }
            lightTexture.method_4524();
        }
    }

    private float[][] selectSky(ArrayImage image, float nightVision, float time, float rain, float thunder, boolean isThunderFlash) {
        if (image == null) {
            return new float[0][];
        }
        float xVal = this.skyGetter.getValue(time, rain, thunder);
        float[][] skyLine = new float[16][];
        int usableSkyWidth = image.width() - 1 - (this.hasLightningColumn ? 1 : 0);
        int w = !isThunderFlash || !this.hasLightningColumn ? (isThunderFlash ? usableSkyWidth : Math.round(xVal * (float)usableSkyWidth)) : usableSkyWidth + 1;
        int h = nightVision != 0.0f && image.height() == 64 ? 32 : 0;
        for (int i = 0; i < 16; ++i) {
            skyLine[i] = ColorUtils.unpack(image.pixels()[h + i][w]);
        }
        return skyLine;
    }

    private float[][] selectTorch(ArrayImage image, float nightVision, float time, float rain, float thunder) {
        if (image == null || image.height() < 32) {
            return new float[0][];
        }
        float xVal = this.torchGetter.getValue(time, rain, thunder);
        float[][] torchLine = new float[16][];
        int h = 16 + (nightVision != 0.0f && image.height() == 64 ? 32 : 0);
        for (int i = 0; i < 16; ++i) {
            torchLine[i] = ColorUtils.unpack(image.pixels()[h + i][(int)(xVal * (float)(image.width() - 1))]);
        }
        return torchLine;
    }

    @Nullable
    private ArrayImage selectImage(float rain, float thunder) {
        ArrayImage image;
        if (thunder != 0.0f) {
            image = this.textures[2];
            if (image == null) {
                image = this.textures[0];
            }
        } else if (rain != 0.0f) {
            image = this.textures[1];
            if (image == null) {
                image = this.textures[0];
            }
        } else {
            image = this.textures[0];
        }
        return image;
    }

    private static void clampColor(Vector3f color) {
        color.set(class_3532.method_15363((float)color.x, (float)0.0f, (float)1.0f), class_3532.method_15363((float)color.y, (float)0.0f, (float)1.0f), class_3532.method_15363((float)color.z, (float)0.0f, (float)1.0f));
    }

    public static void lerpInplace(float[][] oldColors, float[][] newColors, float delta) {
        int i;
        if (oldColors.length != newColors.length || oldColors[0].length != newColors[0].length) {
            throw new IllegalArgumentException("Input arrays must have the same dimensions.");
        }
        int numRows = oldColors.length;
        int numCols = oldColors[0].length;
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < numCols; ++j) {
                newColors[i][j] = class_3532.method_16439((float)delta, (float)oldColors[i][j], (float)newColors[i][j]);
            }
        }
        for (i = 0; i < numRows; ++i) {
            System.arraycopy(newColors[i], 0, oldColors[i], 0, numCols);
        }
    }
}

