/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.lightmap;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.lightmap.ILightmapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

record LightmapExpressionProvider(Expression expression, String unparsed) implements ILightmapNumberProvider
{
    public static final Codec<LightmapExpressionProvider> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)LightmapExpressionProvider.create(s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, exp -> DataResult.success((Object)exp.unparsed));
    private static final String TIME = "TIME";
    private static final String RAIN = "RAIN";
    private static final String THUNDER = "THUNDER";

    public static LightmapExpressionProvider create(String s) {
        return new LightmapExpressionProvider(new ExpressionBuilder(ExpressionUtils.removeHex(s)).variables(new String[]{TIME, RAIN, THUNDER}).functions(ExpressionUtils.defFunc(new Function[0])).operator(ExpressionUtils.defOp(new Operator[0])).build(), s);
    }

    @Override
    public float getValue(float time, float rain, float thunder) {
        this.expression.setVariable(TIME, (double)time);
        this.expression.setVariable(RAIN, (double)rain);
        this.expression.setVariable(THUNDER, (double)thunder);
        return 0.0f;
    }
}

