/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.particle.BlockParticleExpression;
import net.mehvahdjukaar.polytone.particle.ParticleExpression;
import net.mehvahdjukaar.polytone.particle.ParticleFactory;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import org.jetbrains.annotations.Nullable;

public class CustomParticleType
implements ParticleFactory {
    private final RenderType renderType;
    @Nullable
    private final Initializer initializer;
    @Nullable
    private final Ticker ticker;
    private transient class_4002 spriteSet;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(RenderType.CODEC, "render_type", RenderType.OPAQUE).forGetter(CustomParticleType::getRenderType), (App)StrOpt.of(Initializer.CODEC, "initializer").forGetter(c -> Optional.ofNullable(c.initializer)), (App)StrOpt.of(Ticker.CODEC, "ticker").forGetter(c -> Optional.ofNullable(c.ticker))).apply((Applicative)i, CustomParticleType::new));

    public CustomParticleType(RenderType renderType, @Nullable Initializer initializer, @Nullable Ticker ticker) {
        this.renderType = renderType;
        this.initializer = initializer;
        this.ticker = ticker;
    }

    public CustomParticleType(RenderType renderType, Optional<Initializer> initializer, Optional<Ticker> ticker) {
        this(renderType, (Initializer)initializer.orElse(null), (Ticker)ticker.orElse(null));
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public void createParticle(class_638 world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        if (camera.method_19326().method_1028(x, y, z) < 1024.0) {
            if (this.spriteSet != null) {
                Instance particle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this);
                mc.field_1713.method_3058((class_703)particle);
            } else {
                throw new IllegalStateException("Sprite set not set for custom particle type");
            }
        }
    }

    public void setSpriteSet(class_702.class_4090 mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    private static enum RenderType {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        CUSTOM;

        public static final Codec<RenderType> CODEC;

        public class_3999 get() {
            return switch (this) {
                case TERRAIN -> class_3999.field_17827;
                default -> class_3999.field_17828;
                case TRANSLUCENT -> class_3999.field_17829;
                case CUSTOM -> class_3999.field_17831;
            };
        }

        static {
            CODEC = Codec.STRING.xmap(a -> RenderType.valueOf(a.toUpperCase()), e -> e.name().toLowerCase(Locale.ROOT));
        }
    }

    private record Initializer(@Nullable BlockParticleExpression size, @Nullable BlockParticleExpression lifetime, @Nullable BlockParticleExpression red, @Nullable BlockParticleExpression green, @Nullable BlockParticleExpression blue, @Nullable BlockParticleExpression alpha, @Nullable BlockParticleExpression roll, @Nullable BlockParticleExpression friction, boolean hasPhysics) {
        private static final Codec<Initializer> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(BlockParticleExpression.CODEC, "size").forGetter(p -> Optional.ofNullable(p.size)), (App)StrOpt.of(BlockParticleExpression.CODEC, "lifetime").forGetter(p -> Optional.ofNullable(p.lifetime)), (App)StrOpt.of(BlockParticleExpression.CODEC, "red").forGetter(p -> Optional.ofNullable(p.red)), (App)StrOpt.of(BlockParticleExpression.CODEC, "green").forGetter(p -> Optional.ofNullable(p.green)), (App)StrOpt.of(BlockParticleExpression.CODEC, "blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)StrOpt.of(BlockParticleExpression.CODEC, "alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)StrOpt.of(BlockParticleExpression.CODEC, "roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)StrOpt.of(BlockParticleExpression.CODEC, "friction").forGetter(p -> Optional.ofNullable(p.friction)), (App)Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(p -> p.hasPhysics)).apply((Applicative)i, Initializer::new));

        private Initializer(Optional<BlockParticleExpression> size, Optional<BlockParticleExpression> lifetime, Optional<BlockParticleExpression> red, Optional<BlockParticleExpression> green, Optional<BlockParticleExpression> blue, Optional<BlockParticleExpression> alpha, Optional<BlockParticleExpression> roll, Optional<BlockParticleExpression> friction, boolean hasPhysics) {
            this((BlockParticleExpression)size.orElse(null), (BlockParticleExpression)lifetime.orElse(null), (BlockParticleExpression)red.orElse(null), (BlockParticleExpression)green.orElse(null), (BlockParticleExpression)blue.orElse(null), (BlockParticleExpression)alpha.orElse(null), (BlockParticleExpression)roll.orElse(null), (BlockParticleExpression)friction.orElse(null), hasPhysics);
        }
    }

    private record Ticker(@Nullable ParticleExpression x, @Nullable ParticleExpression y, @Nullable ParticleExpression z, @Nullable ParticleExpression dx, @Nullable ParticleExpression dy, @Nullable ParticleExpression dz, @Nullable ParticleExpression size, @Nullable ParticleExpression red, @Nullable ParticleExpression green, @Nullable ParticleExpression blue, @Nullable ParticleExpression alpha, @Nullable ParticleExpression roll) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(ParticleExpression.CODEC, "x").forGetter(p -> Optional.ofNullable(p.x)), (App)StrOpt.of(ParticleExpression.CODEC, "y").forGetter(p -> Optional.ofNullable(p.y)), (App)StrOpt.of(ParticleExpression.CODEC, "z").forGetter(p -> Optional.ofNullable(p.z)), (App)StrOpt.of(ParticleExpression.CODEC, "dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)StrOpt.of(ParticleExpression.CODEC, "dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)StrOpt.of(ParticleExpression.CODEC, "dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)StrOpt.of(ParticleExpression.CODEC, "size").forGetter(p -> Optional.ofNullable(p.size)), (App)StrOpt.of(ParticleExpression.CODEC, "red").forGetter(p -> Optional.ofNullable(p.red)), (App)StrOpt.of(ParticleExpression.CODEC, "green").forGetter(p -> Optional.ofNullable(p.green)), (App)StrOpt.of(ParticleExpression.CODEC, "blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)StrOpt.of(ParticleExpression.CODEC, "alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)StrOpt.of(ParticleExpression.CODEC, "roll").forGetter(p -> Optional.ofNullable(p.alpha))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<ParticleExpression> x, Optional<ParticleExpression> y, Optional<ParticleExpression> z, Optional<ParticleExpression> dx, Optional<ParticleExpression> dy, Optional<ParticleExpression> dz, Optional<ParticleExpression> size, Optional<ParticleExpression> red, Optional<ParticleExpression> green, Optional<ParticleExpression> blue, Optional<ParticleExpression> alpha, Optional<ParticleExpression> roll) {
            this((ParticleExpression)x.orElse(null), (ParticleExpression)y.orElse(null), (ParticleExpression)z.orElse(null), (ParticleExpression)dx.orElse(null), (ParticleExpression)dy.orElse(null), (ParticleExpression)dz.orElse(null), (ParticleExpression)size.orElse(null), (ParticleExpression)red.orElse(null), (ParticleExpression)green.orElse(null), (ParticleExpression)blue.orElse(null), (ParticleExpression)alpha.orElse(null), (ParticleExpression)roll.orElse(null));
        }
    }

    public static class Instance
    extends class_4003 {
        private final class_3999 renderType;
        @Nullable
        private final Ticker ticker;
        private final class_4002 spriteSet;
        private float oQuadSize;

        protected Instance(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state, CustomParticleType type) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.renderType = type.renderType.get();
            this.ticker = type.ticker;
            this.spriteSet = type.spriteSet;
            Initializer initializer = type.initializer;
            if (initializer != null) {
                class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
                if (initializer.roll != null) {
                    this.field_3839 = (float)initializer.roll.getValue((class_1937)level, pos, state);
                }
                if (initializer.size != null) {
                    this.method_3087((float)initializer.size.getValue((class_1937)level, pos, state));
                }
                if (initializer.red != null) {
                    this.field_3861 = (float)initializer.red.getValue((class_1937)level, pos, state);
                }
                if (initializer.green != null) {
                    this.field_3842 = (float)initializer.green.getValue((class_1937)level, pos, state);
                }
                if (initializer.blue != null) {
                    this.field_3859 = (float)initializer.blue.getValue((class_1937)level, pos, state);
                }
                if (initializer.alpha != null) {
                    this.field_3841 = (float)initializer.alpha.getValue((class_1937)level, pos, state);
                }
                if (initializer.lifetime != null) {
                    this.field_3847 = (int)initializer.lifetime.getValue((class_1937)level, pos, state);
                }
                if (initializer.friction != null) {
                    this.field_28786 = (float)initializer.friction.getValue((class_1937)level, pos, state);
                }
                this.field_3862 = initializer.hasPhysics;
            }
            this.method_18142(this.spriteSet);
        }

        public void method_3070() {
            this.method_18142(this.spriteSet);
            super.method_3070();
            if (this.ticker != null) {
                if (this.ticker.roll != null) {
                    this.field_3857 = this.field_3839;
                    this.field_3839 = (float)this.ticker.roll.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.size != null) {
                    this.oQuadSize = this.field_17867;
                    this.field_17867 = (float)this.ticker.size.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.red != null) {
                    this.field_3861 = (float)this.ticker.red.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.green != null) {
                    this.field_3842 = (float)this.ticker.green.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.blue != null) {
                    this.field_3859 = (float)this.ticker.blue.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.alpha != null) {
                    this.field_3841 = (float)this.ticker.alpha.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.x != null) {
                    this.field_3874 = this.ticker.x.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.y != null) {
                    this.field_3854 = this.ticker.y.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.z != null) {
                    this.field_3871 = this.ticker.z.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.dx != null) {
                    this.field_3852 = this.ticker.dx.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.dy != null) {
                    this.field_3869 = this.ticker.dy.get((class_703)this, (class_1937)this.field_3851);
                }
                if (this.ticker.dz != null) {
                    this.field_3850 = this.ticker.dz.get((class_703)this, (class_1937)this.field_3851);
                }
            }
        }

        public float method_18132(float scaleFactor) {
            return class_3532.method_16439((float)scaleFactor, (float)this.oQuadSize, (float)this.field_17867);
        }

        public class_3999 method_18122() {
            return this.renderType;
        }
    }
}

