/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.block.BlockPropertyModifier;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColormapNumberProvider;
import net.mehvahdjukaar.polytone.utils.ArrayImage;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.StrOpt;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2457;
import net.minecraft.class_2513;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_322;
import net.minecraft.class_7923;

public class LegacyHelper {
    private static final Map<String, String> PATHS = (Map)class_156.method_654((Object)new Object2ObjectOpenHashMap(), m -> {
        m.put((Object)"world0", (Object)"overworld");
        m.put((Object)"world0_thunder", (Object)"overworld_thunder");
        m.put((Object)"world0_rain", (Object)"overworld_rain");
        m.put((Object)"world1", (Object)"the_end");
        m.put((Object)"world-1", (Object)"the_nether");
        m.put((Object)"pine", (Object)"spruce_leaves");
        m.put((Object)"birch", (Object)"birch_leaves");
        m.put((Object)"redstone", (Object)"redstone_wire");
        m.put((Object)"pumpkinstem", (Object)"pumpkin_stem");
        m.put((Object)"melonstem", (Object)"melon_stem");
        m.put((Object)"underwater", (Object)"water_fog");
    });
    public static final Decoder<BlockPropertyModifier> OF_JSON_CODEC = RecordCodecBuilder.create(i -> i.group((App)StrOpt.of(Codec.STRING, "format", "").forGetter(c -> ""), (App)StrOpt.of(Codec.STRING.listOf(), "blocks", List.of()).forGetter(c -> List.of()), (App)StrOpt.of(ColorUtils.CODEC, "color").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING.xmap(Integer::parseInt, String::valueOf), "yVariance").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING.xmap(Integer::parseInt, String::valueOf), "yoffset").forGetter(c -> Optional.empty()), (App)StrOpt.of(Codec.STRING, "source").forGetter(c -> Optional.empty())).apply((Applicative)i, LegacyHelper::decodeOFPropertyJson));
    private static final Object2IntMap<class_2960> BIOME_ID_MAP = (Object2IntMap)class_156.method_656(() -> {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        map.put((Object)new class_2960("the_void"), 0);
        map.put((Object)new class_2960("plains"), 1);
        map.put((Object)new class_2960("sunflower_plains"), 2);
        map.put((Object)new class_2960("snowy_plains"), 3);
        map.put((Object)new class_2960("ice_spikes"), 4);
        map.put((Object)new class_2960("desert"), 5);
        map.put((Object)new class_2960("swamp"), 6);
        map.put((Object)new class_2960("mangrove_swamp"), 7);
        map.put((Object)new class_2960("forest"), 8);
        map.put((Object)new class_2960("flower_forest"), 9);
        map.put((Object)new class_2960("birch_forest"), 10);
        map.put((Object)new class_2960("dark_forest"), 11);
        map.put((Object)new class_2960("old_growth_birch_forest"), 12);
        map.put((Object)new class_2960("old_growth_pine_taiga"), 13);
        map.put((Object)new class_2960("old_growth_spruce_taiga"), 14);
        map.put((Object)new class_2960("taiga"), 15);
        map.put((Object)new class_2960("snowy_taiga"), 16);
        map.put((Object)new class_2960("savanna"), 17);
        map.put((Object)new class_2960("savanna_plateau"), 18);
        map.put((Object)new class_2960("windswept_hills"), 19);
        map.put((Object)new class_2960("windswept_gravelly_hills"), 20);
        map.put((Object)new class_2960("windswept_forest"), 21);
        map.put((Object)new class_2960("windswept_savanna"), 22);
        map.put((Object)new class_2960("jungle"), 23);
        map.put((Object)new class_2960("sparse_jungle"), 24);
        map.put((Object)new class_2960("bamboo_jungle"), 25);
        map.put((Object)new class_2960("badlands"), 26);
        map.put((Object)new class_2960("eroded_badlands"), 27);
        map.put((Object)new class_2960("wooded_badlands"), 28);
        map.put((Object)new class_2960("meadow"), 29);
        map.put((Object)new class_2960("cherry_grove"), 30);
        map.put((Object)new class_2960("grove"), 31);
        map.put((Object)new class_2960("snowy_slopes"), 32);
        map.put((Object)new class_2960("frozen_peaks"), 33);
        map.put((Object)new class_2960("jagged_peaks"), 34);
        map.put((Object)new class_2960("stony_peaks"), 35);
        map.put((Object)new class_2960("river"), 36);
        map.put((Object)new class_2960("frozen_river"), 37);
        map.put((Object)new class_2960("beach"), 38);
        map.put((Object)new class_2960("snowy_beach"), 39);
        map.put((Object)new class_2960("stony_shore"), 40);
        map.put((Object)new class_2960("warm_ocean"), 41);
        map.put((Object)new class_2960("lukewarm_ocean"), 42);
        map.put((Object)new class_2960("deep_lukewarm_ocean"), 43);
        map.put((Object)new class_2960("ocean"), 44);
        map.put((Object)new class_2960("deep_ocean"), 45);
        map.put((Object)new class_2960("cold_ocean"), 46);
        map.put((Object)new class_2960("deep_cold_ocean"), 47);
        map.put((Object)new class_2960("frozen_ocean"), 48);
        map.put((Object)new class_2960("deep_frozen_ocean"), 49);
        map.put((Object)new class_2960("mushroom_fields"), 50);
        map.put((Object)new class_2960("dripstone_caves"), 51);
        map.put((Object)new class_2960("lush_caves"), 52);
        map.put((Object)new class_2960("deep_dark"), 53);
        map.put((Object)new class_2960("nether_wastes"), 54);
        map.put((Object)new class_2960("warped_forest"), 55);
        map.put((Object)new class_2960("crimson_forest"), 56);
        map.put((Object)new class_2960("soul_sand_valley"), 57);
        map.put((Object)new class_2960("basalt_deltas"), 58);
        map.put((Object)new class_2960("the_end"), 59);
        map.put((Object)new class_2960("end_highlands"), 60);
        map.put((Object)new class_2960("end_midlands"), 61);
        map.put((Object)new class_2960("small_end_islands"), 62);
        map.put((Object)new class_2960("end_barrens"), 63);
        return map;
    });

    public static <T> Map<class_2960, T> convertPaths(Map<class_2960, T> map) {
        HashMap<class_2960, T> toUpdate = new HashMap<class_2960, T>();
        ArrayList<class_2960> toRemove = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, T> entry : map.entrySet()) {
            class_2960 id = entry.getKey();
            String path = id.method_12832();
            String newPath = PATHS.get(path);
            if (newPath == null) continue;
            toUpdate.put(id.method_45136(newPath), entry.getValue());
            toRemove.add(id);
        }
        toRemove.forEach(map.keySet()::remove);
        map.putAll(toUpdate);
        return map;
    }

    public static Map<class_2960, BlockPropertyModifier> convertBlockProperties(Map<class_2960, Properties> ofProperties, Map<class_2960, ArrayImage> textures) {
        ArrayList<class_2960> ids = new ArrayList<class_2960>();
        ids.addAll(ofProperties.keySet());
        ids.addAll(textures.keySet());
        HashMap<class_2960, BlockPropertyModifier> map = new HashMap<class_2960, BlockPropertyModifier>();
        for (class_2960 id : ids) {
            Colormap colormap;
            Properties prop = ofProperties.get(id);
            String path = id.method_12832();
            if (path.equals("stem") || path.equals("melon_stem") || path.equals("pumpkin_stem")) {
                colormap = Colormap.simple((state, level, pos, m) -> state != null && state.method_28498((class_2769)class_2513.field_11584) ? (float)((Integer)state.method_11654((class_2769)class_2513.field_11584)).intValue() / 7.0f : 0.0f, IColormapNumberProvider.ZERO);
                ArrayList<class_2248> targets = new ArrayList<class_2248>();
                if (!path.contains("melon")) {
                    targets.add(class_2246.field_46286);
                    targets.add(class_2246.field_46284);
                }
                if (!path.contains("pumpkin")) {
                    targets.add(class_2246.field_46287);
                    targets.add(class_2246.field_46285);
                }
                map.put(id, BlockPropertyModifier.coloringBlocks((class_322)colormap, targets));
                continue;
            }
            if (path.equals("redstone_wire")) {
                colormap = Colormap.simple((state, level, pos, m) -> state != null ? (float)((Integer)state.method_11654((class_2769)class_2457.field_11432)).intValue() / 15.0f : 0.0f, IColormapNumberProvider.ZERO);
                map.put(id, BlockPropertyModifier.coloringBlocks((class_322)colormap, class_2246.field_10091));
                continue;
            }
            if (prop == null) continue;
            BlockPropertyModifier modifier = LegacyHelper.convertOFProperty(prop, id);
            map.put(id, modifier);
        }
        return map;
    }

    private static BlockPropertyModifier decodeOFPropertyJson(String format, List<String> targets, Optional<Integer> singleColor, Optional<Integer> yVariance, Optional<Integer> yoffset, Optional<String> sourceTexture) {
        Set<class_2960> set = null;
        if (!targets.isEmpty()) {
            set = targets.stream().filter(s -> {
                try {
                    int iHateOptishit = Integer.parseInt(s);
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }).map(class_2960::new).collect(Collectors.toSet());
            set.forEach(LegacyHelper::forceBlockToHaveTintIndex);
        }
        Integer col = singleColor.orElse(null);
        Colormap colormap = "fixed".equals(format) ? Colormap.fixed() : ("grid".equals(format) ? Colormap.biomeId() : Colormap.defTriangle());
        if (col != null) {
            int[][] matrix = new int[][]{{col}};
            colormap.acceptTexture(new ArrayImage(matrix));
        } else if (sourceTexture.isPresent()) {
            class_2960 id = new class_2960("none");
            String source = sourceTexture.get().replace("~/colormap/", id.method_12836() + ":");
            if (source.contains("./")) {
                String path = id.method_12832();
                int index = path.lastIndexOf(47);
                String directoryPath = index == -1 ? "" : path.substring(0, index + 1);
                source = source.replace("./", id.method_12836() + ":" + directoryPath);
            }
            colormap.setTargetTexture(new class_2960(source));
        }
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(set));
    }

    public static BlockPropertyModifier convertOFProperty(Properties properties, class_2960 id) {
        Set<class_2960> set = null;
        String targets = properties.getProperty("blocks");
        if (targets != null) {
            set = Arrays.stream(targets.split(" ")).filter(s -> {
                try {
                    int iHateOptishit = Integer.parseInt(s);
                    return false;
                }
                catch (Exception exception) {
                    return true;
                }
            }).map(class_2960::new).collect(Collectors.toSet());
            set.forEach(LegacyHelper::forceBlockToHaveTintIndex);
        }
        String format = properties.getProperty("format");
        Integer col = null;
        String singleColor = properties.getProperty("color");
        if (singleColor != null) {
            col = Integer.parseInt(singleColor, 16);
        }
        Colormap colormap = "fixed".equals(format) ? Colormap.fixed() : ("grid".equals(format) ? Colormap.biomeId() : Colormap.defTriangle());
        if (col != null) {
            int[][] matrix = new int[][]{{col}};
            colormap.acceptTexture(new ArrayImage(matrix));
        } else {
            Object source = properties.getProperty("source");
            if (source != null) {
                if (((String)source).contains("~")) {
                    source = ((String)source).replace("~/colormap/", id.method_12836() + ":");
                } else {
                    String path = id.method_12832();
                    int index = path.lastIndexOf(47);
                    String directoryPath = index == -1 ? "" : path.substring(0, index + 1);
                    source = id.method_12836() + ":" + directoryPath + ((String)source).replace("./", "");
                }
                colormap.setTargetTexture(new class_2960((String)source));
            }
        }
        return new BlockPropertyModifier(Optional.of(colormap), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.ofNullable(set));
    }

    public static Map<class_2960, BlockPropertyModifier> convertInlinedPalettes(Map<class_2960, String> inlineColormaps) {
        HashMap<class_2960, BlockPropertyModifier> map = new HashMap<class_2960, BlockPropertyModifier>();
        int k = 0;
        for (Map.Entry<class_2960, String> special : inlineColormaps.entrySet()) {
            class_2960 texturePath = special.getKey();
            Colormap colormap = Colormap.defTriangle();
            colormap.setTargetTexture(texturePath);
            HashSet<class_2960> blockTargets = new HashSet<class_2960>();
            for (String name : special.getValue().split(" ")) {
                if (name.isEmpty()) continue;
                class_2960 blockId = new class_2960(name);
                blockTargets.add(blockId);
                LegacyHelper.forceBlockToHaveTintIndex(blockId);
            }
            if (blockTargets.isEmpty()) continue;
            BlockPropertyModifier mod = BlockPropertyModifier.coloringBlocks((class_322)colormap, blockTargets);
            map.put(texturePath.method_48331("-color_prop_palette_" + k++), mod);
        }
        return map;
    }

    private static void forceBlockToHaveTintIndex(class_2960 blockId) {
        class_2248 block;
        Optional b = class_7923.field_41175.method_17966(blockId);
        if (b.isPresent() && (block = (class_2248)b.get()) != class_2246.field_10091 && block != class_2246.field_46286 && block != class_2246.field_46287) {
            Polytone.VARIANT_TEXTURES.addTintOverrideHack(block);
        }
    }

    public static int getBiomeId(class_1959 biome, class_2378<class_1959> biomeRegistry) {
        class_2960 id = biomeRegistry.method_10221((Object)biome);
        return BIOME_ID_MAP.getOrDefault((Object)id, 0);
    }

    public static void convertOfBlockToFluidProp(Map<class_2960, BlockPropertyModifier> parsedModifiers, Map<class_2960, ArrayImage> textures) {
        Record modifier;
        class_2960 id;
        HashMap<class_2960, BlockPropertyModifier> filtered = new HashMap<class_2960, BlockPropertyModifier>();
        HashMap<class_2960, ArrayImage> filteredTextures = new HashMap<class_2960, ArrayImage>();
        for (Map.Entry<class_2960, BlockPropertyModifier> entry : parsedModifiers.entrySet()) {
            id = entry.getKey();
            modifier = entry.getValue();
            if (!id.method_12832().contains("water") && !id.method_12832().contains("lava")) continue;
            filtered.put(id, (BlockPropertyModifier)modifier);
        }
        for (Map.Entry<class_2960, Record> entry : textures.entrySet()) {
            id = entry.getKey();
            modifier = (ArrayImage)entry.getValue();
            if (!id.method_12832().contains("water") && !id.method_12832().contains("lava")) continue;
            filteredTextures.put(id, (ArrayImage)modifier);
        }
        textures.keySet().removeAll(filteredTextures.keySet());
        parsedModifiers.keySet().removeAll(filtered.keySet());
        Polytone.FLUID_PROPERTIES.addConvertedBlockProperties(filtered, filteredTextures);
    }
}

