/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background;

import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundRegistry;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackground;
import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.TooltipHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseMenuBackgroundScreen
extends class_437 {
    protected static final MenuBackgroundBuilder<ImageMenuBackground> NO_BACKGROUND_TYPE = new ImageMenuBackgroundBuilder();
    public static final MenuBackground NO_BACKGROUND = new ImageMenuBackground(NO_BACKGROUND_TYPE);
    protected MenuBackgroundBuilder<?> backgroundType;
    protected MenuBackground background;
    protected Consumer<MenuBackground> callback;
    protected ScrollArea backgroundTypeListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ScrollArea backgroundDescriptionScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton configureButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton cancelButton;

    public ChooseMenuBackgroundScreen(@Nullable MenuBackground backgroundToEdit, boolean addResetBackgroundEntry, @NotNull Consumer<MenuBackground> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.menu_background.choose"));
        this.background = backgroundToEdit;
        this.callback = callback;
        this.setContentOfBackgroundTypeList(addResetBackgroundEntry);
        if (this.background != null) {
            for (ScrollAreaEntry e : this.backgroundTypeListScrollArea.getEntries()) {
                if (!(e instanceof BackgroundTypeScrollEntry) || ((BackgroundTypeScrollEntry)e).backgroundType != this.background.builder) continue;
                e.setSelected(true);
                this.backgroundType = this.background.builder;
                this.setDescription(this.backgroundType);
                break;
            }
        }
        if (this.backgroundType == null) {
            this.background = null;
            if (addResetBackgroundEntry) {
                this.backgroundTypeListScrollArea.getEntries().get(0).setSelected(true);
                this.backgroundType = NO_BACKGROUND_TYPE;
                this.background = NO_BACKGROUND;
                this.setDescription(NO_BACKGROUND_TYPE);
            }
        }
    }

    protected void method_25426() {
        this.configureButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.menu_background.choose.configure_background"), button -> {
            if (this.backgroundType != null) {
                this.backgroundType.buildNewOrEditInstanceInternal(this, this.background, back -> {
                    if (back != null) {
                        this.background = back;
                    }
                });
            }
        }){

            @Override
            public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                if (ChooseMenuBackgroundScreen.this.backgroundType == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((class_339)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.choose.not_background_selected", new String[0])).setDefaultStyle(), false, true);
                    this.field_22763 = false;
                } else {
                    this.field_22763 = ChooseMenuBackgroundScreen.this.backgroundType != NO_BACKGROUND_TYPE;
                }
                super.method_25394(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429((class_364)this.configureButton);
        UIBase.applyDefaultWidgetSkinTo(this.configureButton);
        this.doneButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.done"), button -> this.callback.accept(this.background)){

            @Override
            public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                if (ChooseMenuBackgroundScreen.this.backgroundType == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((class_339)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.choose.not_background_selected", new String[0])).setDefaultStyle(), false, true);
                    this.field_22763 = false;
                } else if (ChooseMenuBackgroundScreen.this.background == null) {
                    TooltipHandler.INSTANCE.addWidgetTooltip((class_339)this, Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.choose.not_configured", new String[0])).setDefaultStyle(), false, true);
                    this.field_22763 = false;
                } else {
                    this.field_22763 = true;
                }
                super.method_48579(graphics, mouseX, mouseY, partial);
            }
        };
        this.method_25429((class_364)this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);
        this.cancelButton = new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.guicomponents.cancel"), button -> this.callback.accept(null));
        this.method_25429((class_364)this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);
        this.setDescription(this.backgroundType);
    }

    public void method_25419() {
        this.callback.accept(null);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"fancymenu.menu_background.choose.available_types"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.backgroundTypeListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.backgroundTypeListScrollArea.setHeight(this.field_22790 - 85, true);
        this.backgroundTypeListScrollArea.setX(20, true);
        this.backgroundTypeListScrollArea.setY(65, true);
        this.backgroundTypeListScrollArea.render(graphics, mouseX, mouseY, partial);
        class_5250 descLabel = class_2561.method_43471((String)"fancymenu.menu_background.choose.type_description");
        int descLabelWidth = this.field_22793.method_27525((class_5348)descLabel);
        graphics.method_51439(this.field_22793, (class_2561)descLabel, this.field_22789 - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        this.backgroundDescriptionScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.backgroundDescriptionScrollArea.setHeight(Math.max(40, this.field_22790 / 2 - 50 - 25), true);
        this.backgroundDescriptionScrollArea.setX(this.field_22789 - 20 - this.backgroundDescriptionScrollArea.getWidthWithBorder(), true);
        this.backgroundDescriptionScrollArea.setY(65, true);
        this.backgroundDescriptionScrollArea.render(graphics, mouseX, mouseY, partial);
        this.doneButton.method_46421(this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.method_46419(this.field_22790 - 20 - 20);
        this.doneButton.method_25394(graphics, mouseX, mouseY, partial);
        this.cancelButton.method_46421(this.field_22789 - 20 - this.cancelButton.method_25368());
        this.cancelButton.method_46419(this.doneButton.method_46427() - 5 - 20);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, partial);
        this.configureButton.method_46421(this.field_22789 - 20 - this.configureButton.method_25368());
        this.configureButton.method_46419(this.cancelButton.method_46427() - 15 - 20);
        this.configureButton.method_25394(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 $$0, int $$1, int $$2, float $$3) {
    }

    protected void setDescription(@Nullable MenuBackgroundBuilder<?> builder) {
        this.backgroundDescriptionScrollArea.clearEntries();
        if (builder == NO_BACKGROUND_TYPE) {
            return;
        }
        if (builder != null && builder.getDescription() != null) {
            for (class_2561 c : builder.getDescription()) {
                TextScrollAreaEntry e = new TextScrollAreaEntry(this.backgroundDescriptionScrollArea, (class_2561)c.method_27661().method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt())), entry -> {});
                e.setSelectable(false);
                e.setBackgroundColorHover(e.getBackgroundColorIdle());
                e.setPlayClickSound(false);
                this.backgroundDescriptionScrollArea.addEntry(e);
            }
        }
    }

    protected void setContentOfBackgroundTypeList(boolean addResetBackgroundEntry) {
        this.backgroundTypeListScrollArea.clearEntries();
        if (addResetBackgroundEntry) {
            BackgroundTypeScrollEntry e = new BackgroundTypeScrollEntry(this.backgroundTypeListScrollArea, NO_BACKGROUND_TYPE, entry -> {
                if (this.backgroundType != NO_BACKGROUND_TYPE) {
                    this.backgroundType = NO_BACKGROUND_TYPE;
                    this.background = NO_BACKGROUND;
                    this.setDescription(NO_BACKGROUND_TYPE);
                }
            });
            this.backgroundTypeListScrollArea.addEntry(e);
        }
        for (MenuBackgroundBuilder<?> b : MenuBackgroundRegistry.getBuilders()) {
            if (LayoutEditorScreen.getCurrentInstance() != null && !b.shouldShowUpInEditorBackgroundMenu(LayoutEditorScreen.getCurrentInstance())) continue;
            BackgroundTypeScrollEntry e = new BackgroundTypeScrollEntry(this.backgroundTypeListScrollArea, b, entry -> {
                if (this.backgroundType != b) {
                    this.backgroundType = b;
                    this.background = null;
                    this.setDescription(b);
                }
            });
            this.backgroundTypeListScrollArea.addEntry(e);
        }
    }

    public boolean method_25404(int button, int $$1, int $$2) {
        if (button == 257 && this.background != null) {
            this.callback.accept(this.background);
            return true;
        }
        return super.method_25404(button, $$1, $$2);
    }

    public static class BackgroundTypeScrollEntry
    extends TextListScrollAreaEntry {
        public MenuBackgroundBuilder<?> backgroundType;
        @Nullable
        public Supplier<Tooltip> tooltipSupplier = null;

        public BackgroundTypeScrollEntry(ScrollArea parent, @NotNull MenuBackgroundBuilder<?> backgroundType, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, BackgroundTypeScrollEntry.getText(backgroundType), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.backgroundType = backgroundType;
            if (this.backgroundType.isDeprecated()) {
                this.tooltipSupplier = () -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.menu_background.deprecated.details", new String[0])).setDefaultStyle().setTextBaseColor(UIBase.getUIColorTheme().warning_text_color);
            }
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {
            Tooltip t;
            if (this.tooltipSupplier != null && (t = this.tooltipSupplier.get()) != null) {
                TooltipHandler.INSTANCE.addTooltip(t, this::isHovered, false, true);
            }
            super.method_25394(graphics, mouseX, mouseY, partial);
        }

        private static class_2561 getText(MenuBackgroundBuilder<?> backgroundType) {
            if (backgroundType == NO_BACKGROUND_TYPE) {
                return class_2561.method_43471((String)"fancymenu.menu_background.choose.entry.no_background").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            }
            class_5250 c = backgroundType.getDisplayName().method_27661().method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            if (backgroundType.isDeprecated()) {
                c.method_10852((class_2561)class_2561.method_43471((String)"fancymenu.menu_background.deprecated").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt())));
            }
            return c;
        }
    }
}

