/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.cycle;

import de.keksuccino.fancymenu.util.cycle.IValueCycle;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ValueCycle<T>
implements IValueCycle<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    protected List<T> values = new ArrayList<T>();
    protected int currentIndex = 0;
    protected List<Consumer<T>> cycleListeners = new ArrayList<Consumer<T>>();

    public static <T> ValueCycle<T> fromList(@NotNull List<T> values) {
        Objects.requireNonNull(values);
        if (values.size() < 2) {
            throw new InvalidParameterException("Failed to create ValueCycle! Value list size too small (<2)!");
        }
        ValueCycle<T> valueCycle = new ValueCycle<T>();
        valueCycle.values.addAll(values);
        return valueCycle;
    }

    @SafeVarargs
    public static <T> ValueCycle<T> fromArray(T ... values) {
        Objects.requireNonNull(values);
        return ValueCycle.fromList(Arrays.asList(values));
    }

    protected ValueCycle() {
    }

    @Override
    public List<T> getValues() {
        return new ArrayList<T>(this.values);
    }

    @Override
    public ValueCycle<T> removeValue(@NotNull T value) {
        if (this.values.size() == 2) {
            LOGGER.error("Unable to remove value! At least 2 values needed!");
            return this;
        }
        this.values.remove(value);
        this.setCurrentValueByIndex(0, false);
        return this;
    }

    @Override
    @NotNull
    public T current() {
        return this.values.get(this.currentIndex);
    }

    @Override
    @NotNull
    public T next() {
        this.currentIndex = this.currentIndex >= this.values.size() - 1 ? 0 : ++this.currentIndex;
        this.notifyListeners();
        return this.current();
    }

    @Override
    public ValueCycle<T> setCurrentValue(T value, boolean notifyListeners) {
        int i = this.values.indexOf(value);
        if (i != -1) {
            this.currentIndex = i;
            if (notifyListeners) {
                this.notifyListeners();
            }
        }
        return this;
    }

    @Override
    public ValueCycle<T> setCurrentValue(T value) {
        return this.setCurrentValue((Object)value, true);
    }

    @Override
    public ValueCycle<T> setCurrentValueByIndex(int index, boolean notifyListeners) {
        if (index > 0 && index < this.values.size()) {
            this.currentIndex = index;
            if (notifyListeners) {
                this.notifyListeners();
            }
        }
        return this;
    }

    @Override
    public ValueCycle<T> setCurrentValueByIndex(int index) {
        return this.setCurrentValueByIndex(index, true);
    }

    @Override
    public ValueCycle<T> addCycleListener(@NotNull Consumer<T> listener) {
        this.cycleListeners.add(listener);
        return this;
    }

    @Override
    public ValueCycle<T> clearCycleListeners() {
        this.cycleListeners.clear();
        return this;
    }

    protected void notifyListeners() {
        for (Consumer<T> listener : this.cycleListeners) {
            listener.accept(this.current());
        }
    }
}

