/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser;

import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.FileFilter;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.filebrowser.AbstractFileBrowserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.io.File;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveFileScreen
extends AbstractFileBrowserScreen {
    protected static final class_2561 FILE_NAME_PREFIX_TEXT = class_2561.method_43471((String)"fancymenu.file_browser.save_file.file_name");
    @Nullable
    protected String forcedFileExtension;
    protected String defaultFileName;
    protected boolean forceResourceFriendlyFileNames = true;
    protected ExtendedEditBox fileNameEditBox;

    @NotNull
    public static SaveFileScreen build(@NotNull File rootDirectory, @Nullable String fileNamePreset, @Nullable String forcedFileExtension, @NotNull Consumer<File> callback) {
        return new SaveFileScreen(rootDirectory, rootDirectory, fileNamePreset, forcedFileExtension, callback);
    }

    public SaveFileScreen(@Nullable File rootDirectory, @NotNull File startDirectory, @Nullable String fileNamePreset, @Nullable String forcedFileExtension, @NotNull Consumer<File> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.ui.save_file"), rootDirectory, startDirectory, callback);
        this.forcedFileExtension = forcedFileExtension;
        if (this.forcedFileExtension != null) {
            if (this.forcedFileExtension.startsWith(".")) {
                this.forcedFileExtension = this.forcedFileExtension.substring(1);
            }
            this.fileFilter = file -> file.getName().toLowerCase().endsWith("." + this.forcedFileExtension.toLowerCase());
        }
        this.fileNameEditBox = new ExtendedEditBox(class_310.method_1551().field_1772, 0, 0, 150, 18, (class_2561)class_2561.method_43471((String)"fancymenu.ui.save_file.file_name"));
        if (this.forcedFileExtension != null) {
            this.fileNameEditBox.setInputSuffix("." + this.forcedFileExtension.toLowerCase());
            this.fileNameEditBox.applyInputPrefixSuffixCharacterRenderFormatter();
        }
        this.fileNameEditBox.method_1880(10000);
        UIBase.applyDefaultWidgetSkinTo(this.fileNameEditBox);
        Object editBoxPresetValue = "new_file";
        if (fileNamePreset != null) {
            if (this.forcedFileExtension != null && fileNamePreset.toLowerCase().endsWith("." + this.forcedFileExtension.toLowerCase())) {
                fileNamePreset = fileNamePreset.substring(0, Math.max(1, fileNamePreset.length() - (this.forcedFileExtension.length() + 1)));
            }
            editBoxPresetValue = fileNamePreset;
        }
        if (this.forcedFileExtension != null) {
            editBoxPresetValue = (String)editBoxPresetValue + "." + this.forcedFileExtension;
        }
        this.fileNameEditBox.method_1852((String)editBoxPresetValue);
        this.fileNameEditBox.method_1875(0);
        this.fileNameEditBox.method_1884(0);
        this.fileNameEditBox.setDisplayPosition(0);
        this.defaultFileName = editBoxPresetValue;
        this.setForceResourceFriendlyFileNames(true);
        this.fileScrollListHeightOffset = -25;
        this.fileTypeScrollListYOffset = 25;
    }

    @Override
    protected void method_25426() {
        this.method_25429((class_364)this.fileNameEditBox);
        super.method_25426();
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.forcedFileExtension != null && !this.fileNameEditBox.method_1882().toLowerCase().endsWith("." + this.forcedFileExtension.toLowerCase())) {
            this.fileNameEditBox.method_1852(this.defaultFileName);
        }
        super.method_25394(graphics, mouseX, mouseY, partial);
        this.renderFileNameEditBox(graphics, mouseX, mouseY, partial);
    }

    protected void renderFileNameEditBox(class_332 graphics, int mouseX, int mouseY, float partial) {
        this.fileNameEditBox.method_25358(this.getBelowFileScrollAreaElementWidth() - 2);
        this.fileNameEditBox.method_46421(this.fileListScrollArea.getXWithBorder() + this.fileListScrollArea.getWidthWithBorder() - this.fileNameEditBox.method_25368() - 1);
        this.fileNameEditBox.method_46419(this.fileListScrollArea.getYWithBorder() + this.fileListScrollArea.getHeightWithBorder() + 5 + 1);
        this.fileNameEditBox.method_25394(graphics, mouseX, mouseY, partial);
        int n = this.fileNameEditBox.method_46426() - 1 - class_310.method_1551().field_1772.method_27525((class_5348)FILE_NAME_PREFIX_TEXT) - 5;
        int n2 = this.fileNameEditBox.method_46427() - 1 + this.fileNameEditBox.method_25364() / 2;
        Objects.requireNonNull(class_310.method_1551().field_1772);
        graphics.method_51439(this.field_22793, FILE_NAME_PREFIX_TEXT, n, n2 - 9 / 2, UIBase.getUIColorTheme().element_label_color_normal.getColorInt(), false);
    }

    @Override
    protected int getBelowFileScrollAreaElementWidth() {
        int w = this.fileListScrollArea.getWidthWithBorder() - class_310.method_1551().field_1772.method_27525((class_5348)FILE_NAME_PREFIX_TEXT) - 5;
        return Math.min(super.getBelowFileScrollAreaElementWidth(), w);
    }

    @Override
    @NotNull
    protected ExtendedButton buildConfirmButton() {
        return new ExtendedButton(0, 0, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.ui.save_file.save"), button -> this.trySave()){

            @Override
            public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
                AbstractFileBrowserScreen.AbstractFileScrollAreaEntry selected = SaveFileScreen.this.getSelectedEntry();
                this.field_22763 = SaveFileScreen.this.canSave();
                super.method_25394(graphics, mouseX, mouseY, partial);
            }
        };
    }

    @Override
    public AbstractFileBrowserScreen setFileFilter(@Nullable FileFilter fileFilter) {
        if (this.forcedFileExtension == null) {
            return super.setFileFilter(fileFilter);
        }
        LOGGER.error("[FANCYMENU] Can't set file filter for SaveFileScreen with forced file extension!");
        return this;
    }

    @Override
    protected boolean isWidgetHovered() {
        if (this.fileNameEditBox.method_25367()) {
            return false;
        }
        return super.isWidgetHovered();
    }

    @Nullable
    public CharacterFilter getFileNameCharacterFilter() {
        return this.fileNameEditBox.getCharacterFilter();
    }

    public SaveFileScreen setFileNameCharacterFilter(@Nullable CharacterFilter characterFilter) {
        if (this.forceResourceFriendlyFileNames) {
            LOGGER.error("[FANCYMENU] Unable to set file name character filter for SaveFileScreen while 'forceResourceFriendlyFileNames' is enabled!");
            return this;
        }
        this.fileNameEditBox.setCharacterFilter(characterFilter);
        return this;
    }

    public SaveFileScreen setFileName(@NotNull String fileName) {
        this.fileNameEditBox.method_1852(fileName);
        return this;
    }

    public boolean forceResourceFriendlyFileNames() {
        return this.forceResourceFriendlyFileNames;
    }

    public SaveFileScreen setForceResourceFriendlyFileNames(boolean forceResourceFriendlyFileNames) {
        this.forceResourceFriendlyFileNames = forceResourceFriendlyFileNames;
        if (!this.forceResourceFriendlyFileNames) {
            this.fileNameEditBox.setCharacterFilter(null);
        } else {
            this.fileNameEditBox.setCharacterFilter(CharacterFilter.buildOnlyLowercaseFileNameFilter());
        }
        return this;
    }

    protected void trySave() {
        File f = this.getSaveFile();
        if (f != null) {
            if (!f.isFile()) {
                this.callback.accept(new File(f.getPath().replace("\\", "/")));
            } else {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.warning(call -> {
                    class_310.method_1551().method_1507((class_437)this);
                    if (call.booleanValue()) {
                        try {
                            this.callback.accept(new File(f.getPath().replace("\\", "/")));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }, LocalizationUtils.splitLocalizedLines("fancymenu.ui.save_file.save.override_warning", new String[0])));
            }
        }
    }

    protected boolean canSave() {
        return this.getSaveFile() != null;
    }

    @Nullable
    protected File getSaveFile() {
        AbstractFileBrowserScreen.AbstractFileScrollAreaEntry e = this.getSelectedEntry();
        if (e != null && e.file.isDirectory()) {
            return null;
        }
        if (!this.fileNameEditBox.method_1882().replace(" ", "").isEmpty()) {
            File f = new File(this.currentDir, "/" + this.fileNameEditBox.method_1882());
            if (!this.shouldShowFile(f)) {
                return null;
            }
            return f;
        }
        return null;
    }

    @Override
    protected AbstractFileBrowserScreen.AbstractFileScrollAreaEntry buildFileEntry(@NotNull File f) {
        return new SaveFileScrollAreaEntry(this.fileListScrollArea, f);
    }

    public boolean method_25404(int keycode, int scancode, int modifiers) {
        if (keycode == 257) {
            this.trySave();
            return true;
        }
        return super.method_25404(keycode, scancode, modifiers);
    }

    public class SaveFileScrollAreaEntry
    extends AbstractFileBrowserScreen.AbstractFileScrollAreaEntry {
        public SaveFileScrollAreaEntry(@NotNull ScrollArea parent, File file) {
            super(parent, file);
        }

        @Override
        public void onClick(ScrollAreaEntry entry) {
            if (this.resourceUnfriendlyFileName) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastClick < 400L) {
                if (this.file.isDirectory()) {
                    SaveFileScreen.this.setDirectory(this.file, true);
                } else if (this.file.isFile()) {
                    String name = this.file.getName();
                    if (SaveFileScreen.this.forcedFileExtension == null || name.toLowerCase().endsWith("." + SaveFileScreen.this.forcedFileExtension.toLowerCase())) {
                        SaveFileScreen.this.fileNameEditBox.method_1852(name);
                    }
                }
            }
            SaveFileScreen.this.updatePreview(this.file);
            this.lastClick = now;
        }
    }
}

