/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.ETFManager;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.features.property_reading.RandomPropertyRule;
import traben.entity_texture_features.features.property_reading.properties.RandomProperties;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.features.texture_handlers.ETFDirectory;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.EntityBooleanLRU;

public class PropertiesRandomProvider
implements ETFApi.ETFVariantSuffixProvider {
    protected final List<RandomPropertyRule> propertyRules;
    protected final EntityBooleanLRU entityCanUpdate = new EntityBooleanLRU(1000);
    protected final String packname;
    protected ETFApi.ETFVariantSuffixProvider.EntityRandomSeedFunction entityRandomSeedFunction = entity -> entity.etf$getUuid().hashCode();
    protected BiConsumer<ETFEntity, @Nullable RandomPropertyRule> onMeetsRule = (entity, rule) -> {};

    private PropertiesRandomProvider(class_2960 propertiesFileIdentifier, List<RandomPropertyRule> propertyRules) {
        this.propertyRules = propertyRules;
        this.packname = class_310.method_1551().method_1478().method_14486(propertiesFileIdentifier).map(class_3298::method_14480).orElse("vanilla");
    }

    @Nullable
    public static PropertiesRandomProvider of(class_2960 initialPropertiesFileIdentifier, class_2960 vanillaIdentifier, String ... suffixKeyName) {
        class_2960 propertiesFileIdentifier = ETFDirectory.getDirectoryVersionOf(initialPropertiesFileIdentifier);
        if (propertiesFileIdentifier == null) {
            return null;
        }
        try {
            List<RandomPropertyRule> propertyRules;
            Properties props = ETFUtils2.readAndReturnPropertiesElseNull(propertiesFileIdentifier);
            if (props == null) {
                ETFUtils2.logMessage("Ignoring properties file that was null @ " + String.valueOf(propertiesFileIdentifier), false);
                return null;
            }
            if (vanillaIdentifier.method_12832().endsWith(".png")) {
                ETFManager.getInstance().grabSpecialProperties(props, ETFRenderContext.getCurrentEntity());
            }
            if ((propertyRules = PropertiesRandomProvider.getAllValidPropertyObjects(props, propertiesFileIdentifier, suffixKeyName)).isEmpty()) {
                ETFUtils2.logMessage("Ignoring properties file that failed to load any cases @ " + String.valueOf(propertiesFileIdentifier), false);
                return null;
            }
            class_3300 resourceManager = class_310.method_1551().method_1478();
            String properties = resourceManager.method_14486(propertiesFileIdentifier).map(class_3298::method_14480).orElse(null);
            String vanillaPack = resourceManager.method_14486(vanillaIdentifier).map(class_3298::method_14480).orElse(null);
            if (properties != null && properties.equals(ETFUtils2.returnNameOfHighestPackFromTheseTwo(properties, vanillaPack))) {
                return new PropertiesRandomProvider(propertiesFileIdentifier, propertyRules);
            }
        }
        catch (Exception e) {
            ETFUtils2.logWarn("Ignoring properties file that caused Exception @ " + String.valueOf(propertiesFileIdentifier) + "\n" + String.valueOf(e), false);
            e.printStackTrace();
        }
        return null;
    }

    public static List<RandomPropertyRule> getAllValidPropertyObjects(Properties properties, class_2960 propertiesFilePath, String ... suffixToTest) {
        Set<String> propIds = properties.stringPropertyNames();
        List<Integer> numbersList = PropertiesRandomProvider.getCaseNumbers(propIds);
        Collections.sort(numbersList);
        ArrayList<RandomPropertyRule> allRulesOfProperty = new ArrayList<RandomPropertyRule>();
        for (Integer ruleNumber : numbersList) {
            Integer[] suffixesOfRule = PropertiesRandomProvider.getSuffixes(properties, ruleNumber, suffixToTest);
            if (suffixesOfRule != null && suffixesOfRule.length != 0) {
                allRulesOfProperty.add(new RandomPropertyRule(propertiesFilePath.toString(), ruleNumber, suffixesOfRule, PropertiesRandomProvider.getWeights(properties, ruleNumber), RandomProperties.getAllRegisteredRandomPropertiesOfIndex(properties, ruleNumber)));
                continue;
            }
            ETFUtils2.logWarn("property number \"" + ruleNumber + ". in file \"" + String.valueOf(propertiesFilePath) + ". failed to read.");
        }
        return allRulesOfProperty;
    }

    @NotNull
    private static List<Integer> getCaseNumbers(Set<String> propIds) {
        HashSet<Integer> foundRuleNumbers = new HashSet<Integer>();
        for (String str : propIds) {
            String possibleRuleNumber;
            String[] split = str.split("\\.");
            if (split.length < 2 || split[1].isBlank() || (possibleRuleNumber = split[1].replaceAll("\\D", "")).isBlank()) continue;
            try {
                foundRuleNumbers.add(Integer.parseInt(possibleRuleNumber));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new ArrayList<Integer>(foundRuleNumbers);
    }

    @Nullable
    private static Integer[] getSuffixes(Properties props, int num, String ... suffixToTest) {
        return SimpleIntegerArrayProperty.getGenericIntegerSplitWithRanges(props, num, suffixToTest);
    }

    @Nullable
    private static Integer[] getWeights(Properties props, int num) {
        return SimpleIntegerArrayProperty.getGenericIntegerSplitWithRanges(props, num, "weights");
    }

    public void setOnMeetsRuleHook(BiConsumer<ETFEntity, RandomPropertyRule> onMeetsRule) {
        if (onMeetsRule != null) {
            this.onMeetsRule = onMeetsRule;
        }
    }

    public String getPackName() {
        return this.packname;
    }

    @Override
    public boolean entityCanUpdate(UUID uuid) {
        return this.entityCanUpdate.getBoolean(uuid);
    }

    @Override
    public IntOpenHashSet getAllSuffixes() {
        IntOpenHashSet allSuffixes = new IntOpenHashSet();
        for (RandomPropertyRule rule : this.propertyRules) {
            allSuffixes.addAll(rule.getSuffixSet());
        }
        return allSuffixes;
    }

    @Override
    public int size() {
        return this.propertyRules.size();
    }

    @Override
    public int getSuffixForETFEntity(ETFEntity entityToBeTested) {
        if (entityToBeTested == null) {
            return 0;
        }
        UUID id = entityToBeTested.etf$getUuid();
        boolean entityHasBeenTestedBefore = this.entityCanUpdate.containsKey(id);
        if (entityHasBeenTestedBefore) {
            for (RandomPropertyRule rule : this.propertyRules) {
                if (!rule.doesEntityMeetConditionsOfThisCase(entityToBeTested, true, this.entityCanUpdate)) continue;
                this.onMeetsRule.accept(entityToBeTested, rule);
                return rule.getVariantSuffixFromThisCase(this.entityRandomSeedFunction.toInt(entityToBeTested));
            }
        } else {
            int foundSuffix = 0;
            for (RandomPropertyRule rule : this.propertyRules) {
                if (!rule.doesEntityMeetConditionsOfThisCase(entityToBeTested, false, this.entityCanUpdate)) continue;
                this.onMeetsRule.accept(entityToBeTested, rule);
                foundSuffix = rule.getVariantSuffixFromThisCase(this.entityRandomSeedFunction.toInt(entityToBeTested));
                break;
            }
            if (this.entityCanUpdate.getBoolean(entityToBeTested.etf$getUuid())) {
                for (RandomPropertyRule rule : this.propertyRules) {
                    rule.cacheEntityInitialResultsOfNonUpdatingProperties(entityToBeTested);
                }
            }
            return foundSuffix;
        }
        this.onMeetsRule.accept(entityToBeTested, null);
        return 0;
    }

    @Override
    public void setRandomSupplier(ETFApi.ETFVariantSuffixProvider.EntityRandomSeedFunction entityRandomSeedFunction) {
        if (entityRandomSeedFunction != null) {
            this.entityRandomSeedFunction = entityRandomSeedFunction;
        }
    }
}

