/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.core.configuration.presence;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import me.hypherionmc.simplerpc.core.configuration.objects.CustomVariablesConfig;
import me.hypherionmc.simplerpc.core.configuration.objects.RPCButton;
import me.hypherionmc.simplerpc.core.discord.RichPresenceBuilder;
import me.hypherionmc.simplerpc.core.discord.RichPresenceCore;
import me.hypherionmc.simplerpc.core.discord.RichPresenceVariables;
import me.hypherionmc.simplerpc.core.integrations.launchers.LauncherUtils;
import me.hypherionmc.simplerpc.core.util.APIUtils;
import me.hypherionmc.simplerpc.core.util.MinecraftUtilHandler;
import me.hypherionmc.simplerpc.core.util.RPCContainer;
import shadow.hypherionmc.moonconfig.core.conversion.Path;
import shadow.hypherionmc.moonconfig.core.conversion.SpecComment;
import shadow.hypherionmc.moonconfig.core.fields.RandomArrayList;

public class ReplayModRenderSection
implements RPCContainer {
    @Path(value="enabled")
    @SpecComment(value="Enable/Disable the ReplayMod Rendering Event")
    public boolean enabled = true;
    @Path(value="description")
    @SpecComment(value="The first line of text under the app name")
    public String description = "Exporting a video with %replaytimeleft% left";
    @Path(value="state")
    @SpecComment(value="The second line of text under the app name")
    public String state = "Rendering %replayframe%/%replaytotal% frames";
    @Path(value="largeImageKey")
    @SpecComment(value="The Asset ID of the image to display as the large image")
    public RandomArrayList<String> largeImageKey = RandomArrayList.of((Object[])new String[]{"mclogonew"});
    @Path(value="largeImageText")
    @SpecComment(value="The text that gets displayed when the large image is hovered")
    public String largeImageText = "It's Minecraft %mcver%, but modded";
    @Path(value="smallImageKey")
    @SpecComment(value="The Asset ID of the image to display as the small image")
    public RandomArrayList<String> smallImageKey = RandomArrayList.of((Object[])new String[]{"mclogo"});
    @Path(value="smallImageText")
    @SpecComment(value="The text that gets displayed when the small image is hovered")
    public String smallImageText = "%mods% mods installed";
    @Path(value="buttons")
    @SpecComment(value="The buttons to display on Discord")
    public List<RPCButton> buttonsList = new ArrayList<RPCButton>();

    @Override
    public RichPresenceBuilder buildPresence(RichPresenceCore core) {
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(core.getUtilHandler().parseVarsInternal(this.description, core.getClientConfig().variablesConfig)).setLargeImage(core.getUtilHandler().parseVarsInternal(this.largeImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setLargeImageText(core.getUtilHandler().parseVarsInternal(this.largeImageText, core.getClientConfig().variablesConfig)).setSmallImage(core.getUtilHandler().parseVarsInternal(this.smallImageKey.getNextRandom().orElse(""), core.getClientConfig().variablesConfig)).setSmallImageText(core.getUtilHandler().parseVarsInternal(this.smallImageText, core.getClientConfig().variablesConfig)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setState(core.getUtilHandler().parseVarsInternal(this.state, core.getClientConfig().variablesConfig));
        build = LauncherUtils.getLauncherOverrides(build, core);
        return this.enabled ? build : null;
    }

    public RichPresenceBuilder buildPresence(RichPresenceCore core, String timeTaken, String timeLeft, int framesDone, int totalFrames) {
        RichPresenceBuilder build = new RichPresenceBuilder().setDetails(this.parseAdditional(this.description, timeTaken, timeLeft, framesDone, totalFrames, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setLargeImage(this.parseAdditional(this.largeImageKey.getNextRandom().orElse(""), timeTaken, timeLeft, framesDone, totalFrames, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setLargeImageText(this.parseAdditional(this.largeImageText, timeTaken, timeLeft, framesDone, totalFrames, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setSmallImage(this.parseAdditional(this.smallImageKey.getNextRandom().orElse(""), timeTaken, timeLeft, framesDone, totalFrames, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setSmallImageText(this.parseAdditional(this.smallImageText, timeTaken, timeLeft, framesDone, totalFrames, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setTimeStamp(OffsetDateTime.now()).setButtons(APIUtils.parseButtons(this.buttonsList, core.getUtilHandler(), core.getClientConfig().variablesConfig)).setState(this.parseAdditional(this.state, timeTaken, timeLeft, framesDone, totalFrames, core.getUtilHandler(), core.getClientConfig().variablesConfig));
        build = LauncherUtils.getLauncherOverrides(build, core);
        return this.enabled ? build : null;
    }

    private String parseAdditional(String input, String timeTaken, String timeLeft, int framesDone, int framesTotal, MinecraftUtilHandler utilHandler, CustomVariablesConfig config) {
        input = RichPresenceVariables.REPLAY_FRAME.resolve(input, String.valueOf(framesDone));
        input = RichPresenceVariables.REPLAY_TOTAL.resolve(input, String.valueOf(framesTotal));
        input = RichPresenceVariables.REPLAY_TIME.resolve(input, timeTaken);
        input = RichPresenceVariables.REPLAY_TIME_LEFT.resolve(input, timeLeft);
        input = utilHandler.parseVarsInternal(input, config);
        return input;
    }
}

