/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetExtension;
import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.InvalidRuleValueException;
import carpet.api.settings.SettingsManager;
import carpet.network.CarpetClient;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class ClientNetworkHandler {
    private static final Map<String, BiConsumer<class_746, class_2520>> dataHandlers = new HashMap<String, BiConsumer<class_746, class_2520>>();

    private static void onHi(String version) {
        CarpetClient.setCarpet();
        CarpetClient.serverCarpetVersion = version;
        if (CarpetSettings.carpetVersion.equals(CarpetClient.serverCarpetVersion)) {
            CarpetSettings.LOG.info("Joined carpet server with matching carpet version");
        } else {
            CarpetSettings.LOG.warn("Joined carpet server with another carpet version: " + CarpetClient.serverCarpetVersion);
        }
        ClientNetworkHandler.respondHello();
    }

    public static void respondHello() {
        class_2487 data = new class_2487();
        data.method_10582("420", CarpetSettings.carpetVersion);
        CarpetClient.getPlayer().field_3944.method_52787((class_2596)new class_2817((class_8710)new CarpetClient.CarpetPayload(data)));
    }

    public static void onServerData(class_2487 compound, class_746 player) {
        for (String key : compound.method_10541()) {
            if (dataHandlers.containsKey(key)) {
                try {
                    dataHandlers.get(key).accept(player, compound.method_10580(key));
                }
                catch (Exception exc) {
                    CarpetSettings.LOG.info("Corrupt carpet data for " + key);
                }
                continue;
            }
            CarpetSettings.LOG.error("Unknown carpet data: " + key);
        }
    }

    public static void clientCommand(String command) {
        class_2487 tag = new class_2487();
        tag.method_10582("id", command);
        tag.method_10582("command", command);
        class_2487 outer = new class_2487();
        outer.method_10566("clientCommand", (class_2520)tag);
        CarpetClient.getPlayer().field_3944.method_52787((class_2596)new class_2817((class_8710)new CarpetClient.CarpetPayload(outer)));
    }

    static {
        dataHandlers.put("69", (p, t) -> ClientNetworkHandler.onHi(t.method_10714()));
        dataHandlers.put("Rules", (p, t) -> {
            class_2487 ruleset = (class_2487)t;
            for (String ruleKey : ruleset.method_10541()) {
                CarpetRule<?> rule;
                String ruleName;
                class_2487 ruleNBT = (class_2487)ruleset.method_10580(ruleKey);
                SettingsManager manager = null;
                if (ruleNBT.method_10545("Manager")) {
                    ruleName = ruleNBT.method_10558("Rule");
                    String managerName = ruleNBT.method_10558("Manager");
                    if (managerName.equals("carpet")) {
                        manager = CarpetServer.settingsManager;
                    } else {
                        for (CarpetExtension extension : CarpetServer.extensions) {
                            SettingsManager eManager = extension.extensionSettingsManager();
                            if (eManager == null || !managerName.equals(eManager.identifier())) continue;
                            manager = eManager;
                            break;
                        }
                    }
                } else {
                    manager = CarpetServer.settingsManager;
                    ruleName = ruleKey;
                }
                if ((rule = manager != null ? manager.getCarpetRule(ruleName) : null) == null) continue;
                String value = ruleNBT.method_10558("Value");
                try {
                    rule.set((class_2168)null, value);
                }
                catch (InvalidRuleValueException invalidRuleValueException) {}
            }
        });
        dataHandlers.put("scShape", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShape((class_2487)t);
            }
        });
        dataHandlers.put("scShapes", (p, t) -> {
            if (CarpetClient.shapes != null) {
                CarpetClient.shapes.addShapes((class_2499)t);
            }
        });
        dataHandlers.put("clientCommand", (p, t) -> CarpetClient.onClientCommand(t));
    }
}

