/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.value.AbstractListValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class MapValue
extends AbstractListValue
implements ContainerValueInterface {
    private final Map<Value, Value> map;

    private MapValue() {
        this.map = new HashMap<Value, Value>();
    }

    public MapValue(List<Value> kvPairs) {
        this();
        kvPairs.forEach(this::put);
    }

    public MapValue(Set<Value> keySet) {
        this();
        keySet.forEach(v -> this.map.put((Value)v, Value.NULL));
    }

    @Override
    public Iterator<Value> iterator() {
        return new ArrayList<Value>(this.map.keySet()).iterator();
    }

    @Override
    public List<Value> unpack() {
        return this.map.entrySet().stream().map(e -> ListValue.of((Value)e.getKey(), (Value)e.getValue())).collect(Collectors.toList());
    }

    @Override
    public String getString() {
        return "{" + this.map.entrySet().stream().map(p -> ((Value)p.getKey()).getString() + ": " + ((Value)p.getValue()).getString()).collect(Collectors.joining(", ")) + "}";
    }

    @Override
    public String getPrettyString() {
        if (this.map.size() < 6) {
            return "{" + this.map.entrySet().stream().map(p -> ((Value)p.getKey()).getPrettyString() + ": " + ((Value)p.getValue()).getPrettyString()).collect(Collectors.joining(", ")) + "}";
        }
        ArrayList<Value> keys = new ArrayList<Value>(this.map.keySet());
        int max = keys.size();
        return "{" + ((Value)keys.get(0)).getPrettyString() + ": " + this.map.get(keys.get(0)).getPrettyString() + ", " + ((Value)keys.get(1)).getPrettyString() + ": " + this.map.get(keys.get(1)).getPrettyString() + ", ..., " + ((Value)keys.get(max - 2)).getPrettyString() + ": " + this.map.get(keys.get(max - 2)).getPrettyString() + ", " + ((Value)keys.get(max - 1)).getPrettyString() + ": " + this.map.get(keys.get(max - 1)).getPrettyString() + "}";
    }

    @Override
    public boolean getBoolean() {
        return !this.map.isEmpty();
    }

    public Value clone() {
        return new MapValue(this.map);
    }

    @Override
    public Value deepcopy() {
        HashMap<Value, Value> copyMap = new HashMap<Value, Value>();
        this.map.forEach((? super K key, ? super V value) -> copyMap.put(key.deepcopy(), value.deepcopy()));
        return new MapValue(copyMap);
    }

    private MapValue(Map<Value, Value> other) {
        this.map = other;
    }

    public static MapValue wrap(Map<Value, Value> other) {
        return new MapValue(other);
    }

    @Override
    public Value add(Value o) {
        HashMap<Value, Value> newItems = new HashMap<Value, Value>(this.map);
        if (o instanceof MapValue) {
            MapValue mapValue = (MapValue)o;
            newItems.putAll(mapValue.map);
        } else if (o instanceof AbstractListValue) {
            AbstractListValue alv = (AbstractListValue)o;
            for (Value value : alv) {
                newItems.put(value, Value.NULL);
            }
        } else {
            newItems.put(o, Value.NULL);
        }
        return MapValue.wrap(newItems);
    }

    @Override
    public Value subtract(Value v) {
        throw new InternalExpressionException("Cannot subtract from a map value");
    }

    @Override
    public Value multiply(Value v) {
        throw new InternalExpressionException("Cannot multiply with a map value");
    }

    @Override
    public Value divide(Value v) {
        throw new InternalExpressionException("Cannot divide a map value");
    }

    public void put(Value v) {
        if (!(v instanceof ListValue)) {
            this.map.put(v, Value.NULL);
            return;
        }
        ListValue pair = (ListValue)v;
        if (pair.getItems().size() != 2) {
            throw new InternalExpressionException("Map constructor requires elements that have two items");
        }
        this.map.put(pair.getItems().get(0), pair.getItems().get(1));
    }

    @Override
    public void append(Value v) {
        this.map.put(v, Value.NULL);
    }

    @Override
    public int compareTo(Value o) {
        throw new InternalExpressionException("Cannot compare with a map value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof MapValue)) return false;
        MapValue mapValue = (MapValue)o;
        if (!this.map.equals(mapValue.map)) return false;
        return true;
    }

    public Map<Value, Value> getMap() {
        return this.map;
    }

    public void extend(List<Value> subList) {
        subList.forEach(this::put);
    }

    @Override
    public int length() {
        return this.map.size();
    }

    @Override
    public Value in(Value value) {
        return this.map.containsKey(value) ? value : Value.NULL;
    }

    @Override
    public Value slice(long from, Long to) {
        throw new InternalExpressionException("Cannot slice a map value");
    }

    @Override
    public Value split(Value delimiter) {
        throw new InternalExpressionException("Cannot split a map value");
    }

    @Override
    public double readDoubleNumber() {
        return this.map.size();
    }

    @Override
    public Value get(Value v2) {
        return this.map.getOrDefault(v2, Value.NULL);
    }

    @Override
    public boolean has(Value where) {
        return this.map.containsKey(where);
    }

    @Override
    public boolean delete(Value where) {
        return this.map.remove(where) != null;
    }

    @Override
    public boolean put(Value key, Value value) {
        return this.map.put(key, value) != null;
    }

    @Override
    public String getTypeString() {
        return "map";
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public class_2520 toTag(boolean force) {
        class_2487 tag = new class_2487();
        this.map.forEach((? super K k, ? super V v) -> {
            if (!force && !(k instanceof StringValue)) {
                throw new NBTSerializableValue.IncompatibleTypeException((Value)k);
            }
            tag.method_10566(k.getString(), v.toTag(force));
        });
        return tag;
    }

    @Override
    public JsonElement toJson() {
        JsonObject jsonMap = new JsonObject();
        ArrayList<Value> keys = new ArrayList<Value>(this.map.keySet());
        Collections.sort(keys);
        keys.forEach(k -> jsonMap.add(k.getString(), this.map.get(k).toJson()));
        return jsonMap;
    }
}

