/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Expandable;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.math.Rectangle;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class MultiElementListEntry<T>
extends TooltipListEntry<T>
implements Expandable {
    private static final class_2960 CONFIG_TEX = new class_2960("cloth-config2", "textures/gui/cloth_config.png");
    private final T object;
    private final List<AbstractConfigListEntry<?>> entries;
    private final CategoryLabelWidget widget;
    private final List<Object> children;
    private boolean expanded;

    @ApiStatus.Internal
    public MultiElementListEntry(class_2561 categoryName, T object, List<AbstractConfigListEntry<?>> entries, boolean defaultExpanded) {
        super(categoryName, null);
        this.object = object;
        this.entries = entries;
        this.expanded = defaultExpanded;
        this.widget = new CategoryLabelWidget();
        this.children = Lists.newArrayList((Object[])new Object[]{this.widget});
        this.children.addAll(entries);
        this.setReferenceProviderEntries(entries);
    }

    @Override
    public boolean isRequiresRestart() {
        for (AbstractConfigListEntry<?> entry : this.entries) {
            if (!entry.isRequiresRestart()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEdited() {
        for (AbstractConfigListEntry<?> entry : this.entries) {
            if (!entry.isEdited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<String> getSearchTags() {
        return Iterators.concat(super.getSearchTags(), (Iterator)Iterators.concat(this.entries.stream().map(AbstractConfigEntry::getSearchTags).iterator()));
    }

    @Override
    public void setRequiresRestart(boolean requiresRestart) {
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public class_2561 getCategoryName() {
        return this.getFieldName();
    }

    @Override
    public T getValue() {
        return this.object;
    }

    @Override
    public Optional<T> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        boolean insideWidget = this.widget.rectangle.contains(mouseX, mouseY);
        RenderSystem.setShaderTexture((int)0, (class_2960)CONFIG_TEX);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.method_25302(CONFIG_TEX, x - 15, y + 5, 24, (this.isEnabled() ? (insideWidget ? 18 : 0) : 36) + (this.isExpanded() ? 9 : 0), 9, 9);
        graphics.method_35720(class_310.method_1551().field_1772, this.getDisplayedFieldName().method_30937(), x, y + 6, insideWidget ? -1638890 : -1);
        for (AbstractConfigListEntry<?> entry : this.entries) {
            entry.setParent(this.getParent());
            entry.setScreen(this.getConfigScreen());
        }
        if (this.isExpanded()) {
            int yy = y + 24;
            for (AbstractConfigListEntry<?> entry : this.entries) {
                entry.render(graphics, -1, yy, x + 14, entryWidth - 14, entry.getItemHeight(), mouseX, mouseY, isHovered, delta);
                yy += entry.getItemHeight();
                yy += Math.max(0, entry.getMorePossibleHeight());
            }
        }
    }

    @Override
    public Rectangle getEntryArea(int x, int y, int entryWidth, int entryHeight) {
        this.widget.rectangle.x = x - 15;
        this.widget.rectangle.y = y;
        this.widget.rectangle.width = entryWidth + 15;
        this.widget.rectangle.height = 24;
        return new Rectangle(this.getParent().left, y, this.getParent().right - this.getParent().left, 20);
    }

    @Override
    public int getItemHeight() {
        if (this.isExpanded()) {
            int i = 24;
            for (AbstractConfigListEntry<?> entry : this.entries) {
                i += entry.getItemHeight();
            }
            return i;
        }
        return 24;
    }

    @Override
    public void updateSelected(boolean isSelected) {
        for (AbstractConfigListEntry<?> entry : this.entries) {
            entry.updateSelected(this.isExpanded() && isSelected && this.method_25399() == entry);
        }
    }

    @Override
    public int getInitialReferenceOffset() {
        return 24;
    }

    @Override
    public void lateRender(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.isExpanded()) {
            for (AbstractConfigListEntry<?> entry : this.entries) {
                entry.lateRender(graphics, mouseX, mouseY, delta);
            }
        }
    }

    @Override
    public int getMorePossibleHeight() {
        if (!this.isExpanded()) {
            return -1;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 24;
        for (AbstractConfigListEntry<?> entry : this.entries) {
            i += entry.getItemHeight();
            if (entry.getMorePossibleHeight() < 0) continue;
            list.add(i + entry.getMorePossibleHeight());
        }
        list.add(i);
        return list.stream().max(Integer::compare).orElse(0) - this.getItemHeight();
    }

    public List<? extends class_364> method_25396() {
        return this.isExpanded() ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public List<? extends class_6379> narratables() {
        return this.isExpanded() ? this.children : Collections.singletonList(this.widget);
    }

    @Override
    public void save() {
        this.entries.forEach(AbstractConfigEntry::save);
    }

    @Override
    public Optional<class_2561> getError() {
        List errors = this.entries.stream().map(AbstractConfigEntry::getConfigError).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (errors.size() > 1) {
            return Optional.of(class_2561.method_43471((String)"text.cloth-config.multi_error"));
        }
        return errors.stream().findFirst();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded && this.isEnabled();
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public class CategoryLabelWidget
    implements class_364,
    class_6379 {
        private final Rectangle rectangle = new Rectangle();
        private boolean isHovered;

        public boolean method_25402(double mouseX, double mouseY, int int_1) {
            if (MultiElementListEntry.this.isEnabled() && this.rectangle.contains(mouseX, mouseY)) {
                MultiElementListEntry.this.setExpanded(!MultiElementListEntry.this.expanded);
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                this.isHovered = true;
                return true;
            }
            this.isHovered = false;
            return false;
        }

        public void method_25365(boolean bl) {
        }

        public boolean method_25370() {
            return false;
        }

        public class_6379.class_6380 method_37018() {
            return this.isHovered ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 narrationElementOutput) {
            narrationElementOutput.method_37034(class_6381.field_33788, MultiElementListEntry.this.getFieldName());
        }
    }
}

