/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config;

import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.config.Rename;
import com.HiWord9.RPRenames.util.config.generation.CEMConfig;
import com.HiWord9.RPRenames.util.config.generation.CEMList;
import com.HiWord9.RPRenames.util.config.generation.CITConfig;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    private static final ModConfig config = ModConfig.INSTANCE;

    public static void parseRenames() {
        class_310 client = class_310.method_1551();
        ConfigManager.parseRenames(client.method_1478(), client.method_16011());
    }

    public static void parseRenames(class_3300 resourceManager, class_3695 profiler) {
        profiler.method_15396("rprenames:reloading_renames");
        ConfigManager.configClear();
        long startTime = System.currentTimeMillis();
        RPRenames.LOGGER.info("Starting collecting renames");
        CITConfig.parseCITs(resourceManager, profiler);
        CEMConfig.parseCEMs(resourceManager, profiler);
        long finishTime = System.currentTimeMillis() - startTime;
        ConfigManager.updateItemGroup();
        RPRenames.LOGGER.info("Finished collecting renames [" + finishTime / 1000L + "." + finishTime % 1000L + "s]");
        profiler.method_15407();
    }

    public static void updateItemGroup() {
        RPRenames.renamedItemStacks.clear();
        ArrayList<class_1799> list = new ArrayList<class_1799>();
        ArrayList<Rename> parsedRenames = new ArrayList<Rename>();
        for (String key : RPRenames.renames.keySet()) {
            for (Rename r : RPRenames.renames.get(key)) {
                if (parsedRenames.contains(r)) continue;
                parsedRenames.add(r);
                if (r.getItems().size() > 1 && !ConfigManager.config.compareItemGroupRenames) {
                    for (int i = 0; i < r.getItems().size(); ++i) {
                        class_1799 stack = ConfigManager.createItem(r, true, i);
                        list.add(stack);
                    }
                    continue;
                }
                class_1799 stack = ConfigManager.createItemOrSpawnEgg(r);
                list.add(stack);
            }
        }
        RPRenames.renamedItemStacks.addAll(list);
    }

    public static Properties getPropFromResource(class_3298 resource) throws IOException {
        Properties prop = new Properties();
        prop.load(resource.method_14482());
        return prop;
    }

    public static String getFullPathFromIdentifier(String packName, class_2960 identifier) {
        return ConfigManager.validatePackName(packName) + "/assets/" + identifier.method_12836() + "/" + identifier.method_12832();
    }

    public static String validatePackName(String packName) {
        return packName.startsWith("file/") ? packName.substring(5) : packName;
    }

    public static Map<String, ArrayList<Rename>> getAllFavorites() {
        HashMap<String, ArrayList<Rename>> favoriteRenames = new HashMap<String, ArrayList<Rename>>();
        File[] files = RPRenames.configPathFavorite.toFile().listFiles();
        if (files == null) {
            return favoriteRenames;
        }
        for (File file : files) {
            String fileName = file.getName();
            String item = fileName.substring(0, fileName.length() - 5);
            favoriteRenames.put(item.replace(".", ":"), ConfigManager.getFavorites(item));
        }
        return favoriteRenames;
    }

    public static ArrayList<Rename> getFavorites(String item) {
        ArrayList renames = new ArrayList();
        File favoritesFile = new File(String.valueOf(RPRenames.configPathFavorite) + File.separator + item.replace(":", ".") + ".json");
        if (favoritesFile.exists()) {
            try {
                FileReader fileReader = new FileReader(favoritesFile);
                Type type = new TypeToken<ArrayList<Rename>>(){}.getType();
                Gson gson = new Gson();
                renames = (ArrayList)gson.fromJson((Reader)fileReader, type);
                fileReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ConfigManager.fixRenameItemsIfNeeded(renames, item);
        return renames;
    }

    private static void fixRenameItemsIfNeeded(ArrayList<Rename> renames, String item) {
        boolean fix = false;
        for (Rename rename : renames) {
            if (rename.getItems() != null) continue;
            RPRenames.LOGGER.error("Fixing items list for favorite Rename \"" + rename.getName() + "\". Looks like it was created in ver <0.8.0");
            rename.setItems(new ArrayList<String>(List.of(item)));
            fix = true;
        }
        if (!fix) {
            return;
        }
        RPRenames.LOGGER.warn("Recreating Favorite Renames List File for \"" + item + "\" with fixed Items.");
        ConfigManager.deleteFavoriteConfigFile(item);
        for (Rename rename : renames) {
            ConfigManager.addToFavorites(rename.getName(), item);
        }
    }

    public static void addToFavorites(String favoriteName, String item) {
        ArrayList<Object> listNames = new ArrayList();
        Rename rename = new Rename(favoriteName, item);
        ArrayList<Rename> alreadyExist = ConfigManager.getFavorites(item);
        if (!alreadyExist.isEmpty()) {
            ArrayList<Rename> newConfig = new ArrayList<Rename>(alreadyExist);
            newConfig.add(rename);
            listNames = newConfig;
        } else {
            if (RPRenames.configPathFavorite.toFile().mkdirs()) {
                RPRenames.LOGGER.info("Created folder for favorites config: " + String.valueOf(RPRenames.configPathFavorite));
            }
            RPRenames.LOGGER.info("Created new file for favorites config: " + String.valueOf(RPRenames.configPathFavorite) + File.separator + item.replaceAll(":", ".") + ".json");
            listNames.add(rename);
        }
        try {
            FileWriter fileWriter = new FileWriter(String.valueOf(RPRenames.configPathFavorite) + File.separator + item.replaceAll(":", ".") + ".json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(listNames, (Appendable)fileWriter);
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void removeFromFavorites(String favoriteName, String item) {
        ArrayList<Rename> renamesList = ConfigManager.getFavorites(item);
        int indexInRenamesList = new Rename(favoriteName).indexIn(renamesList, true);
        if (indexInRenamesList >= 0) {
            renamesList.remove(indexInRenamesList);
        }
        if (!renamesList.isEmpty()) {
            try {
                FileWriter fileWriter = new FileWriter(String.valueOf(RPRenames.configPathFavorite) + File.separator + item.replaceAll(":", ".") + ".json");
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson(renamesList, (Appendable)fileWriter);
                fileWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ConfigManager.deleteFavoriteConfigFile(item);
        }
    }

    private static void deleteFavoriteConfigFile(String item) {
        try {
            Files.deleteIfExists(Path.of(String.valueOf(RPRenames.configPathFavorite) + File.separator + item.replaceAll(":", ".") + ".json", new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getFirstName(String nbtDisplayName) {
        return ConfigManager.getFirstName(nbtDisplayName, null);
    }

    public static String getFirstName(String nbtDisplayName, @Nullable ArrayList<String> items) {
        String name = ConfigManager.parseEscapes(nbtDisplayName);
        if (name.startsWith("pattern:") || name.startsWith("ipattern:")) {
            if (name.startsWith("i")) {
                name = name.substring(1);
            }
            name = name.replaceFirst("pattern:", "");
            name = name.replace("*", "");
            name = name.replace("?", "_");
        } else if (name.startsWith("regex:") || name.startsWith("iregex")) {
            if (name.startsWith("i")) {
                name = name.substring(1);
            }
            name = name.replaceFirst("regex:", "");
            name = name.replace(".*", "");
            String originalRegex = name = name.replace(".+", "_");
            name = ConfigManager.solveRegex(name);
            try {
                if (!name.matches(originalRegex)) {
                    RPRenames.LOGGER.error("Couldn't get valid string from regex" + (String)(items != null ? " for " + String.valueOf(items) : ""));
                    RPRenames.LOGGER.error("regex:" + originalRegex);
                    RPRenames.LOGGER.error("received string:" + name);
                }
            }
            catch (PatternSyntaxException e) {
                RPRenames.LOGGER.error("INVALID REGEX");
            }
        }
        return name;
    }

    public static String parseEscapes(String string) {
        char[] chars = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\\') {
                if (chars[i + 1] == 'u') {
                    char unicode;
                    String unicodeNumbers = string.substring(i + 2, i + 6);
                    try {
                        unicode = (char)Integer.parseInt(unicodeNumbers, 16);
                    }
                    catch (Exception e) {
                        stringBuilder.append(chars[i]);
                        RPRenames.LOGGER.warn("Invalid unicode \"" + unicodeNumbers + "\" for String: " + string);
                        continue;
                    }
                    i += 5;
                    stringBuilder.append(unicode);
                    continue;
                }
                if (chars[i + 1] == 'n') {
                    stringBuilder.append("\n");
                    continue;
                }
                if (chars[i + 1] == 'r') {
                    stringBuilder.append("\r");
                    continue;
                }
                if (chars[i + 1] == 'f') {
                    stringBuilder.append("\f");
                    continue;
                }
                if (chars[i + 1] == 't') {
                    stringBuilder.append("\t");
                    continue;
                }
                stringBuilder.append(chars[i]);
                ++i;
                continue;
            }
            stringBuilder.append(chars[i]);
        }
        return stringBuilder.toString();
    }

    public static String solveRegex(String string) {
        if (!((String)string).startsWith("(")) {
            string = "(" + (String)string + ")";
        }
        return ConfigManager.initialSolveRegex((String)string);
    }

    public static String initialSolveRegex(String string) {
        try {
            StringBuilder builder = new StringBuilder();
            char[] chars = string.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                StringBuilder builder2 = new StringBuilder();
                if (chars[i] == '[') {
                    if (chars[i + 1] != '^') {
                        builder2.append(chars[i + 1]);
                        i += 2;
                        while (chars[i] != ']') {
                            ++i;
                        }
                    } else {
                        int start = i;
                        i += 3;
                        while (chars[i] != ']') {
                            ++i;
                        }
                        int ch = chars[start + 2];
                        int count = 0;
                        while (count != 65536 && !string.substring(start, i + 1).matches(String.valueOf((char)ch))) {
                            ++count;
                            if (++ch == 65536) {
                                ch = 0;
                            }
                            if (count != 65536) continue;
                            ch = 65535;
                        }
                        builder2.append((char)ch);
                    }
                } else if (chars[i] == '(') {
                    StringBuilder builder3 = new StringBuilder();
                    int brackets = 0;
                    ArrayList<Character> bracketsOrder = new ArrayList<Character>();
                    while (i + 1 < chars.length) {
                        if (chars[++i] == '(') {
                            bracketsOrder.add(Character.valueOf('('));
                            ++brackets;
                        } else if (chars[i] == ')' && (bracketsOrder.size() <= 0 || ((Character)bracketsOrder.get(bracketsOrder.size() - 1)).charValue() != '[')) {
                            if (brackets == 0) break;
                            bracketsOrder.add(Character.valueOf(')'));
                            --brackets;
                        } else if (chars[i] == '[') {
                            bracketsOrder.add(Character.valueOf('['));
                            ++brackets;
                        } else if (chars[i] == ']' && chars[i - 1] != '[') {
                            bracketsOrder.add(Character.valueOf(']'));
                            --brackets;
                        }
                        builder3.append(chars[i]);
                    }
                    if (!((builder3 = new StringBuilder(ConfigManager.initialSolveRegex(builder3.toString()))).toString().startsWith("|") || builder3.toString().endsWith("|") || builder3.toString().contains("||") || builder3.isEmpty())) {
                        for (int i1 = 0; i1 != builder3.length() && builder3.charAt(i1) != '|'; ++i1) {
                            builder2.append(builder3.charAt(i1));
                        }
                    }
                } else if (chars[i] != '^' && chars[i] != '$') {
                    if (chars[i] == '\\') {
                        ++i;
                    }
                    builder2.append(chars[i]);
                }
                if (i + 1 < chars.length && chars[i + 1] == '{') {
                    int s;
                    StringBuilder builder3 = new StringBuilder();
                    i += 2;
                    while (chars[i] != '}') {
                        builder3.append(chars[i]);
                        ++i;
                    }
                    int n = s = builder3.indexOf(",") == -1 ? builder3.length() : builder3.indexOf(",");
                    if (s > 0 || s == builder3.length() - 1) {
                        builder.append(String.valueOf(builder2).repeat(Math.max(0, Integer.parseInt(builder3.substring(0, s)))));
                        continue;
                    }
                    if (s == 0) {
                        builder.append(String.valueOf(builder2).repeat(Math.max(0, Integer.parseInt(builder3.substring(s + 1)))));
                        continue;
                    }
                } else if (!(i + 1 >= chars.length || chars[i + 1] != '*' && chars[i + 1] != '+' && chars[i + 1] != '?' || chars[++i] != '*' && chars[i] != '?')) continue;
                builder.append((CharSequence)builder2);
            }
            return builder.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return string;
        }
    }

    public static class_1792 itemFromName(String id) {
        return (class_1792)class_7923.field_41178.method_10223(new class_2960(id));
    }

    public static ArrayList<Rename> getAllRenames() {
        ArrayList<Rename> names = new ArrayList<Rename>();
        for (Map.Entry<String, ArrayList<Rename>> entry : RPRenames.renames.entrySet()) {
            for (Rename r : entry.getValue()) {
                if (names.contains(r)) continue;
                names.add(r);
            }
        }
        return names;
    }

    public static ArrayList<Rename> getRenames(String item) {
        if (RPRenames.renames.containsKey(item)) {
            return RPRenames.renames.get(item);
        }
        return new ArrayList<Rename>();
    }

    public static void addRename(String item, Rename rename) {
        if (RPRenames.renames.containsKey(item)) {
            Rename simplifiedRename = new Rename(rename.getName(), rename.getItems(), null, null, rename.getStackSize(), rename.getDamage(), rename.getEnchantment(), rename.getEnchantmentLevel(), null, null, null);
            if (!simplifiedRename.isContainedIn(RPRenames.renames.get(item), true)) {
                RPRenames.renames.get(item).add(rename);
            }
        } else {
            ArrayList<Rename> arrayList = new ArrayList<Rename>();
            arrayList.add(rename);
            RPRenames.renames.put(item, arrayList);
        }
    }

    public static class_1799[] getGhostCraftItems(Rename rename) {
        class_1799 ghostSource = new class_1799((class_1935)ConfigManager.itemFromName(rename.getItems().get(0)));
        ghostSource.method_7939(rename.getStackSize().intValue());
        if (rename.getDamage() != null) {
            ghostSource.method_7974(rename.getDamage().getParsedDamage(ghostSource.method_7909()));
        }
        class_1799 ghostEnchant = ConfigManager.getGhostCraftEnchant(rename);
        class_1799 ghostResult = ConfigManager.createItem(rename);
        return new class_1799[]{ghostSource, ghostEnchant, ghostResult};
    }

    public static class_1799 getGhostCraftEnchant(Rename rename) {
        class_1799 ghostEnchant = class_1799.field_8037;
        if (rename.getEnchantment() != null) {
            ghostEnchant = new class_1799((class_1935)class_1802.field_8598);
            ghostEnchant.method_7948();
            assert (ghostEnchant.method_7969() != null);
            if (!ghostEnchant.method_7969().method_10573("Enchantments", 9)) {
                ghostEnchant.method_7969().method_10566("Enchantments", (class_2520)new class_2499());
            }
            class_2499 nbtList = ghostEnchant.method_7969().method_10554("Enchantments", 10);
            nbtList.add((Object)class_1890.method_37426((class_2960)new class_2960(rename.getEnchantment()), (int)rename.getEnchantmentLevel()));
        }
        return ghostEnchant;
    }

    public static class_1799 createItemOrSpawnEgg(Rename rename) {
        if (rename.isCEM() && ConfigManager.config.generateSpawnEggsInItemGroup) {
            return ConfigManager.createSpawnEgg(rename);
        }
        return ConfigManager.createItem(rename);
    }

    public static class_1799 createItem(Rename rename) {
        return ConfigManager.createItem(rename, true, 0);
    }

    public static class_1799 createItem(Rename rename, boolean withCustomName, int itemIndex) {
        class_1799 item = new class_1799((class_1935)ConfigManager.itemFromName(rename.getItems().get(itemIndex >= rename.getItems().size() ? 0 : itemIndex)));
        if (withCustomName) {
            item.method_7977(class_2561.method_30163((String)rename.getName()));
        }
        item.method_7939(rename.getStackSize().intValue());
        if (rename.getDamage() != null) {
            item.method_7974(rename.getDamage().getParsedDamage(item.method_7909()));
        }
        if (rename.getEnchantment() != null) {
            item.method_7948();
            assert (item.method_7969() != null);
            if (!item.method_7969().method_10573("Enchantments", 9)) {
                item.method_7969().method_10566("Enchantments", (class_2520)new class_2499());
            }
            class_2499 nbtList = item.method_7969().method_10554("Enchantments", 10);
            nbtList.add((Object)class_1890.method_37426((class_2960)new class_2960(rename.getEnchantment()), (int)rename.getEnchantmentLevel()));
        }
        return item;
    }

    public static class_1799 createSpawnEgg(Rename rename) {
        class_1826 item = class_1826.method_8019(CEMList.EntityFromName(rename.getMob().entity()));
        class_1799 spawnEgg = new class_1799((class_1935)(item == null ? class_1802.field_38419 : item));
        spawnEgg.method_7977(class_2561.method_30163((String)rename.getName()));
        class_2487 nbt = spawnEgg.method_7948();
        class_2487 nbtName = new class_2487();
        nbtName.method_10582("CustomName", rename.getName());
        nbt.method_10566("EntityTag", (class_2520)nbtName);
        if (item == null) {
            class_2487 nbt2 = nbt.method_10562("EntityTag");
            nbt2.method_10582("id", rename.getMob().entity());
        }
        return spawnEgg;
    }

    public static String getIdAndPath(class_1792 item) {
        String idAndPath = class_7923.field_41178.method_10221((Object)item).toString();
        if (idAndPath.startsWith("minecraft:")) {
            return idAndPath.substring(10);
        }
        return idAndPath;
    }

    public static ArrayList<Rename> search(ArrayList<Rename> list, String match) {
        ArrayList<Rename> cutList;
        block42: {
            block40: {
                block41: {
                    cutList = new ArrayList<Rename>();
                    if (!match.startsWith("#")) break block40;
                    String matchTag = match.substring(1);
                    if (matchTag.contains(" ") && !matchTag.toUpperCase(Locale.ROOT).contains("#REGEX:") && !matchTag.toUpperCase(Locale.ROOT).contains("#IREGEX:")) {
                        matchTag = matchTag.substring(0, matchTag.indexOf(" "));
                    } else if (matchTag.contains(" #")) {
                        matchTag = matchTag.substring(0, matchTag.indexOf(" #"));
                    }
                    if (matchTag.toUpperCase(Locale.ROOT).startsWith("REGEX:") || matchTag.toUpperCase(Locale.ROOT).startsWith("IREGEX:")) {
                        boolean isRegex;
                        String regex = matchTag;
                        boolean caseInsensitive = false;
                        if (matchTag.toUpperCase(Locale.ROOT).startsWith("I")) {
                            regex = regex.substring(1);
                            caseInsensitive = true;
                        }
                        regex = regex.substring(6);
                        try {
                            Pattern.compile(regex);
                            isRegex = true;
                        }
                        catch (PatternSyntaxException e) {
                            isRegex = false;
                        }
                        if (isRegex) {
                            for (Rename r : list) {
                                if (!(caseInsensitive ? r.getName().toUpperCase(Locale.ROOT).matches(regex.toUpperCase(Locale.ROOT)) : r.getName().matches(regex))) continue;
                                cutList.add(r);
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("PACK:") || matchTag.toUpperCase(Locale.ROOT).startsWith("PACKNAME:")) {
                        String packName = matchTag.substring(4);
                        while (packName.charAt(0) != ':') {
                            packName = packName.substring(1);
                        }
                        packName = packName.substring(1);
                        for (Rename r : list) {
                            if (r.getPackName() == null || !r.getPackName().replace(" ", "_").toUpperCase(Locale.ROOT).contains(packName.toUpperCase(Locale.ROOT))) continue;
                            cutList.add(r);
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("ITEM:")) {
                        String itemName = matchTag.substring(5);
                        block7: for (Rename r : list) {
                            if (r.getItems() == null) break;
                            for (String item : r.getItems()) {
                                if (!item.toUpperCase(Locale.ROOT).contains(itemName.toUpperCase(Locale.ROOT))) continue;
                                cutList.add(r);
                                continue block7;
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("STACKSIZE:") || matchTag.toUpperCase(Locale.ROOT).startsWith("STACK:") || matchTag.toUpperCase(Locale.ROOT).startsWith("SIZE:")) {
                        String stackSize = matchTag.toUpperCase(Locale.ROOT).substring(4);
                        while (stackSize.charAt(0) != ':') {
                            stackSize = stackSize.substring(1);
                        }
                        if ((stackSize = stackSize.substring(1)).matches("[0-9]+")) {
                            for (Rename r : list) {
                                if (!Rename.isInBounds(Integer.parseInt(stackSize), r.getOriginalStackSize())) continue;
                                cutList.add(r);
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("DAMAGE:")) {
                        String damage = matchTag.substring(7);
                        if (damage.matches("[0-9]+")) {
                            block11: for (Rename r : list) {
                                for (String item : r.getItems()) {
                                    if (!Rename.isInBounds(Integer.parseInt(damage), r.getOriginalDamage(), item)) continue;
                                    cutList.add(r);
                                    continue block11;
                                }
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("ENCH:") || matchTag.toUpperCase(Locale.ROOT).startsWith("ENCHANT:") || matchTag.toUpperCase(Locale.ROOT).startsWith("ENCHANTMENT:")) {
                        String enchant = matchTag.toUpperCase(Locale.ROOT).substring(4);
                        while (enchant.charAt(0) != ':') {
                            enchant = enchant.substring(1);
                        }
                        enchant = enchant.substring(1);
                        block14: for (Rename r : list) {
                            if (r.getEnchantment() == null) continue;
                            ArrayList<String> split = Rename.split(r.getOriginalEnchantment());
                            for (String s : split) {
                                if (!s.toUpperCase(Locale.ROOT).contains(enchant)) continue;
                                cutList.add(r);
                                continue block14;
                            }
                        }
                    } else if (matchTag.toUpperCase(Locale.ROOT).startsWith("FAV:") || matchTag.toUpperCase(Locale.ROOT).startsWith("FAVORITE:")) {
                        block16: for (Rename r : list) {
                            for (String item : r.getItems()) {
                                if (!Rename.isFavorite(item, r.getName())) continue;
                                cutList.add(r);
                                continue block16;
                            }
                        }
                    }
                    if (!match.substring(1).contains(" ") || matchTag.toUpperCase(Locale.ROOT).contains("#REGEX:") || matchTag.toUpperCase(Locale.ROOT).contains("#IREGEX:")) break block41;
                    cutList = ConfigManager.search(cutList, match.substring(match.indexOf(" ") + 1));
                    break block42;
                }
                if (!match.substring(1).contains(" #")) break block42;
                cutList = ConfigManager.search(cutList, match.substring(match.indexOf(" #") + 1));
                break block42;
            }
            if (match.startsWith("\\#")) {
                match = match.substring(1);
            }
            boolean isRegex = false;
            try {
                Pattern.compile(match);
                isRegex = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Rename r : list) {
                if (!r.getName().toUpperCase(Locale.ROOT).contains(match.toUpperCase(Locale.ROOT)) && (!isRegex || !r.getName().toUpperCase(Locale.ROOT).matches(match.toUpperCase(Locale.ROOT)))) continue;
                cutList.add(r);
            }
        }
        return cutList;
    }

    public static ArrayList<class_2561> parseCustomDescription(String description) {
        String[] splited;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        for (String s : splited = description.replaceAll("\\\\&", String.valueOf('\u00a7')).split("\n")) {
            class_5250 line = class_2561.method_43473();
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                class_5250 text = class_2561.method_43473();
                if (chars[i] == '\\' && i != chars.length - 1 && chars[i + 1] == '#' && i + 7 < chars.length) {
                    StringBuilder color = new StringBuilder();
                    for (int j = 2; j < 8; ++j) {
                        color.append(chars[i + j]);
                    }
                    if (color.toString().matches("[0-9a-fA-F]*")) {
                        text.method_27696(class_2583.field_24360.method_36139(Integer.parseInt(color.toString(), 16)));
                    } else {
                        text.method_27693("\\#" + String.valueOf(color));
                    }
                    i += 8;
                }
                StringBuilder stringBuilder = new StringBuilder();
                while (i < chars.length) {
                    if (chars[i] == '\\' && chars[i + 1] == '#') {
                        --i;
                        break;
                    }
                    stringBuilder.append(chars[i]);
                    ++i;
                }
                text.method_10852((class_2561)class_2561.method_43471((String)stringBuilder.toString()));
                line.method_10852((class_2561)text);
            }
            lines.add((class_2561)line);
        }
        return lines;
    }

    public static void configClear() {
        RPRenames.renames.clear();
    }
}

