/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.util.config;

import com.HiWord9.RPRenames.util.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public class Rename {
    private final String name;
    private ArrayList<String> items;
    private final String packName;
    private final String path;
    private final Integer stackSize;
    private final Damage damage;
    private final String enchantment;
    private final Integer enchantmentLevel;
    private final Properties properties;
    private final String description;
    private final Mob mob;
    private final boolean cem;

    public Rename(String name) {
        this(name, null, null, null, null, null, null, null, null, null, null);
    }

    public Rename(String name, String item) {
        this(name, new ArrayList<String>(List.of(item)));
    }

    public Rename(String name, ArrayList<String> items) {
        this(name, items, null, null, null, null, null, null, null, null, null);
    }

    public Rename(String name, String packName, Mob mob) {
        this(name, new ArrayList<String>(List.of("name_tag")), packName, null, null, null, null, null, null, null, mob);
    }

    public Rename(String name, ArrayList<String> items, String packName, String path, Integer stackSize, Damage damage, String enchantment, Integer enchantmentLevel, Properties properties, String description, @Nullable Mob mob) {
        this.name = name;
        this.items = items;
        this.packName = packName;
        this.path = path == null ? null : path.replace("\\", "/");
        this.stackSize = stackSize;
        this.damage = damage;
        this.enchantment = enchantment;
        this.enchantmentLevel = enchantmentLevel;
        this.properties = properties;
        this.description = description;
        this.mob = mob;
        this.cem = mob != null;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalNbtDisplayName() {
        return this.properties == null ? (this.cem ? this.mob.getPropName() : null) : this.properties.getProperty("nbt.display.Name");
    }

    public ArrayList<String> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<String> items) {
        this.items = items;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getPath() {
        return this.path;
    }

    public Integer getStackSize() {
        return this.stackSize == null ? 1 : this.stackSize;
    }

    public String getOriginalStackSize() {
        return this.properties == null ? null : this.properties.getProperty("stackSize");
    }

    public Damage getDamage() {
        return this.damage;
    }

    public String getOriginalDamage() {
        return this.properties == null ? null : this.properties.getProperty("damage");
    }

    public String getEnchantment() {
        return this.enchantment;
    }

    public String getOriginalEnchantment() {
        return this.properties == null ? null : this.properties.getProperty("enchantmentIDs");
    }

    public Integer getEnchantmentLevel() {
        return this.enchantmentLevel == null ? 1 : this.enchantmentLevel;
    }

    public String getOriginalEnchantmentLevel() {
        return this.properties == null ? null : this.properties.getProperty("enchantmentLevels");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    public Mob getMob() {
        return this.mob;
    }

    public boolean isCEM() {
        return this.cem;
    }

    public boolean equals(Rename obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Rename obj, boolean ignoreNull) {
        boolean originalNbtDisplayNameEquals = this.paramsEquals(this.getOriginalNbtDisplayName(), obj.getOriginalNbtDisplayName(), ignoreNull);
        boolean stackSizeEquals = this.paramsEquals(this.getStackSize(), obj.getStackSize(), ignoreNull);
        boolean originalStackSizeEquals = this.paramsEquals(this.getOriginalStackSize(), obj.getOriginalStackSize(), ignoreNull);
        boolean damageEquals = this.paramsEquals(this.getDamage(), obj.getDamage(), ignoreNull);
        boolean originalDamageEquals = this.paramsEquals(this.getOriginalDamage(), obj.getOriginalDamage(), ignoreNull);
        boolean enchantmentEquals = this.paramsEquals(this.getEnchantment(), obj.getEnchantment(), ignoreNull);
        boolean originalEnchantmentEquals = this.paramsEquals(this.getOriginalEnchantment(), obj.getOriginalEnchantment(), ignoreNull);
        boolean eEnchantmentLevelEquals = this.paramsEquals(this.getEnchantmentLevel(), obj.getEnchantmentLevel(), ignoreNull);
        boolean originalEnchantmentLevelEquals = this.paramsEquals(this.getOriginalEnchantmentLevel(), obj.getOriginalEnchantmentLevel(), ignoreNull);
        return this.name.equals(obj.name) && originalNbtDisplayNameEquals && stackSizeEquals && originalStackSizeEquals && damageEquals && originalDamageEquals && enchantmentEquals && originalEnchantmentEquals && eEnchantmentLevelEquals && originalEnchantmentLevelEquals;
    }

    private boolean paramsEquals(Object obj1, Object obj2, boolean ignoreNull) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return ignoreNull;
        }
        return obj1.equals(obj2);
    }

    public boolean isContainedIn(ArrayList<Rename> list) {
        return this.isContainedIn(list, false);
    }

    public boolean isContainedIn(ArrayList<Rename> list, boolean ignoreNull) {
        for (Rename r : list) {
            if (!this.equals(r, ignoreNull)) continue;
            return true;
        }
        return false;
    }

    public int indexIn(ArrayList<Rename> list, boolean ignoreNull) {
        if (!this.isContainedIn(list, ignoreNull)) {
            return -1;
        }
        int i = 0;
        for (Rename r : list) {
            if (this.equals(r, ignoreNull)) break;
            ++i;
        }
        return i;
    }

    public static boolean isInBounds(int n, String list) {
        return Rename.isInBounds(n, list, null);
    }

    public static boolean isInBounds(int n, String list, @Nullable String damagedItem) {
        if (list == null) {
            return true;
        }
        if (!(list.contains(" ") || list.contains("-") || list.contains("%"))) {
            return n == Integer.parseInt(Rename.getFirstValue(list));
        }
        for (String s : Rename.split(list)) {
            if (s.contains("-")) {
                assert (damagedItem != null);
                class_1792 item = ConfigManager.itemFromName(damagedItem);
                if (s.indexOf("-") == s.length() - 1) {
                    Damage minDamage;
                    String min = s.substring(0, s.length() - 1);
                    if (!(min.endsWith("%") ? n >= (minDamage = new Damage(Integer.parseInt(min = min.substring(0, min.length() - 1)), true)).getParsedDamage(item) : n >= Integer.parseInt(min))) continue;
                    return true;
                }
                int i = s.indexOf(45);
                String min = s.substring(0, i);
                String max = s.substring(i + 1);
                if (max.endsWith("%")) {
                    max = max.replace("%", "");
                    Damage minDamage = new Damage(Integer.parseInt(min), true);
                    Damage maxDamage = new Damage(Integer.parseInt(max), true);
                    if (n < minDamage.getParsedDamage(item) || n > maxDamage.getParsedDamage(item)) continue;
                    return true;
                }
                if (n < Integer.parseInt(min) || n > Integer.parseInt(max)) continue;
                return true;
            }
            if (n != Integer.parseInt(s)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> split(String list) {
        ArrayList<String> split = new ArrayList<String>();
        if (list.contains(" ")) {
            int i1 = 0;
            for (int i = 0; i <= list.length(); ++i) {
                if (i != list.length() && list.charAt(i) != ' ') continue;
                split.add(list.substring(i1, i));
                i1 = i + 1;
            }
        } else {
            split.add(list);
        }
        return split;
    }

    public static int parseDamagePercent(int percent, class_1792 item) {
        int maxDamage = item.method_7841();
        return maxDamage * percent / 100;
    }

    public static String getFirstValue(String string) {
        StringBuilder builder = new StringBuilder();
        for (int n = 0; n < string.length() && string.charAt(n) != '-' && string.charAt(n) != ' '; ++n) {
            builder.append(string.charAt(n));
        }
        if (string.contains("%")) {
            builder.append("%");
        }
        return builder.toString();
    }

    public static boolean isFavorite(String item, String name) {
        ArrayList<Rename> favoriteList = ConfigManager.getFavorites(item);
        for (Rename r : favoriteList) {
            if (!r.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static class Damage {
        public int damage;
        public boolean percent;

        public Damage(Integer damage, boolean percent) {
            this.damage = damage;
            this.percent = percent;
        }

        public int getParsedDamage(class_1792 item) {
            if (!this.percent) {
                return this.damage;
            }
            return Rename.parseDamagePercent(this.damage, item);
        }
    }

    public record Mob(String entity, String icon, Properties properties, String path) {
        public String getPropName() {
            Set<String> propertyNames = this.properties.stringPropertyNames();
            for (String s : propertyNames) {
                if (!s.startsWith("name.") || !propertyNames.contains("skins." + s.substring(5))) continue;
                return this.properties.getProperty(s);
            }
            return null;
        }
    }
}

