/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.playlist.search.GuiMusicSearch;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntry;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.util.TimeUtil;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_332;

public class GuiMusicSearchListEntryPlaylist
extends GuiMusicSearchListEntry {
    private final IAudioTrackList trackList;
    private final String name;
    private final String duration;

    public GuiMusicSearchListEntryPlaylist(GuiMusicSearch gui, Playlist playlist, IAudioTrackList trackList) {
        this.trackList = trackList;
        this.name = trackList.getName();
        List<IAudioTrack> tracks = trackList.getTracks();
        this.duration = !tracks.parallelStream().anyMatch(track -> track.getInfo().isStream()) ? TimeUtil.timeConversion(tracks.parallelStream().mapToLong(track -> track.getDuration()).sum() / 1000L) : MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
        this.addTrackButton.setPressable(() -> {
            playlist.add(trackList);
            gui.setInformation(class_124.field_1060 + MusicPlayerLocalization.getTranslation("gui.search.added_list", new Object[0]), 150);
        });
    }

    @Override
    public void method_25343(class_332 guiGraphics, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        super.method_25343(guiGraphics, slotIndex, entryY, entryX, entryWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        guiGraphics.method_51433(this.minecraft.field_1772, this.name, entryX + 5, entryY + 15, 16048706, false);
        guiGraphics.method_51433(this.minecraft.field_1772, this.duration, entryX + entryWidth - 135, entryY + 5, 0xFFFF00, false);
    }

    public IAudioTrackList getTrackList() {
        return this.trackList;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        String uri;
        if (button == 2 && GuiTrackUtils.openURI(uri = this.trackList.getUri())) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }
}

