/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.exordium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.exordium.BufferManager;
import dev.tr7zw.exordium.NametagSettings;
import dev.tr7zw.exordium.PreLoadedMod;
import dev.tr7zw.exordium.SignSettings;
import dev.tr7zw.exordium.config.Config;
import dev.tr7zw.exordium.config.ConfigUpgrader;
import dev.tr7zw.exordium.config.ExordiumConfigScreen;
import dev.tr7zw.exordium.util.CustomShaderManager;
import dev.tr7zw.exordium.util.DelayedRenderCallManager;
import dev.tr7zw.exordium.util.NametagScreenBuffer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.class_276;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ExordiumModBase {
    public static final Logger LOGGER = LogManager.getLogger((String)"Exordium");
    public static ExordiumModBase instance = new PreLoadedMod();
    private static boolean forceBlend;
    public Config config;
    private final File settingsFile = new File("config", "exordium.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private NametagScreenBuffer nametagScreenBuffer;
    private class_276 temporaryScreenOverwrite = null;
    public static SignSettings signSettings;
    public static NametagSettings nametagSettings;
    private final DelayedRenderCallManager delayedRenderCallManager = new DelayedRenderCallManager();
    private final CustomShaderManager customShaderManager = new CustomShaderManager();
    private final BufferManager bufferManager = new BufferManager();

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                this.config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
        this.bufferManager.initialize();
        this.initModloader();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public NametagScreenBuffer getNameTagScreenBuffer() {
        if (this.nametagScreenBuffer == null) {
            this.nametagScreenBuffer = new NametagScreenBuffer(1000 / this.config.targetFPSNameTags);
        }
        return this.nametagScreenBuffer;
    }

    public DelayedRenderCallManager getDelayedRenderCallManager() {
        return this.delayedRenderCallManager;
    }

    public abstract void initModloader();

    public class_437 createConfigScreen(class_437 parent) {
        return new ExordiumConfigScreen(parent);
    }

    public static boolean isForceBlend() {
        return forceBlend;
    }

    public static void setForceBlend(boolean forceBlend) {
        ExordiumModBase.forceBlend = forceBlend;
    }

    public static void correctBlendMode() {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
    }

    public class_276 getTemporaryScreenOverwrite() {
        return this.temporaryScreenOverwrite;
    }

    public void setTemporaryScreenOverwrite(class_276 temporaryScreenOverwrite) {
        this.temporaryScreenOverwrite = temporaryScreenOverwrite;
    }

    public CustomShaderManager getCustomShaderManager() {
        return this.customShaderManager;
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    static {
        signSettings = new SignSettings();
        nametagSettings = new NametagSettings();
    }
}

