/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.sync;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2540;

public abstract class DataHolder {
    private class_2540 lastKnownValue;

    public abstract class_2540 get();

    public abstract void set(class_2540 var1);

    public boolean checkAndClearUpdateFlag() {
        class_2540 buffer = this.get();
        boolean changed = !buffer.equals((Object)this.lastKnownValue);
        this.lastKnownValue = buffer;
        return changed;
    }

    public static final DataHolder createHolder(final Supplier<class_2540> supplier, final Consumer<class_2540> consumer) {
        return new DataHolder(){

            @Override
            public class_2540 get() {
                return new class_2540(((class_2540)supplier.get()).copy());
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(new class_2540(buffer.copy()));
            }
        };
    }

    public static final DataHolder createByteHolder(final Supplier<Byte> supplier, final Consumer<Byte> consumer) {
        return new DataHolder(){
            private byte lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.buffer((int)1).writeByte((int)((Byte)supplier.get()).byteValue()));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(buffer.readByte());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                byte value = (Byte)supplier.get();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createShortHolder(final Supplier<Short> supplier, final Consumer<Short> consumer) {
        return new DataHolder(){
            private short lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.copyShort((int)((Short)supplier.get()).shortValue()));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(buffer.readShort());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                short value = (Short)supplier.get();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createIntHolder(final IntSupplier supplier, final IntConsumer consumer) {
        return new DataHolder(){
            private int lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.copyInt((int)supplier.getAsInt()));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(buffer.readInt());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                int value = supplier.getAsInt();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createLongHolder(final LongSupplier supplier, final LongConsumer consumer) {
        return new DataHolder(){
            private long lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.copyLong((long)supplier.getAsLong()));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(buffer.readLong());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                long value = supplier.getAsLong();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createFloatHolder(final Supplier<Float> supplier, final Consumer<Float> consumer) {
        return new DataHolder(){
            private float lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.copyFloat((float)((Float)supplier.get()).floatValue()));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(Float.valueOf(buffer.readFloat()));
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                float value = ((Float)supplier.get()).floatValue();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createDoubleHolder(final Supplier<Double> supplier, final Consumer<Double> consumer) {
        return new DataHolder(){
            private double lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.copyDouble((double)((Double)supplier.get())));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(buffer.readDouble());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                double value = (Double)supplier.get();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }

    public static final DataHolder createBooleanHolder(final BooleanSupplier supplier, final BooleanConsumer consumer) {
        return new DataHolder(){
            private boolean lastKnownValue;

            @Override
            public class_2540 get() {
                return new class_2540(Unpooled.copyBoolean((boolean)supplier.getAsBoolean()));
            }

            @Override
            public void set(class_2540 buffer) {
                consumer.accept(buffer.readBoolean());
            }

            @Override
            public boolean checkAndClearUpdateFlag() {
                boolean value = supplier.getAsBoolean();
                boolean changed = value != this.lastKnownValue;
                this.lastKnownValue = value;
                return changed;
            }
        };
    }
}

