/*
 * Decompiled with CFR 0.152.
 */
package de.johni0702.minecraft.bobby;

import de.johni0702.minecraft.bobby.Bobby;
import de.johni0702.minecraft.bobby.LastAccessFile;
import de.johni0702.minecraft.bobby.util.RegionPos;
import io.netty.util.concurrent.DefaultThreadFactory;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_155;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2897;
import net.minecraft.class_310;
import net.minecraft.class_3977;
import net.minecraft.class_4698;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FakeChunkStorage
extends class_3977 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<Path, FakeChunkStorage> active = new HashMap<Path, FakeChunkStorage>();
    public static final Pattern REGION_FILE_PATTERN = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final Path directory;
    private final boolean writeable;
    private final AtomicBoolean sentUpgradeNotification = new AtomicBoolean();
    @Nullable
    private final LastAccessFile lastAccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FakeChunkStorage getFor(Path directory, boolean writeable) {
        Map<Path, FakeChunkStorage> map = active;
        synchronized (map) {
            return active.computeIfAbsent(directory, f -> new FakeChunkStorage(directory, writeable));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Map<Path, FakeChunkStorage> map = active;
        synchronized (map) {
            for (FakeChunkStorage storage : active.values()) {
                try {
                    storage.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close storage", (Throwable)e);
                }
            }
            active.clear();
        }
    }

    private FakeChunkStorage(Path directory, boolean writeable) {
        super(directory, class_310.method_1551().method_1543(), false);
        this.directory = directory;
        this.writeable = writeable;
        LastAccessFile lastAccess = null;
        if (writeable) {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                lastAccess = new LastAccessFile(directory);
            }
            catch (IOException e) {
                LOGGER.error("Failed to read last_access file:", (Throwable)e);
            }
        }
        this.lastAccess = lastAccess;
    }

    public void close() throws IOException {
        super.close();
        if (this.lastAccess != null) {
            int deleteUnusedRegionsAfterDays = Bobby.getInstance().getConfig().getDeleteUnusedRegionsAfterDays();
            if (deleteUnusedRegionsAfterDays >= 0) {
                LongListIterator longListIterator = this.lastAccess.pollRegionsOlderThan(deleteUnusedRegionsAfterDays).iterator();
                while (longListIterator.hasNext()) {
                    long entry = (Long)longListIterator.next();
                    int x = class_1923.method_8325((long)entry);
                    int z = class_1923.method_8332((long)entry);
                    Files.deleteIfExists(this.directory.resolve("r." + x + "." + z + ".mca"));
                }
            }
            this.lastAccess.close();
        }
    }

    public void save(class_1923 pos, class_2487 chunk) {
        if (this.lastAccess != null) {
            this.lastAccess.touchRegion(pos.method_17885(), pos.method_17886());
        }
        this.method_17910(pos, chunk);
    }

    public CompletableFuture<Optional<class_2487>> loadTag(class_1923 pos) {
        return this.method_23696(pos).thenApply(maybeNbt -> maybeNbt.map(nbt -> this.loadTag(pos, (class_2487)nbt)));
    }

    private class_2487 loadTag(class_1923 pos, class_2487 nbt) {
        if (nbt != null && this.lastAccess != null) {
            this.lastAccess.touchRegion(pos.method_17885(), pos.method_17886());
        }
        if (nbt != null && nbt.method_10550("DataVersion") != class_155.method_16673().method_37912().method_38494()) {
            if (this.sentUpgradeNotification.compareAndSet(false, true)) {
                class_310 client = class_310.method_1551();
                client.method_20493(() -> {
                    class_5250 text = class_2561.method_43471((String)(this.writeable ? "bobby.upgrade.required" : "bobby.upgrade.fallback_world"));
                    client.method_20493(() -> FakeChunkStorage.lambda$loadTag$3(client, (class_2561)text));
                });
            }
            return null;
        }
        return nbt;
    }

    public static List<RegionPos> getRegions(Path directory) throws IOException {
        try (Stream<Path> stream = Files.list(directory);){
            List<RegionPos> list = stream.map(Path::getFileName).map(Path::toString).map(REGION_FILE_PATTERN::matcher).filter(Matcher::matches).map(it -> new RegionPos(Integer.parseInt(it.group(1)), Integer.parseInt(it.group(2)))).collect(Collectors.toList());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgrade(class_5321<class_1937> worldKey, BiConsumer<Integer, Integer> progress) throws IOException {
        Optional<class_5321> generatorKey = Optional.of((class_5321)class_7923.field_41157.method_29113((Object)class_2897.field_24769).orElseThrow());
        List chunks = FakeChunkStorage.getRegions(this.directory).stream().flatMap(RegionPos::getContainedChunks).toList();
        AtomicInteger done = new AtomicInteger();
        AtomicInteger total = new AtomicInteger(chunks.size());
        progress.accept(done.get(), total.get());
        class_4698 io = (class_4698)this.method_39800();
        int workThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        ExecutorService workExecutor = Executors.newFixedThreadPool(workThreads, (ThreadFactory)new DefaultThreadFactory("bobby-upgrade-worker", true));
        try {
            for (class_1923 chunkPos : chunks) {
                workExecutor.submit(() -> {
                    class_2487 nbt;
                    try {
                        nbt = ((Optional)io.method_31738(chunkPos).join()).orElse(null);
                    }
                    catch (CompletionException e) {
                        LOGGER.warn("Error reading chunk " + chunkPos.field_9181 + "/" + chunkPos.field_9180 + ":", (Throwable)e);
                        nbt = null;
                    }
                    if (nbt == null) {
                        progress.accept(done.get(), total.decrementAndGet());
                        return;
                    }
                    nbt.method_10556("isLightOn", true);
                    nbt = this.method_17907(worldKey, null, nbt, generatorKey);
                    io.method_23703(chunkPos, nbt).join();
                    progress.accept(done.incrementAndGet(), total.get());
                });
            }
        }
        finally {
            workExecutor.shutdown();
        }
        try {
            workExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        progress.accept(done.get(), total.get());
    }

    private static /* synthetic */ void lambda$loadTag$3(class_310 client, class_2561 text) {
        client.field_1705.method_1743().method_1812(text);
    }
}

