/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.popup;

import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public abstract class AbstractScreenPopup
implements class_4068 {
    private static final int BACKGROUND_TEXTURE_SIZE = 32;
    private static final float FADE_TIME = 20.0f;
    protected static final int RENDER_Z = 1;
    protected final class_310 client;
    protected final int centerX;
    protected final int centerY;
    private int width;
    private int height;
    private boolean show;
    private float shownTime;
    private float fadeTime;

    public AbstractScreenPopup(class_310 client, int centerX, int centerY, int width, int height) {
        this.client = client;
        this.centerX = centerX;
        this.centerY = centerY;
        this.width = width;
        this.height = height;
    }

    protected void show(float time) {
        this.show = true;
        this.shownTime = time;
    }

    public boolean shouldShow() {
        return this.show;
    }

    protected final int getLeft() {
        return this.centerX - this.width / 2;
    }

    protected final int getRight() {
        return this.getLeft() + this.width;
    }

    protected final int getTop() {
        return this.centerY - this.height / 2;
    }

    protected final int getBottom() {
        return this.getTop() + this.height;
    }

    protected final int getWidth() {
        return this.width;
    }

    protected final int getHeight() {
        return this.height;
    }

    protected final int getFadeAlpha() {
        return (int)((20.0f - this.fadeTime) / 20.0f * 255.0f);
    }

    protected void updateSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.show && mouseX >= (double)this.getLeft() && mouseX < (double)this.getRight() && mouseY >= (double)this.getTop() && mouseY < (double)this.getBottom();
    }

    protected void updateShownTime(float delta) {
        if (this.shouldUpdateTime() && this.show) {
            if (this.shownTime > 0.0f) {
                this.shownTime -= delta;
                if (this.shownTime <= 0.0f) {
                    this.shownTime = 0.0f;
                    this.fadeTime = 0.0f;
                }
            } else if (this.fadeTime >= 0.0f) {
                this.fadeTime += delta;
                if (this.fadeTime >= 20.0f) {
                    this.fadeTime = 0.0f;
                    this.show = false;
                    this.reset();
                }
            }
        }
    }

    protected boolean shouldUpdateTime() {
        return true;
    }

    protected void reset() {
    }

    public final void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.show) {
            this.renderBackground(graphics);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
            this.renderContent(graphics, mouseX, mouseY, delta);
            graphics.method_51448().method_22909();
            this.updateShownTime(delta);
        }
    }

    protected void renderBackground(class_332 graphics) {
        int alpha = this.getFadeAlpha();
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.method_51737(this.getLeft() - 1, this.getTop() - 1, this.getRight() + 1, this.getBottom() + 1, 1, alpha << 24);
        graphics.method_51422(0.25f, 0.25f, 0.25f, (float)alpha / 255.0f);
        graphics.method_25291(class_437.field_44669, this.getLeft(), this.getTop(), 1, 0.0f, 0.0f, this.width, this.height, 32, 32);
    }

    protected abstract void renderContent(class_332 var1, int var2, int var3, float var4);
}

