/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.popup;

import java.util.function.Supplier;
import me.bymartrixx.vtd.gui.popup.AbstractScreenPopup;
import me.bymartrixx.vtd.util.RenderUtil;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ProgressBarScreenPopup
extends AbstractScreenPopup {
    private static final int BAR_HEIGHT = 10;
    private static final int BAR_OUTLINE_SIZE = 1;
    private static final int BAR_MARGIN = 10;
    private final int color;
    private Supplier<Float> progress = () -> Float.valueOf(0.0f);
    private Runnable onReset;
    private boolean aborted;

    public ProgressBarScreenPopup(class_310 client, int centerX, int centerY, int width, int height, int color) {
        super(client, centerX, centerY, width, height);
        this.color = color;
    }

    public void show(float time, Supplier<Float> progress, Runnable onReset) {
        this.show(time);
        this.progress = progress;
        this.onReset = onReset;
    }

    public void abortWait() {
        this.aborted = true;
    }

    private int getBarWidth() {
        return this.getWidth() - 20;
    }

    @Override
    protected boolean shouldUpdateTime() {
        return this.aborted || this.progress.get().floatValue() >= 1.0f;
    }

    @Override
    protected void reset() {
        this.aborted = false;
        this.onReset.run();
    }

    @Override
    protected void renderContent(class_332 graphics, int mouseX, int mouseY, float delta) {
        float p = this.progress.get().floatValue();
        if (p < 0.0f) {
            return;
        }
        int barWidth = this.getBarWidth();
        int progressWidth = Math.round((float)(barWidth - 2) * p);
        int x = this.centerX - barWidth / 2;
        int y = this.centerY - 5;
        int color = this.color | this.getFadeAlpha() << 24;
        graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtil.drawOutline(graphics, x, y, barWidth, 10, 1, color);
        graphics.method_25294(x + 1, y + 1, x + 1 + progressWidth, y + 10 - 1, color);
    }
}

