/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.widget;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.bymartrixx.vtd.VTDMod;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.data.Pack;
import me.bymartrixx.vtd.gui.VTDownloadScreen;
import me.bymartrixx.vtd.gui.widget.PackSelectionData;
import me.bymartrixx.vtd.gui.widget.PackSelectionHelper;
import me.bymartrixx.vtd.util.Constants;
import me.bymartrixx.vtd.util.RenderUtil;
import me.bymartrixx.vtd.util.Util;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_350;
import net.minecraft.class_5481;
import net.minecraft.class_5489;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;

public class PackSelectionListWidget
extends class_350<AbstractEntry> {
    private static final boolean SHOW_DEBUG_INFO = false;
    private static final boolean DISABLE_ICONS = false;
    private static final class_2561 ERROR_URL = Util.urlText("https://vanillatweaks.net");
    private static final class_2561 ERROR_HEADER = class_2561.method_43471((String)"vtd.packError.title").method_27695(new class_124[]{class_124.field_1067, class_124.field_1056});
    private static final class_2561 ERROR_BODY = class_2561.method_43469((String)"vtd.packError.body", (Object[])new Object[]{ERROR_URL});
    private static final class_2561 ERROR_TEXT = class_2561.method_43473().method_10852(ERROR_HEADER).method_27693("\n").method_10852(ERROR_BODY);
    public static final int ITEM_HEIGHT = 32;
    private static final int WARNING_MARGIN = 6;
    private static final int WARNING_BG_MARGIN = 4;
    private static final int ROW_LEFT_RIGHT_MARGIN = 10;
    private static final int SCROLLBAR_LEFT_MARGIN = 4;
    private static final int TEXT_MARGIN = 2;
    private static final int ICON_MARGIN = 1;
    private static final int SELECTION_OUTLINE_COLOR = -8355712;
    private final Map<Category, List<AbstractEntry>> entryCache = new HashMap<Category, List<AbstractEntry>>();
    private final VTDownloadScreen screen;
    private Category category;
    private boolean editable = true;
    private final List<class_5481> errorLines;
    private final class_5489 errorText;
    private final PackSelectionHelper selectionHelper;

    public PackSelectionListWidget(class_310 client, VTDownloadScreen screen, int width, int height, int y, Category category, PackSelectionHelper selectionHelper) {
        super(client, width, height, y, 32);
        this.screen = screen;
        this.category = category;
        this.selectionHelper = selectionHelper;
        this.errorLines = Util.getMultilineTextLines(client.field_1772, ERROR_TEXT, 8, (int)((double)y / 1.5));
        this.errorText = Util.createMultilineText(client.field_1772, ERROR_TEXT, 8, (int)((double)y / 1.5));
        this.method_25396().addAll(this.getPackEntries(category));
    }

    public void setCategory(Category category) {
        this.category = category;
        this.method_25395(null);
        this.method_25314(this.getPackEntries(category));
        this.method_25307(0.0);
    }

    public void updateCategories(List<Category> categories) {
        this.selectionHelper.buildIncompatibilityGroups(categories);
    }

    private List<AbstractEntry> getPackEntries(Category category) {
        if (category == null) {
            return Collections.emptyList();
        }
        if (this.entryCache.containsKey(category)) {
            return this.entryCache.get(category);
        }
        ArrayList<AbstractEntry> entries = new ArrayList<AbstractEntry>();
        if (category.hasWarning()) {
            entries.add(new WarningEntry(this.field_22740, this.screen, category.getWarning()));
        }
        if (category instanceof Category.SubCategory) {
            Category.SubCategory subCategory = (Category.SubCategory)category;
            entries.add(new ParentCategoryButtonEntry(this.field_22740, this.screen, subCategory));
        }
        for (Pack pack : category.getPacks()) {
            if (pack.isExperimental()) continue;
            PackEntry entry = new PackEntry(this, pack);
            entries.add(entry);
            if (!this.selectionHelper.isSelected(pack)) continue;
            entry.selectionData.toggleSelection();
        }
        if (category.getSubCategories() != null) {
            for (Category.SubCategory subCategory : category.getSubCategories()) {
                entries.add(new SubCategoryButtonEntry(this.field_22740, this.screen, subCategory));
            }
        }
        this.entryCache.put(category, entries);
        return entries;
    }

    public void updateSelection() {
        for (List<AbstractEntry> categoryEntries : this.entryCache.values()) {
            for (AbstractEntry entry : categoryEntries) {
                if (!(entry instanceof PackEntry)) continue;
                PackEntry packEntry = (PackEntry)entry;
                if (this.selectionHelper.isSelected(packEntry.pack) == packEntry.selectionData.isSelected()) continue;
                packEntry.selectionData.toggleSelection();
            }
        }
    }

    private void toggleSelection(PackEntry entry) {
        if (this.editable) {
            this.selectionHelper.toggleSelection(entry);
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private int getEntrySelectionColor(AbstractEntry entry) {
        if (entry instanceof PackEntry) {
            PackEntry packEntry = (PackEntry)entry;
            return this.selectionHelper.getSelectionColor(packEntry.getPack());
        }
        return -268435456;
    }

    private int getCenterX() {
        return this.method_46426() + this.field_22758 / 2;
    }

    private int getCenterY() {
        return this.field_22759 / 2;
    }

    private static int getLineHeight(class_327 textRenderer) {
        Objects.requireNonNull(textRenderer);
        return 9 + 2;
    }

    public void updateScreenWidth() {
        this.method_25358(this.screen.getLeftWidth());
    }

    public void focusPack(Pack pack) {
        PackEntry entry = null;
        for (int i = 0; i < this.method_25396().size(); ++i) {
            AbstractEntry e = (AbstractEntry)((Object)this.method_25396().get(i));
            if (!(e instanceof PackEntry)) continue;
            PackEntry packEntry = (PackEntry)e;
            if (packEntry.pack != pack) continue;
            entry = packEntry;
        }
        if (entry != null) {
            this.method_25324(entry);
        }
    }

    public int method_25322() {
        return this.field_22758 - 20;
    }

    protected int method_25329() {
        return this.method_46426() + this.method_25322() + 10 + 4;
    }

    protected boolean method_25332(int index) {
        AbstractEntry entry = (AbstractEntry)((Object)this.method_25396().get(index));
        if (entry instanceof PackEntry) {
            PackEntry packEntry = (PackEntry)entry;
            return packEntry.selectionData.isSelected();
        }
        return false;
    }

    private int getTooltipWidth() {
        return (int)((double)this.field_22758 / 2.5);
    }

    public boolean method_25370() {
        return this.screen.method_25399() == this;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.method_25396().isEmpty()) {
            int l;
            class_5481 line;
            class_2583 style;
            int x = this.getCenterX();
            int textWidth = this.errorText.method_44048();
            int startX = x - textWidth / 2;
            int endX = x + textWidth / 2;
            int y = this.getCenterY();
            class_327 textRenderer = this.field_22740.field_1772;
            int lineHeight = PackSelectionListWidget.getLineHeight(textRenderer);
            int startY = y - lineHeight * 2;
            int endY = y + lineHeight * 3;
            if (mouseX >= (double)startX && mouseX < (double)endX && mouseY >= (double)startY && mouseY < (double)endY && (style = Util.getStyleAt(textRenderer, x, mouseX, line = this.errorLines.get(l = (int)((mouseY - (double)startY) / (double)lineHeight)))) != null && style.method_10970() != null && style.method_10970().method_10845() == class_2558.class_2559.field_11749) {
                this.screen.method_25430(style);
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        AbstractEntry focusedEntry;
        if (this.method_25370() && (keyCode == 257 || keyCode == 335) && (focusedEntry = (AbstractEntry)this.method_25336()) instanceof PackEntry) {
            PackEntry entry = (PackEntry)focusedEntry;
            this.toggleSelection(entry);
        }
        return false;
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_48579(graphics, mouseX, mouseY, delta);
        if (this.method_25396().isEmpty()) {
            this.renderError(graphics);
        }
    }

    protected void method_44397(class_332 graphics, int mouseX, int mouseY, float delta, int index, int entryX, int entryY, int width, int height) {
        boolean focused;
        AbstractEntry entry = (AbstractEntry)this.method_25326(index);
        boolean bl = focused = this.method_25370() && this.method_25336() == entry;
        if (this.method_25332(index)) {
            int outlineColor = focused ? -1 : -8355712;
            int color = this.getEntrySelectionColor(entry);
            this.method_44398(graphics, entryY, width, height, outlineColor, color);
        } else if (focused) {
            RenderUtil.drawOutline(graphics, entryX - 1, entryY - 1, width - 2, height + 2, 1, -1);
        }
        entry.method_25343(graphics, index, entryY, entryX, width, height, mouseX, mouseY, Objects.equals(this.method_37019(), (Object)entry), delta);
    }

    private void renderError(class_332 graphics) {
        class_327 textRenderer = this.field_22740.field_1772;
        int x = this.getCenterX();
        int y = this.getCenterY();
        int lineHeight = PackSelectionListWidget.getLineHeight(textRenderer);
        this.errorText.method_30889(graphics, x, y - lineHeight * 2, lineHeight, 0xFFFFFF);
    }

    public void renderDebugInfo(class_332 graphics, int mouseX, int mouseY) {
    }

    public void renderTooltips(class_332 graphics, int mouseX, int mouseY) {
        block1: {
            AbstractEntry entry;
            if (mouseY < this.method_46427() || mouseY >= this.method_55443() || mouseX < this.method_46426() || mouseX >= this.method_55442() || this.screen.isCoveredByPopup(mouseX, mouseY)) break block1;
            int width = this.getTooltipWidth();
            Iterator iterator = this.method_25396().iterator();
            while (iterator.hasNext() && !(entry = (AbstractEntry)((Object)iterator.next())).renderTooltip(graphics, mouseX, mouseY, width)) {
            }
        }
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, Constants.RESOURCE_PACK_SCREEN_SUBTITLE);
    }

    public static class WarningEntry
    extends AbstractEntry {
        private final Category.Warning warning;
        private final int color;
        private List<class_2561> textLines;
        private class_5489 text;

        public WarningEntry(class_310 client, VTDownloadScreen screen, Category.Warning warning) {
            super(client, screen);
            this.warning = warning;
            this.color = Util.parseColor(warning.getColor());
        }

        private List<class_2561> getWrappedText(int maxWidth) {
            return this.wrapEscapedText(this.warning.getText(), maxWidth);
        }

        private List<class_2561> getTextLines(int maxWidth) {
            if (this.textLines != null) {
                return this.textLines;
            }
            this.textLines = this.getWrappedText(maxWidth);
            return this.textLines;
        }

        private class_5489 getText(int maxWidth) {
            if (this.text != null) {
                return this.text;
            }
            this.text = this.createMultilineText(this.getWrappedText(maxWidth));
            return this.text;
        }

        @Override
        protected List<class_2561> getTooltipText(int width) {
            return this.getTextLines(width);
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.renderBackground(graphics, x + 4, y + 4, entryWidth - 8, entryHeight - 8);
            int width = entryWidth - 12;
            this.renderText(graphics, x + 6 + width / 2, y + 6, width);
        }

        private void renderBackground(class_332 graphics, int x, int y, int width, int height) {
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.method_25294(x, y, x + width, y + height, this.color);
        }

        private void renderText(class_332 graphics, int x, int y, int width) {
            this.getText(width).method_30888(graphics, x, y);
        }

        public String toString() {
            return "Warning";
        }
    }

    public static class ParentCategoryButtonEntry
    extends CategoryButtonEntry {
        protected ParentCategoryButtonEntry(class_310 client, VTDownloadScreen screen, Category.SubCategory subCategory) {
            super(client, screen, subCategory.getParent());
        }

        public String toString() {
            return "Parent category " + this.category.getName();
        }
    }

    public static class PackEntry
    extends AbstractEntry {
        private final Pack pack;
        private final class_2561 name;
        private final PackSelectionListWidget widget;
        private final class_2960 icon;
        private boolean downloadedIcon = false;
        private boolean iconExists;
        private List<class_2561> description;
        private class_5489 shortDescription;
        private int lastDescriptionWidth;
        protected PackSelectionData selectionData;

        public PackEntry(PackSelectionListWidget widget, Pack pack) {
            super(widget.field_22740, widget.screen);
            this.pack = pack;
            this.name = class_2561.method_30163((String)pack.getName()).method_27661().method_27692(class_124.field_1067);
            this.widget = widget;
            this.icon = VTDMod.getIconId(pack);
            this.iconExists = this.client.method_1531().method_34590(this.icon, null) != null;
            this.selectionData = new PackSelectionData(this.pack, widget.category);
        }

        private List<class_2561> getDescriptionLines(int maxWidth) {
            return this.wrapEscapedText(this.pack.getDescription(), maxWidth);
        }

        private List<class_2561> getDescription(int maxWidth) {
            if (this.description != null) {
                return this.description;
            }
            this.description = this.getDescriptionLines(maxWidth);
            return this.description;
        }

        private class_5489 getShortDescription(int maxWidth) {
            if (maxWidth == this.lastDescriptionWidth && this.shortDescription != null) {
                return this.shortDescription;
            }
            this.shortDescription = this.createMultilineText(this.getDescriptionLines(maxWidth));
            this.lastDescriptionWidth = maxWidth;
            return this.shortDescription;
        }

        public Pack getPack() {
            return this.pack;
        }

        private void downloadIcon() {
            if (this.downloadedIcon || this.iconExists) {
                return;
            }
            this.downloadedIcon = true;
            VTDMod.downloadIcon(this.pack).whenCompleteAsync((success, throwable) -> {
                if (throwable != null) {
                    VTDMod.LOGGER.error("Failed to download icon for pack {}", (Object)this.pack.getName(), throwable);
                    return;
                }
                if (success.booleanValue()) {
                    this.iconExists = this.client.method_1531().method_34590(this.icon, null) != null;
                } else {
                    VTDMod.LOGGER.error("Failed to download icon for pack {}", (Object)this.pack.getName());
                }
            });
        }

        @Override
        protected List<class_2561> getTooltipText(int width) {
            return this.getDescription(width);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.widget.toggleSelection(this);
                return true;
            }
            return false;
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            class_327 textRenderer = this.client.field_1772;
            int iconSize = entryHeight - 2;
            int centerX = x + (iconSize + entryWidth) / 2;
            graphics.method_27534(textRenderer, this.name, centerX, y, 0xFFFFFF);
            this.renderDescription(graphics, centerX, y + PackSelectionListWidget.getLineHeight(textRenderer), entryWidth - iconSize);
            this.renderIcon(graphics, x + 1, y + 1, iconSize);
        }

        private void renderDescription(class_332 graphics, int x, int y, int width) {
            this.getShortDescription(width - 2).method_30888(graphics, x, y);
        }

        private void renderIcon(class_332 graphics, int x, int y, int size) {
            this.downloadIcon();
            if (!this.iconExists) {
                return;
            }
            graphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.method_25290(this.icon, x, y, 0.0f, 0.0f, size, size, size, size);
        }

        public String toString() {
            return "Pack " + this.pack.getName();
        }
    }

    public static class SubCategoryButtonEntry
    extends CategoryButtonEntry {
        protected SubCategoryButtonEntry(class_310 client, VTDownloadScreen screen, Category.SubCategory category) {
            super(client, screen, category);
        }

        public String toString() {
            return "Sub category " + this.category.getName();
        }
    }

    public static abstract class AbstractEntry
    extends class_350.class_351<AbstractEntry> {
        protected final class_310 client;
        protected final VTDownloadScreen screen;

        protected AbstractEntry(class_310 client, VTDownloadScreen screen) {
            this.client = client;
            this.screen = screen;
        }

        protected final List<class_2561> wrapEscapedText(String text, int maxWidth) {
            return Util.wrapText(this.client.field_1772, Util.removeHtmlTags(text), maxWidth);
        }

        protected final class_5489 createMultilineText(List<class_2561> lines) {
            return Util.createMultilineText(this.client.field_1772, lines, 2);
        }

        protected abstract List<class_2561> getTooltipText(int var1);

        protected boolean renderTooltip(class_332 graphics, int mouseX, int mouseY, int width) {
            if (this.method_25405(mouseX, mouseY)) {
                graphics.method_51434(this.client.field_1772, this.getTooltipText(width), mouseX, mouseY);
                return true;
            }
            return false;
        }
    }

    public static abstract class CategoryButtonEntry
    extends AbstractEntry {
        protected static final int BUTTON_HEIGHT = 20;
        protected static final int BUTTON_HORIZONTAL_PADDING = 32;
        protected static final class_2960 TEXTURE = new class_2960("widget/button");
        protected final Category category;
        protected final class_2561 name;

        protected CategoryButtonEntry(class_310 client, VTDownloadScreen screen, Category category) {
            super(client, screen);
            this.category = category;
            this.name = class_2561.method_43470((String)category.getName()).method_27692(class_124.field_1067);
        }

        @Override
        protected List<class_2561> getTooltipText(int width) {
            return Collections.emptyList();
        }

        private void playDownSound(class_1144 soundManager) {
            soundManager.method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.screen.selectCategory(this.category);
                this.playDownSound(this.client.method_1483());
                return true;
            }
            return false;
        }

        public void method_25343(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            graphics.method_52706(TEXTURE, x + 32, y + (entryHeight - 20) / 2, entryWidth - 64, 20);
            class_327 class_3272 = this.client.field_1772;
            int n = x + entryWidth / 2;
            Objects.requireNonNull(this.client.field_1772);
            graphics.method_27534(class_3272, this.name, n, y + (entryHeight - 9) / 2, 0xFFFFFF);
        }
    }
}

