/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerOptions;
import io.github.lgatodu47.screenshot_viewer.screen.IconButtonWidget;
import io.github.lgatodu47.screenshot_viewer.screen.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screen.manage_screenshots.ScreenshotImageHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

class ScreenshotPropertiesMenu
extends class_362
implements class_4068 {
    private static final class_2960 BACKGROUND_TEXTURE = new class_2960("screenshot_viewer", "textures/gui/screenshot_properties_background.png");
    static final class_2960 OPEN_ICON = new class_2960("screenshot_viewer", "widget/icons/open_folder");
    static final class_2960 COPY_ICON = new class_2960("screenshot_viewer", "widget/icons/copy");
    static final class_2960 DELETE_ICON = new class_2960("screenshot_viewer", "widget/icons/delete");
    static final class_2960 RENAME_ICON = new class_2960("screenshot_viewer", "widget/icons/rename");
    private static final class_2960 CLOSE_ICON = new class_2960("screenshot_viewer", "widget/icons/close");
    private static final int BUTTON_SIZE = 19;
    private final Supplier<class_310> mcSupplier;
    private final List<class_339> buttons = new ArrayList<class_339>();
    private int x;
    private int y;
    private int width;
    private int height;
    private ScreenshotImageHolder targetScreenshot;
    private boolean shouldRender;

    ScreenshotPropertiesMenu(Supplier<class_310> mcSupplier) {
        this.mcSupplier = mcSupplier;
        this.addButton(OPEN_ICON, ScreenshotViewerTexts.OPEN_FILE, ScreenshotImageHolder::openFile);
        this.addButton(COPY_ICON, ScreenshotViewerTexts.COPY, ScreenshotImageHolder::copyScreenshot);
        this.addButton(DELETE_ICON, ScreenshotViewerTexts.DELETE, ScreenshotImageHolder::requestFileDeletion);
        this.addButton(RENAME_ICON, ScreenshotViewerTexts.RENAME_FILE, ScreenshotImageHolder::renameFile);
        this.addButton(CLOSE_ICON, ScreenshotViewerTexts.CLOSE_PROPERTIES, null);
    }

    private void addButton(class_2960 texture, class_2561 description, @Nullable Consumer<ScreenshotImageHolder> action) {
        this.buttons.add((class_339)new Button(texture, description, btn -> {
            if (action != null && this.targetScreenshot != null) {
                action.accept(this.targetScreenshot);
            }
            this.hide();
        }));
    }

    void show(int x, int y, int parentWidth, int parentHeight, ScreenshotImageHolder targetScreenshot) {
        this.targetScreenshot = targetScreenshot;
        int spacing = 2;
        class_327 font = this.mcSupplier.get().field_1772;
        int largestTextWidth = this.buttons.stream().map(class_339::method_25369).mapToInt(arg_0 -> ((class_327)font).method_27525(arg_0)).max().orElse(0);
        this.width = 4 + Math.max(font.method_1727(targetScreenshot.getScreenshotFile().getName()), 19 + largestTextWidth + 4);
        Objects.requireNonNull(font);
        this.height = 6 + 9 + 19 * this.buttons.size();
        this.x = x + this.width > parentWidth ? x - this.width : x;
        this.y = y + this.height > parentHeight ? y - this.height : y;
        for (int i = 0; i < this.buttons.size(); ++i) {
            Objects.requireNonNull(font);
            this.buttons.get(i).method_55444(this.width - 4, 19, this.x + 2, this.y + 4 + 9 + 19 * i);
        }
        this.shouldRender = true;
    }

    void hide() {
        this.shouldRender = false;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
    }

    boolean renders() {
        return this.shouldRender;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.shouldRender) {
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416(0.0f, 0.0f, 1.0f);
            int spacing = 2;
            context.method_25290(BACKGROUND_TEXTURE, this.x, this.y, 0.0f, 0.0f, 2, 2, 8, 8);
            context.method_25290(BACKGROUND_TEXTURE, this.x + this.width - 2, this.y, 6.0f, 0.0f, 2, 2, 8, 8);
            context.method_25290(BACKGROUND_TEXTURE, this.x, this.y + this.height - 2, 0.0f, 6.0f, 2, 2, 8, 8);
            context.method_25290(BACKGROUND_TEXTURE, this.x + this.width - 2, this.y + this.height - 2, 6.0f, 6.0f, 2, 2, 8, 8);
            context.method_25290(BACKGROUND_TEXTURE, this.x + 2, this.y, (float)(this.width * 3) / 2.0f, 0.0f, this.width - 4, 2, this.width * 4, 8);
            context.method_25290(BACKGROUND_TEXTURE, this.x, this.y + 2, 0.0f, (float)(this.height * 3) / 2.0f, 2, this.height - 4, 8, this.height * 4);
            context.method_25290(BACKGROUND_TEXTURE, this.x + 2, this.y + this.height - 2, (float)(this.width * 3) / 2.0f, 6.0f, this.width - 4, 2, this.width * 4, 8);
            context.method_25290(BACKGROUND_TEXTURE, this.x + this.width - 2, this.y + 2, 6.0f, (float)(this.height * 3) / 2.0f, 2, this.height - 4, 8, this.height * 4);
            context.method_25290(BACKGROUND_TEXTURE, this.x + 2, this.y + 2, (float)(this.width * 3) / 2.0f, (float)(this.height * 3) / 2.0f, this.width - 4, this.height - 4, this.width * 4, this.height * 4);
            context.method_25303(this.mcSupplier.get().field_1772, this.targetScreenshot.getScreenshotFile().getName(), this.x + 2, this.y + 2, -1);
            for (class_339 widget : this.buttons) {
                widget.method_25394(context, mouseX, mouseY, delta);
                matrices.method_22903();
                matrices.method_46416(0.0f, 0.0f, 1.0f);
                context.method_27535(this.mcSupplier.get().field_1772, widget.method_25369(), widget.method_46426() + 19 + 2, (int)((float)widget.method_46427() + (float)(widget.method_25364() - 9) / 2.0f + 2.0f), -1);
                matrices.method_22909();
            }
            matrices.method_22909();
        }
    }

    public List<? extends class_364> method_25396() {
        return List.copyOf(this.buttons);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX > (double)(this.x + this.width) || mouseY > (double)(this.y + this.height)) {
            this.hide();
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.hide();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private static final class Button
    extends IconButtonWidget {
        private static final class_8666 BUTTON_TEXTURES = new class_8666(new class_2960("screenshot_viewer", "widget/properties_button_enabled"), new class_2960("screenshot_viewer", "widget/properties_button"), new class_2960("screenshot_viewer", "widget/properties_button_hovered"));
        private static final class_8666 TEXTURES_FOR_WIDE = new class_8666(new class_2960("screenshot_viewer", "textures/gui/sprites/widget/properties_button_enabled.png"), new class_2960("screenshot_viewer", "textures/gui/sprites/widget/properties_button.png"), new class_2960("screenshot_viewer", "textures/gui/sprites/widget/properties_button_hovered.png"));
        private boolean renderWide = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.RENDER_WIDE_PROPERTIES_BUTTON, (Object)true);

        public Button(class_2960 texture, class_2561 title, class_4185.class_4241 pressAction) {
            super(0, 0, 19, 19, title, texture, pressAction);
        }

        public void method_55444(int width, int height, int x, int y) {
            this.renderWide = (Boolean)ManageScreenshotsScreen.CONFIG.getOrFallback(ScreenshotViewerOptions.RENDER_WIDE_PROPERTIES_BUTTON, (Object)true);
            super.method_55444(this.renderWide ? width : this.method_25368(), height, x, y);
        }

        @Override
        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            class_2960 backgroundTexture = this.getBackgroundTexture().method_52729(this.field_22763, this.method_25367());
            if (this.renderWide) {
                context.method_25290(backgroundTexture, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 1, this.method_25364(), 19, 19);
                context.method_25293(backgroundTexture, this.method_46426() + 1, this.method_46427(), this.method_25368() - 2, this.method_25364(), 1.0f, 0.0f, 17, 19, 19, 19);
                context.method_25290(backgroundTexture, this.method_46426() + this.method_25368() - 1, this.method_46427(), 18.0f, 0.0f, 1, this.method_25364(), 19, 19);
            } else {
                context.method_52706(backgroundTexture, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            }
            class_2960 icon = this.getIconTexture();
            if (icon != null) {
                context.method_52706(icon, this.method_46426(), this.method_46427(), 19, this.method_25364());
            }
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public boolean method_25367() {
            return this.method_49606();
        }

        @Override
        public class_8666 getBackgroundTexture() {
            return this.renderWide ? TEXTURES_FOR_WIDE : BUTTON_TEXTURES;
        }
    }
}

