/*
 * Decompiled with CFR 0.152.
 */
package org.samo_lego.fabrictailor.network;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5250;
import net.minecraft.class_8610;
import net.minecraft.server.MinecraftServer;
import org.samo_lego.fabrictailor.FabricTailor;
import org.samo_lego.fabrictailor.casts.TailoredPlayer;
import org.samo_lego.fabrictailor.network.SkinPackets;
import org.samo_lego.fabrictailor.util.SkinFetcher;
import org.samo_lego.fabrictailor.util.TextTranslations;

public class NetworkHandler {
    public static void onInit(class_3244 listener, MinecraftServer _server) {
        class_3222 player = listener.method_32311();
        FabricTailor.THREADPOOL.submit(() -> {
            Optional<String> value = ((TailoredPlayer)player).fabrictailor_getSkinValue();
            Optional<String> signature = ((TailoredPlayer)player).fabrictailor_getSkinSignature();
            Property skinData = null;
            if (value.isEmpty() || signature.isEmpty()) {
                if (!FabricTailor.config.defaultSkin.applyToAll) {
                    skinData = SkinFetcher.fetchSkinByName(player.method_7334().getName());
                }
                if (skinData == null) {
                    String defValue = FabricTailor.config.defaultSkin.value;
                    String defSignature = FabricTailor.config.defaultSkin.signature;
                    if (!defValue.isEmpty() && !defSignature.isEmpty()) {
                        skinData = new Property("textures", defValue, defSignature);
                    }
                }
            } else {
                skinData = new Property("textures", value.get(), signature.get());
            }
            if (skinData != null) {
                ((TailoredPlayer)player).fabrictailor_setSkin(skinData, false);
            }
            ((TailoredPlayer)player).fabrictailor_resetLastSkinChange();
        });
    }

    public static class_2540 createHelloPacket(boolean allowDefaultSkinButton) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_52964(allowDefaultSkinButton);
        return buf;
    }

    public static void changeVanillaSkinPacket(MinecraftServer _server, class_3222 player, class_3244 _listener, class_2540 buf, PacketSender _sender) {
        NetworkHandler.onSkinChangePacket(player, buf, () -> {});
    }

    public static void defaultSkinPacket(MinecraftServer _server, class_3222 player, class_3244 _listener, class_2540 buf, PacketSender _sender) {
        if (player.method_5687(2)) {
            String value = buf.method_19772();
            String signature = buf.method_19772();
            FabricTailor.config.defaultSkin.value = value;
            FabricTailor.config.defaultSkin.signature = signature;
            FabricTailor.config.save();
            player.method_43496((class_2561)TextTranslations.create("command.fabrictailor.config.defaultSkin", new Object[0]).method_27692(class_124.field_1060));
        }
    }

    public static void changeHDSkinPacket(MinecraftServer _server, class_3222 player, class_3244 _listener, class_2540 buf, PacketSender _sender) {
        NetworkHandler.onSkinChangePacket(player, buf, () -> player.method_7353((class_2561)TextTranslations.create("hint.fabrictailor.client_only", new Object[0]).method_27692(class_124.field_1064), false));
    }

    public static void onSkinChangePacket(class_3222 player, class_2540 buf, Runnable callback) {
        long lastChange = ((TailoredPlayer)player).fabrictailor_getLastSkinChange();
        long now = System.currentTimeMillis();
        if (now - lastChange > FabricTailor.config.skinChangeTimer * 1000L || lastChange == 0L) {
            ((TailoredPlayer)player).fabrictailor_setSkin(buf.method_43624(), true);
            callback.run();
        } else {
            class_5250 timeLeft = class_2561.method_43470((String)String.valueOf((FabricTailor.config.skinChangeTimer * 1000L - now + lastChange) / 1000L)).method_27692(class_124.field_1076);
            player.method_7353((class_2561)TextTranslations.create("command.fabrictailor.skin.timer.please_wait", timeLeft).method_27692(class_124.field_1061), false);
        }
    }

    public static void onConfigured(class_8610 listener, MinecraftServer server) {
        if (ServerConfigurationNetworking.canSend((class_8610)listener, (class_2960)SkinPackets.FT_HELLO)) {
            try {
                class_2540 packetBuf = NetworkHandler.createHelloPacket((Boolean)Permissions.check((GameProfile)listener.method_52404(), (String)"fabrictailor.set_default_skin", (int)2, (MinecraftServer)server).get());
                ServerConfigurationNetworking.send((class_8610)listener, (class_2960)SkinPackets.FT_HELLO, (class_2540)packetBuf);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

