/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.slotify.GuiModifier;
import net.mehvahdjukaar.polytone.slotify.ScreenModifier;
import net.mehvahdjukaar.polytone.slotify.SlotModifier;
import net.mehvahdjukaar.polytone.utils.JsonPartialReloader;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GuiModifierManager
extends JsonPartialReloader {
    private static final Map<class_3917<?>, Int2ObjectArrayMap<SlotModifier>> SLOTS_BY_MENU_ID = new IdentityHashMap();
    private static final Map<Class<?>, Int2ObjectArrayMap<SlotModifier>> SLOTS_BY_CLASS = new IdentityHashMap();
    private static final Map<String, Int2ObjectArrayMap<SlotModifier>> SLOTS_BY_TITLE = new HashMap<String, Int2ObjectArrayMap<SlotModifier>>();
    public static final Map<class_3917<?>, ScreenModifier> BY_MENU_ID = new IdentityHashMap();
    public static final Map<Class<?>, ScreenModifier> BY_CLASS = new IdentityHashMap();
    public static final Map<String, ScreenModifier> BY_TITLE = new HashMap<String, ScreenModifier>();
    private static final class_2960 INVENTORY = new class_2960("inventory");

    public GuiModifierManager() {
        super("gui_modifiers");
    }

    @Override
    protected void reset() {
        SLOTS_BY_MENU_ID.clear();
        SLOTS_BY_CLASS.clear();
        SLOTS_BY_TITLE.clear();
        BY_MENU_ID.clear();
        BY_CLASS.clear();
        BY_TITLE.clear();
    }

    @Override
    protected void process(Map<class_2960, JsonElement> object) {
        ArrayList<GuiModifier> allModifiers = new ArrayList<GuiModifier>();
        for (Map.Entry<class_2960, JsonElement> entry : object.entrySet()) {
            JsonElement json = entry.getValue();
            class_2960 id = entry.getKey();
            GuiModifier modifier = (GuiModifier)((Pair)GuiModifier.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, errorMsg -> Polytone.LOGGER.warn("Could not decode GUI Modifier with json res {} - error: {}", (Object)id, errorMsg))).getFirst();
            allModifiers.add(modifier);
        }
        for (GuiModifier mod : allModifiers) {
            if (mod.targetsClass()) {
                String target = mod.target();
                try {
                    Class cl = target.equals("InventoryMenu") ? class_1723.class : (target.equals("ItemPickerMenu") ? class_481.class_483.class : Class.forName(target));
                    BY_CLASS.merge(cl, new ScreenModifier(mod), (a, b) -> b.merge((ScreenModifier)a));
                    if (mod.slotModifiers().isEmpty()) continue;
                    Int2ObjectArrayMap map = SLOTS_BY_CLASS.computeIfAbsent(cl, i -> new Int2ObjectArrayMap());
                    GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                }
                catch (ClassNotFoundException ignored) {
                    Polytone.LOGGER.error("Could not find class target with name {}", (Object)target);
                }
                continue;
            }
            if (mod.targetsMenuId()) {
                class_2960 menuId = new class_2960(mod.target());
                boolean isInventory = menuId.equals((Object)INVENTORY);
                Optional menu = class_7923.field_41187.method_17966(menuId);
                if (!menu.isPresent() && !isInventory) continue;
                BY_MENU_ID.merge(menu.orElse(null), new ScreenModifier(mod), (a, b) -> b.merge((ScreenModifier)a));
                if (mod.slotModifiers().isEmpty()) continue;
                Int2ObjectArrayMap map = SLOTS_BY_MENU_ID.computeIfAbsent(menu.orElse(null), i -> new Int2ObjectArrayMap());
                GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
                continue;
            }
            String title = mod.target();
            BY_TITLE.merge(title, new ScreenModifier(mod), (a, b) -> b.merge((ScreenModifier)a));
            if (mod.slotModifiers().isEmpty()) continue;
            Int2ObjectArrayMap map = SLOTS_BY_TITLE.computeIfAbsent(title, i -> new Int2ObjectArrayMap());
            GuiModifierManager.unwrapSlots(mod, (Int2ObjectArrayMap<SlotModifier>)map);
        }
        Polytone.LOGGER.info("Loaded GUI modifiers for: " + SLOTS_BY_MENU_ID.keySet() + " " + SLOTS_BY_CLASS.keySet() + " " + BY_MENU_ID.keySet() + " " + BY_CLASS.keySet());
    }

    private static void unwrapSlots(GuiModifier mod, Int2ObjectArrayMap<SlotModifier> map) {
        for (SlotModifier s : mod.slotModifiers()) {
            for (int i : s.targets().getSlots()) {
                map.merge(i, (Object)s, SlotModifier::merge);
            }
        }
    }

    private static ScreenModifier getScreenModifier(class_465<?> screen) {
        ScreenModifier m = null;
        class_1703 menu = screen.method_17577();
        if (screen.getClass() == class_490.class) {
            m = BY_CLASS.get(class_1723.class);
        } else if (screen.getClass() == class_481.class) {
            m = BY_CLASS.get(class_481.class_483.class);
        }
        if (menu != null) {
            m = BY_CLASS.get(menu.getClass());
        }
        if (m == null) {
            class_3917 type;
            try {
                type = menu.method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = BY_MENU_ID.get(type);
        }
        return m;
    }

    @Nullable
    public static ScreenModifier getGuiModifier(class_437 screen) {
        class_5250 mc;
        class_7417 class_74172;
        class_2561 c;
        ScreenModifier m = BY_CLASS.get(screen.getClass());
        if (m == null && screen instanceof class_465) {
            class_465 as = (class_465)screen;
            m = GuiModifierManager.getScreenModifier(as);
        }
        try {
            c = screen.method_25440();
        }
        catch (Exception e) {
            return null;
        }
        if (m == null) {
            m = BY_TITLE.get(c.getString());
        }
        if (m == null && c instanceof class_5250 && (class_74172 = (mc = (class_5250)c).method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            m = BY_TITLE.get(tc.method_11022());
        }
        return m;
    }

    @Nullable
    public static SlotModifier getSlotModifier(class_465<?> screen, class_1735 slot) {
        class_5250 mc;
        class_7417 class_74172;
        Int2ObjectArrayMap<SlotModifier> m = null;
        class_2561 c = screen.method_25440();
        m = SLOTS_BY_TITLE.get(c.getString());
        if (m == null && c instanceof class_5250 && (class_74172 = (mc = (class_5250)c).method_10851()) instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            m = SLOTS_BY_TITLE.get(tc.method_11022());
        }
        if (m == null) {
            m = SLOTS_BY_CLASS.get(screen.getClass());
        }
        if (m == null) {
            SLOTS_BY_CLASS.get(screen.method_17577().getClass());
        }
        if (m == null) {
            class_3917 type;
            try {
                type = screen.method_17577().method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = SLOTS_BY_MENU_ID.get(type);
        }
        if (m != null) {
            return (SlotModifier)m.get(slot.field_7874);
        }
        return null;
    }

    @Nullable
    public static SlotModifier getSlotModifier(class_1703 menu, class_1735 slot) {
        Int2ObjectArrayMap<SlotModifier> m = SLOTS_BY_CLASS.get(menu.getClass());
        if (m == null) {
            class_3917 type;
            try {
                type = menu.method_17358();
            }
            catch (Exception e) {
                type = null;
            }
            m = SLOTS_BY_MENU_ID.get(type);
        }
        if (m != null) {
            return (SlotModifier)m.get(slot.field_7874);
        }
        return null;
    }

    public static void maybeModifySlot(class_1703 menu, class_1735 slot) {
        SlotModifier mod = GuiModifierManager.getSlotModifier(menu, slot);
        if (mod != null) {
            mod.modify(slot);
        }
    }

    public static boolean maybeChangeColor(class_465<?> screen, class_1735 slot, class_332 graphics, int x, int y, int offset) {
        SlotModifier mod = GuiModifierManager.getSlotModifier(screen, slot);
        if (mod != null && mod.hasCustomColor()) {
            mod.renderCustomHighlight(graphics, x, y, offset);
            return false;
        }
        return true;
    }
}

