/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.class_5699;

public interface TargetSlots {
    public static final Codec<TargetSlots> CODEC = new Codec<TargetSlots>(){
        final Codec<SingleTarget> c1 = class_5699.field_33441.xmap(SingleTarget::new, SingleTarget::slot);
        final Codec<ListTarget> c2 = class_5699.field_33441.listOf().xmap(ListTarget::new, ListTarget::slots);
        final Codec<RangeTarget> c3 = Codec.STRING.comapFlatMap(RangeTarget::read, RangeTarget::toString);

        public <T> DataResult<T> encode(TargetSlots input, DynamicOps<T> ops, T prefix) {
            if (input instanceof SingleTarget) {
                SingleTarget t = (SingleTarget)input;
                return this.c1.encode((Object)t, ops, prefix);
            }
            if (input instanceof ListTarget) {
                ListTarget t = (ListTarget)input;
                return this.c2.encode((Object)t, ops, prefix);
            }
            if (input instanceof RangeTarget) {
                RangeTarget t = (RangeTarget)input;
                return this.c3.encode((Object)t, ops, prefix);
            }
            throw new IllegalArgumentException("Unsupported implementation type: " + input.getClass());
        }

        public <T> DataResult<Pair<TargetSlots, T>> decode(DynamicOps<T> ops, T input) {
            TargetSlots target = null;
            Optional r1 = this.c1.decode(ops, input).result();
            if (r1.isEmpty()) {
                Optional r2 = this.c2.decode(ops, input).result();
                if (r2.isEmpty()) {
                    Optional r3 = this.c3.decode(ops, input).result();
                    if (r3.isPresent()) {
                        target = (TargetSlots)((Pair)r3.get()).getFirst();
                    }
                } else {
                    target = (TargetSlots)((Pair)r2.get()).getFirst();
                }
            } else {
                target = (TargetSlots)((Pair)r1.get()).getFirst();
            }
            if (target != null) {
                return DataResult.success((Object)Pair.of((Object)target, input));
            }
            return DataResult.error(() -> "Failed to decode SlotTarget. Must either be an int, an array or a range (i.e. '3->7')");
        }
    };

    public Iterable<Integer> getSlots();

    public record SingleTarget(int slot) implements TargetSlots
    {
        @Override
        public Iterable<Integer> getSlots() {
            return Collections.singleton(this.slot);
        }
    }

    public record ListTarget(List<Integer> slots) implements TargetSlots
    {
        @Override
        public Iterable<Integer> getSlots() {
            return this.slots;
        }
    }

    public record RangeTarget(int min, int max) implements TargetSlots
    {
        @Override
        public Iterable<Integer> getSlots() {
            return IntStream.rangeClosed(this.min, this.max)::iterator;
        }

        @Override
        public String toString() {
            return this.min + "->" + this.max;
        }

        public static DataResult<RangeTarget> read(String input) {
            String[] parts = input.split("->");
            if (parts.length != 2) {
                return DataResult.error(() -> "Invalid format. Expected format: 'xOffset->yOffset'");
            }
            try {
                int num1 = Integer.parseInt(parts[0]);
                int num2 = Integer.parseInt(parts[1]);
                if (num1 < 0 || num2 < 0) {
                    return DataResult.error(() -> "Slots must be positive");
                }
                if (num2 <= num1) {
                    return DataResult.error(() -> "Invalid range, min must be smaller than max");
                }
                return DataResult.success((Object)new RangeTarget(num1, num2));
            }
            catch (NumberFormatException e) {
                return DataResult.error(() -> "Invalid number format. Both numbers should be integers.");
            }
        }
    }
}

