/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5253;
import net.minecraft.class_7654;

public record ArrayImage(int[][] pixels, int width, int height) {
    public ArrayImage(int[][] matrix) {
        this(matrix, matrix[0].length, matrix.length);
    }

    public static Map<class_2960, Group> gatherGroupedImages(class_3300 manager, String path) {
        return ArrayImage.groupTextures(ArrayImage.gatherImages(manager, path));
    }

    public static Map<class_2960, ArrayImage> gatherImages(class_3300 manager, String path) {
        HashMap<class_2960, ArrayImage> map = new HashMap<class_2960, ArrayImage>();
        class_7654 helper = new class_7654(path, ".png");
        for (Map.Entry entry : helper.method_45113(manager).entrySet()) {
            class_2960 fileId = (class_2960)entry.getKey();
            class_2960 id = helper.method_45115(fileId);
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                    try {
                        int[][] pixels = ArrayImage.makePixelMatrix(nativeImage);
                        ArrayImage image = new ArrayImage(pixels, nativeImage.method_4307(), nativeImage.method_4323());
                        ArrayImage oldImage = map.put(id, image);
                        if (oldImage == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                    }
                    finally {
                        if (nativeImage == null) continue;
                        nativeImage.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException | IllegalArgumentException | UnsupportedOperationException var14) {
                Polytone.LOGGER.error("Couldn't parse texture file {} from {}", (Object)id, (Object)fileId, (Object)var14);
            }
        }
        return map;
    }

    private static int[][] makePixelMatrix(class_1011 nativeImage) {
        if (nativeImage.method_4318() != class_1011.class_1012.field_4997) {
            throw new UnsupportedOperationException("Can only call makePixelMatrix for RGBA images.");
        }
        int width = nativeImage.method_4307();
        int height = nativeImage.method_4323();
        int[][] pixelMatrix = new int[height][width];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = nativeImage.method_4315(j, i);
                pixelMatrix[i][j] = class_5253.class_5254.method_27764((int)255, (int)class_5253.class_8045.method_48345((int)pixel), (int)class_5253.class_8045.method_48346((int)pixel), (int)class_5253.class_8045.method_48347((int)pixel));
            }
        }
        return pixelMatrix;
    }

    public static Map<class_2960, Group> groupTextures(Map<class_2960, ArrayImage> texturesColormap) {
        LinkedHashMap<class_2960, Group> groupedMap = new LinkedHashMap<class_2960, Group>();
        Pattern pattern = Pattern.compile("(\\D+)(_\\d+)?");
        for (Map.Entry<class_2960, ArrayImage> e : texturesColormap.entrySet()) {
            class_2960 id = e.getKey();
            String str = id.method_12832();
            Matcher matcher = pattern.matcher(str);
            if (!matcher.matches()) continue;
            String key = matcher.group(1);
            String indexMatch = matcher.group(2);
            int index = -1;
            if (indexMatch != null) {
                index = Integer.parseInt(indexMatch.substring(1));
            }
            groupedMap.computeIfAbsent(id.method_45136(key), a -> new Group()).put(index, e.getValue());
        }
        return groupedMap;
    }

    public static class Group
    extends Int2ObjectArrayMap<ArrayImage> {
        public ArrayImage getDefault() {
            return (ArrayImage)this.get(-1);
        }
    }
}

