/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds;

import com.qendolin.betterclouds.NamedLogger;
import com.qendolin.betterclouds.renderdoc.CaptureManager;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import com.qendolin.betterclouds.renderdoc.RenderDocLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.PreLaunchEntrypoint;
import org.apache.logging.log4j.LogManager;

public class PreLaunchHandler
implements PreLaunchEntrypoint {
    public void onPreLaunch() {
        NamedLogger logger = new NamedLogger(LogManager.getLogger((String)"BetterClouds PreLaunch"), !FabricLoader.getInstance().isDevelopmentEnvironment());
        try {
            CaptureManager.LaunchConfig config = CaptureManager.readLaunchConfig();
            if (config.isExpired()) {
                CaptureManager.deleteLaunchConfig();
                return;
            }
            if (!config.load()) {
                return;
            }
            if (!RenderDocLoader.isAvailable()) {
                logger.info("RenderDoc is not available");
                return;
            }
            RenderDocLoader.load();
            if (!RenderDoc.isAvailable()) {
                logger.info("RenderDoc is not available");
                return;
            }
            Path captureTemplatePath = Path.of("./better-clouds/captures/capture", new String[0]);
            Files.createDirectories(captureTemplatePath.getParent(), new FileAttribute[0]);
            RenderDoc.setCaptureOption(RenderDoc.CaptureOption.API_VALIDATION, true);
            RenderDoc.disableOverlayOptions(RenderDoc.OverlayOption.ENABLED);
            RenderDoc.setCaptureKeys(new RenderDoc.Key[0]);
            RenderDoc.setCaptureFilePathTemplate(captureTemplatePath.toString());
            logger.info("RenderDoc loaded and ready");
            if (config.once()) {
                try {
                    CaptureManager.writeLaunchConfig(new CaptureManager.LaunchConfig(false, true, config.expires()));
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            logger.error("RenderDoc could not be loaded: {}", (Throwable)e);
        }
    }
}

