/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.compat;

import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.compat.DistantHorizonsCompat;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRenderPass;
import com.seibel.distanthorizons.api.methods.events.DhApiEventRegister;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderEvent;
import com.seibel.distanthorizons.api.methods.events.interfaces.IDhApiEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiCancelableEventParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiEventParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import java.util.Optional;
import org.joml.Matrix4f;

abstract class DistantHorizonsSharedCompatImpl
extends DistantHorizonsCompat {
    private boolean isDhInitialized = false;
    private DhApiRenderParam lastRenderParam = null;

    public DistantHorizonsSharedCompatImpl() {
        Main.LOGGER.info("Registering DH Api events");
        DhApiEventRegister.on(DhApiAfterDhInitEvent.class, (IDhApiEvent)new DhApiAfterDhInitEvent(){

            public void afterDistantHorizonsInit(DhApiEventParam<Void> dhApiEventParam) {
                DistantHorizonsSharedCompatImpl.this.isDhInitialized = true;
            }
        });
        DhApiEventRegister.on(DhApiBeforeRenderEvent.class, (IDhApiEvent)new DhApiBeforeRenderEvent(){

            public void beforeRender(DhApiCancelableEventParam<DhApiRenderParam> dhApiEventParam) {
                if (((DhApiRenderParam)dhApiEventParam.value).renderPass == EDhApiRenderPass.OPAQUE || ((DhApiRenderParam)dhApiEventParam.value).renderPass == EDhApiRenderPass.OPAQUE_AND_TRANSPARENT) {
                    DistantHorizonsSharedCompatImpl.this.lastRenderParam = (DhApiRenderParam)dhApiEventParam.value;
                }
                if (Main.getConfig().enabled) {
                    DistantHorizonsSharedCompatImpl.this.disableLodClouds();
                }
            }
        });
    }

    @Override
    public boolean isReady() {
        return this.isDhInitialized && this.lastRenderParam != null;
    }

    @Override
    public boolean isEnabled() {
        return this.isDhInitialized && (Boolean)DhApi.Delayed.configs.graphics().renderingEnabled().getValue() != false;
    }

    @Override
    public Matrix4f getProjectionMatrix() {
        float[] mat = this.getDhProjectionMatrixValues(this.lastRenderParam);
        return new Matrix4f(mat[0], mat[4], mat[8], mat[12], mat[1], mat[5], mat[9], mat[13], mat[2], mat[6], mat[10], mat[14], mat[3], mat[7], mat[11], mat[15]);
    }

    abstract float[] getDhProjectionMatrixValues(DhApiRenderParam var1);

    @Override
    public Optional<Integer> getDepthTextureId() {
        DhApiResult result = DhApi.Delayed.renderProxy.getDhDepthTextureId();
        if (result.success) {
            return Optional.of((Integer)result.payload);
        }
        return Optional.empty();
    }
}

