/*
 * Decompiled with CFR 0.152.
 */
package com.qendolin.betterclouds.mixin;

import com.qendolin.betterclouds.Main;
import com.qendolin.betterclouds.clouds.Debug;
import com.qendolin.betterclouds.clouds.Renderer;
import com.qendolin.betterclouds.compat.Telemetry;
import com.qendolin.betterclouds.renderdoc.RenderDoc;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_824;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.lwjgl.opengl.GL32;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class WorldRendererMixin {
    @Unique
    private final Vector3d tempVector = new Vector3d();
    @Unique
    private Renderer cloudRenderer;
    @Shadow
    private class_4604 field_27740;
    @Unique
    private double profTimeAcc;
    @Unique
    private int profFrames;
    @Shadow
    @Nullable
    private class_4604 field_4056;
    @Shadow
    @Final
    private Vector3d field_4091;
    @Shadow
    @Final
    private class_310 field_4088;
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Shadow
    private int field_4073;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(class_310 client, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 bufferBuilders, CallbackInfo ci) {
        if (Main.glCompat.isIncompatible()) {
            return;
        }
        this.cloudRenderer = new Renderer(client);
    }

    @Inject(at={@At(value="TAIL")}, method={"reload(Lnet/minecraft/resource/ResourceManager;)V"})
    private void onReload(class_3300 manager, CallbackInfo ci) {
        if (Main.glCompat.isIncompatible()) {
            return;
        }
        try {
            if (this.cloudRenderer != null) {
                this.cloudRenderer.reload(manager);
            }
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setWorld"})
    private void onSetWorld(class_638 world, CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.setWorld(world);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderClouds(Lnet/minecraft/client/util/math/MatrixStack;Lorg/joml/Matrix4f;FDDD)V"}, cancellable=true)
    private void renderClouds(class_4587 matrices, Matrix4f projMat, float tickDelta, double camX, double camY, double camZ, CallbackInfo ci) {
        if (this.cloudRenderer == null) {
            return;
        }
        if (Main.glCompat.isIncompatible()) {
            return;
        }
        if (this.field_4085 == null) {
            return;
        }
        if (!Main.getConfig().enabledDimensions.contains(this.field_4085.method_44013())) {
            return;
        }
        if (!Main.getConfig().enabled) {
            return;
        }
        this.field_4088.method_16011().method_15396("betterclouds");
        Main.glCompat.pushDebugGroupDev("Better Clouds");
        Vector3d cam = this.tempVector.set(camX, camY, camZ);
        class_4604 frustum = this.field_27740;
        Vector3d frustumPos = cam;
        if (this.field_4056 != null) {
            frustum = this.field_4056;
            frustum.method_23088(this.field_4091.x, this.field_4091.y, this.field_4091.z);
            frustumPos = this.field_4091;
        }
        if (Main.isProfilingEnabled()) {
            GL32.glFinish();
        }
        long startTime = System.nanoTime();
        int ticks = this.field_4073;
        if (Debug.animationPause >= 0) {
            if (Debug.animationPause == 0) {
                Debug.animationPause = ticks;
            } else {
                ticks = Debug.animationPause;
            }
            tickDelta = 0.0f;
        }
        matrices.method_22903();
        try {
            Renderer.PrepareResult prepareResult = this.cloudRenderer.prepare(matrices, projMat, ticks, tickDelta, cam);
            if (RenderDoc.isFrameCapturing()) {
                Main.glCompat.debugMessage("renderer prepare returned " + prepareResult.name());
            }
            if (prepareResult == Renderer.PrepareResult.RENDER) {
                ci.cancel();
                this.cloudRenderer.render(ticks, tickDelta, cam, frustumPos, frustum);
            } else if (prepareResult == Renderer.PrepareResult.NO_RENDER) {
                ci.cancel();
            }
        }
        catch (Exception e) {
            Telemetry.INSTANCE.sendUnhandledException(e);
            throw e;
        }
        matrices.method_22909();
        if (Main.isProfilingEnabled()) {
            GL32.glFinish();
            this.profTimeAcc += (double)(System.nanoTime() - startTime) / 1000000.0;
            ++this.profFrames;
            if (this.profFrames >= Debug.profileInterval) {
                Main.debugChatMessage("profiling.cpuTimes", this.profTimeAcc / (double)this.profFrames);
                this.profFrames = 0;
                this.profTimeAcc = 0.0;
            }
        }
        this.field_4088.method_16011().method_15407();
        Main.glCompat.popDebugGroupDev();
    }

    @Inject(at={@At(value="HEAD")}, method={"close"})
    private void close(CallbackInfo ci) {
        if (this.cloudRenderer != null) {
            this.cloudRenderer.close();
        }
    }
}

