/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.adapter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.github.moremcmeta.moremcmeta.api.client.texture.SpriteName;
import io.github.moremcmeta.moremcmeta.api.math.Point;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Atlas;
import io.github.moremcmeta.moremcmeta.impl.client.texture.Sprite;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public final class AtlasAdapter
implements Atlas {
    private static final Map<class_2960, Map<class_2960, Set<class_2960>>> SPRITE_NAME_MAPPINGS = new ConcurrentHashMap<class_2960, Map<class_2960, Set<class_2960>>>();
    private final class_2960 ATLAS_LOCATION;
    private final class_1059 ATLAS;
    private final ToIntFunction<class_1058> MIPMAP_LEVEL_GETTER;

    public static void addNameMapping(class_2960 atlas, class_2960 fullPath, class_2960 spriteName) {
        Objects.requireNonNull(atlas, "Atlas location cannot be null");
        Objects.requireNonNull(fullPath, "Full path cannot be null");
        Objects.requireNonNull(spriteName, "Sprite name cannot be null");
        SPRITE_NAME_MAPPINGS.computeIfAbsent(atlas, key -> new ConcurrentHashMap()).computeIfAbsent(fullPath, key -> Collections.newSetFromMap(new ConcurrentHashMap())).add(spriteName);
    }

    public static void removeNameMappings(class_2960 atlas, Predicate<class_2960> filter) {
        Objects.requireNonNull(atlas, "Atlas location cannot be null");
        Objects.requireNonNull(filter, "Filter cannot be null");
        SPRITE_NAME_MAPPINGS.computeIfAbsent(atlas, key -> new ConcurrentHashMap()).forEach((fullPath, spriteNames) -> spriteNames.removeIf(filter));
    }

    public static void clearNameMappings() {
        SPRITE_NAME_MAPPINGS.clear();
    }

    public AtlasAdapter(class_2960 location, ToIntFunction<class_1058> mipmapLevelGetter) {
        this.ATLAS_LOCATION = Objects.requireNonNull(location, "Location cannot be null");
        this.MIPMAP_LEVEL_GETTER = Objects.requireNonNull(mipmapLevelGetter, "Mipmap level getter cannot be null");
        class_1044 texture = class_310.method_1551().method_1531().method_4619(location);
        this.ATLAS = texture instanceof class_1059 ? (class_1059)texture : null;
    }

    @Override
    public List<Sprite> sprite(class_2960 location) {
        Objects.requireNonNull(location, "Sprite location cannot be null");
        if (this.ATLAS == null) {
            return ImmutableList.of();
        }
        HashSet<class_2960> names = new HashSet<class_2960>((Collection)SPRITE_NAME_MAPPINGS.getOrDefault(this.ATLAS_LOCATION, (Map<class_2960, Set<class_2960>>)ImmutableMap.of()).getOrDefault(location, (Set<class_2960>)ImmutableSet.of()));
        names.add(location);
        names.add(SpriteName.fromTexturePath(location));
        return names.stream().flatMap(spriteName -> {
            class_1058 sprite = this.ATLAS.method_4608(spriteName);
            if (sprite.method_45851().method_45816().equals((Object)class_1047.method_4539())) {
                return Stream.of(new Sprite[0]);
            }
            return Stream.of(new SpriteAdapter(sprite, this.MIPMAP_LEVEL_GETTER.applyAsInt(sprite), 0, 0, sprite.method_45851().method_45807(), sprite.method_45851().method_45815()));
        }).collect(Collectors.toList());
    }

    private static class SpriteAdapter
    implements Sprite {
        private final class_1058 SPRITE;
        private final long UPLOAD_POINT;
        private final int MIPMAP_LEVEL;
        private final int X_OFFSET_LEFT;
        private final int Y_OFFSET_LEFT;
        private final int X_OFFSET_RIGHT;
        private final int Y_OFFSET_RIGHT;

        public SpriteAdapter(class_1058 sprite, int mipmapLevel, int subAreaX, int subAreaY, int subAreaWidth, int subAreaHeight) {
            this.SPRITE = sprite;
            this.UPLOAD_POINT = this.findUploadPoint();
            if (mipmapLevel < 0) {
                throw new IllegalArgumentException("Sprite cannot have negative mipmaps");
            }
            this.MIPMAP_LEVEL = mipmapLevel;
            this.X_OFFSET_LEFT = subAreaX;
            this.Y_OFFSET_LEFT = subAreaY;
            this.X_OFFSET_RIGHT = sprite.method_45851().method_45807() - subAreaX - subAreaWidth;
            this.Y_OFFSET_RIGHT = sprite.method_45851().method_45815() - subAreaY - subAreaHeight;
            if (this.X_OFFSET_RIGHT < 0 || this.Y_OFFSET_RIGHT < 0) {
                throw new IllegalArgumentException("Sub area is outside sprite bounds");
            }
        }

        @Override
        public class_2960 atlas() {
            return this.SPRITE.method_45852();
        }

        @Override
        public long uploadPoint() {
            return this.UPLOAD_POINT;
        }

        @Override
        public int mipmapLevel() {
            return this.MIPMAP_LEVEL;
        }

        @Override
        public int xOffsetLeft() {
            return this.X_OFFSET_LEFT;
        }

        @Override
        public int yOffsetLeft() {
            return this.Y_OFFSET_LEFT;
        }

        @Override
        public int xOffsetRight() {
            return this.X_OFFSET_RIGHT;
        }

        @Override
        public int yOffsetRight() {
            return this.Y_OFFSET_RIGHT;
        }

        private long findUploadPoint() {
            return Point.pack(this.SPRITE.method_35806(), this.SPRITE.method_35807());
        }
    }
}

