/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.github.moremcmeta.moremcmeta.impl.client.resource.ResourceCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public class OrderedResourceRepository {
    private final class_3264 RESOURCE_TYPE;
    private final ImmutableList<ResourceCollection> COLLECTIONS;
    private final Lock COLLECTIONS_BY_NAMESPACE_LOCK;
    private ImmutableMap<String, List<ResourceCollectionResult>> collectionsByNamespace;

    public OrderedResourceRepository(class_3264 resourceType, Collection<? extends ResourceCollection> resourceCollections) {
        this.RESOURCE_TYPE = Objects.requireNonNull(resourceType, "Resource type cannot be null");
        Objects.requireNonNull(resourceCollections, "Resource collection list cannot be null");
        if (resourceCollections.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("Individual resource collections cannot be null");
        }
        this.COLLECTIONS = ImmutableList.copyOf(resourceCollections);
        this.COLLECTIONS_BY_NAMESPACE_LOCK = new ReentrantLock();
    }

    public class_3264 resourceType() {
        return this.RESOURCE_TYPE;
    }

    public List<ResourceCollection> collections() {
        return this.COLLECTIONS;
    }

    public ResourceCollectionResult firstCollectionWith(class_2960 location) throws IOException {
        Objects.requireNonNull(location, "Location cannot be null");
        Optional<ResourceCollectionResult> collectionWithResource = this.collectionsByNamespace(location.method_12836()).stream().filter(collectionResult -> collectionResult.collection().contains(this.RESOURCE_TYPE, location)).findFirst();
        if (collectionWithResource.isEmpty()) {
            throw new IOException("Resource not found in any collection: " + location);
        }
        return collectionWithResource.get();
    }

    public boolean contains(class_2960 location) {
        Objects.requireNonNull(location, "Location cannot be null");
        return this.collectionsByNamespace(location.method_12836()).stream().anyMatch(collectionResult -> collectionResult.collection().contains(this.RESOURCE_TYPE, location));
    }

    public Set<class_2960> list(String pathStart, Predicate<String> fileFilter) {
        Objects.requireNonNull(pathStart, "Path start cannot be null");
        Objects.requireNonNull(fileFilter, "Path filter cannot be null");
        return this.COLLECTIONS.stream().flatMap(collection -> collection.namespaces(this.RESOURCE_TYPE).stream().flatMap(namespace -> collection.list(this.RESOURCE_TYPE, (String)namespace, pathStart, fileFilter).stream())).collect(Collectors.toSet());
    }

    private List<ResourceCollectionResult> collectionsByNamespace(String namespace) {
        this.COLLECTIONS_BY_NAMESPACE_LOCK.lock();
        if (this.collectionsByNamespace == null) {
            HashMap collections = new HashMap();
            IntStream.range(0, this.COLLECTIONS.size()).mapToObj(index -> new ResourceCollectionResult((ResourceCollection)this.COLLECTIONS.get(index), index)).forEach(collection -> collection.collection().namespaces(this.RESOURCE_TYPE).forEach(collectorNamespace -> collections.computeIfAbsent(collectorNamespace, key -> new ArrayList()).add(collection)));
            this.collectionsByNamespace = ImmutableMap.copyOf(collections);
        }
        this.COLLECTIONS_BY_NAMESPACE_LOCK.unlock();
        return (List)this.collectionsByNamespace.getOrDefault((Object)namespace, (Object)ImmutableList.of());
    }

    public static final class ResourceCollectionResult {
        private final ResourceCollection COLLECTION;
        private final int INDEX;

        private ResourceCollectionResult(ResourceCollection collection, int index) {
            this.COLLECTION = Objects.requireNonNull(collection, "Resource collection cannot be null");
            this.INDEX = index;
        }

        public ResourceCollection collection() {
            return this.COLLECTION;
        }

        public int collectionIndex() {
            return this.INDEX;
        }
    }
}

