/*
 * Decompiled with CFR 0.152.
 */
package io.github.moremcmeta.moremcmeta.impl.client.texture;

import io.github.moremcmeta.moremcmeta.api.client.texture.Color;

public final class ColorBlender {
    private static final double GAMMA = (double)2.2f;
    private static final double INVERSE_GAMMA = 0.4545454446934474;
    private static final int COMPONENT_MAX = 255;
    private static final float[] POW_GAMMA_LOOKUP = new float[256];
    private static final int ALPHA_OFFSET = 24;
    private static final int RED_OFFSET = 0;
    private static final int GREEN_OFFSET = 8;
    private static final int BLUE_OFFSET = 16;

    public static int alphaBlend(int topColor, int bottomColor) {
        float alphaTop = (float)Color.alpha(topColor) / 255.0f;
        float alphaTopComplement = 1.0f - alphaTop;
        float alphaBottom = (float)Color.alpha(bottomColor) / 255.0f;
        float alphaOutput = alphaTop + alphaBottom * alphaTopComplement;
        int alpha = (int)(255.0f * alphaOutput);
        int red = ColorBlender.alphaBlendComponent(topColor, bottomColor, 0, alphaTop, alphaTopComplement, alphaBottom, alphaOutput);
        int green = ColorBlender.alphaBlendComponent(topColor, bottomColor, 8, alphaTop, alphaTopComplement, alphaBottom, alphaOutput);
        int blue = ColorBlender.alphaBlendComponent(topColor, bottomColor, 16, alphaTop, alphaTopComplement, alphaBottom, alphaOutput);
        return ColorBlender.packResult(alpha, red, green, blue);
    }

    public static int blend(int color1, int color2, int color3, int color4) {
        color1 = ColorBlender.zeroIfInvisible(color1);
        color2 = ColorBlender.zeroIfInvisible(color2);
        color3 = ColorBlender.zeroIfInvisible(color3);
        color4 = ColorBlender.zeroIfInvisible(color4);
        int blendedAlpha = ColorBlender.blendComponent(color1, color2, color3, color4, 24);
        int blendedRed = ColorBlender.blendComponent(color1, color2, color3, color4, 0);
        int blendedGreen = ColorBlender.blendComponent(color1, color2, color3, color4, 8);
        int blendedBlue = ColorBlender.blendComponent(color1, color2, color3, color4, 16);
        return ColorBlender.packResult(blendedAlpha, blendedRed, blendedGreen, blendedBlue);
    }

    private static int zeroIfInvisible(int color) {
        return Color.alpha(color) == 0 ? 0 : color;
    }

    private static float adjustGamma(int color, int offset) {
        return POW_GAMMA_LOOKUP[color >> offset & 0xFF];
    }

    private static int blendComponent(int color1, int color2, int color3, int color4, int offset) {
        float gammaAdjusted1 = ColorBlender.adjustGamma(color1, offset);
        float gammaAdjusted2 = ColorBlender.adjustGamma(color2, offset);
        float gammaAdjusted3 = ColorBlender.adjustGamma(color3, offset);
        float gammaAdjusted4 = ColorBlender.adjustGamma(color4, offset);
        float average = (gammaAdjusted1 + gammaAdjusted2 + gammaAdjusted3 + gammaAdjusted4) / 4.0f;
        return (int)(Math.pow(average, 0.4545454446934474) * 255.0);
    }

    private static int alphaBlendComponent(int topColor, int bottomColor, int offset, float alphaTop, float alphaTopComplement, float alphaBottom, float alphaOutput) {
        float gammaAdjustedTop = ColorBlender.adjustGamma(topColor, offset);
        float gammaAdjustedBottom = ColorBlender.adjustGamma(bottomColor, offset);
        float noGammaOutput = (gammaAdjustedTop * alphaTop + gammaAdjustedBottom * alphaBottom * alphaTopComplement) / alphaOutput;
        return (int)(Math.pow(noGammaOutput, 0.4545454446934474) * 255.0);
    }

    private static int packResult(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 0 | green << 8 | blue << 16;
    }

    private ColorBlender() {
    }

    static {
        for (int componentVal = 0; componentVal < POW_GAMMA_LOOKUP.length; ++componentVal) {
            ColorBlender.POW_GAMMA_LOOKUP[componentVal] = (float)Math.pow((float)componentVal / 255.0f, 2.2f);
        }
    }
}

