/*
 * Decompiled with CFR 0.152.
 */
package net.kosmo.music;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.kosmo.music.gui.JukeboxScreen;
import net.kosmo.music.mixin.IMixinMusicTracker;
import net.kosmo.music.toast.MusicToast;
import net.kosmo.music.utils.ModConfig;
import net.kosmo.music.utils.MusicHistory;
import net.kosmo.music.utils.resource.AlbumCover;
import net.kosmo.music.utils.resource.MusicManager;
import net.minecraft.class_1109;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_1145;
import net.minecraft.class_156;
import net.minecraft.class_1813;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ClientMusic
implements ClientModInitializer {
    public static final String MOD_ID = "musicnotification";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MusicNotification");
    public static final class_2960 MUSICS_JSON_ID = new class_2960("musicnotification", "musics.json");
    public static class_304 keyBinding;
    public static class_1144 soundManager;
    public static class_310 client;
    public static MusicManager musicManager;
    public static ModConfig config;
    public static MusicHistory musicHistory;
    @Nullable
    public static class_1113 currentlyPlaying;
    public static class_1145 SoundListener;

    public void onInitializeClient() {
        LOGGER.info("Music Notification initialized");
        ClientMusic.client = class_310.method_1551();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return MUSICS_JSON_ID;
            }

            public void method_14491(class_3300 manager) {
                musicManager.reload();
            }
        });
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        config = (ModConfig)AutoConfig.getConfigHolder(ModConfig.class).getConfig();
        keyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.musicnotification.open_screen", class_3675.class_307.field_1668, 77, "key.musicnotification.categories"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (keyBinding.method_1436()) {
                client.method_1507((class_437)new JukeboxScreen(client.field_1755));
            }
        });
    }

    public static void onClientInit() {
        soundManager = client.method_1483();
        soundManager.method_4878(SoundListener);
        musicManager = new MusicManager(client.method_1478());
        musicManager.reload();
    }

    public static void onDiscPlay(class_3414 song) {
        if (song != null) {
            class_1813 musicDiscItem = class_1813.method_8012((class_3414)song);
            if (musicDiscItem != null) {
                MusicManager.Music music = musicManager.get(musicDiscItem.method_8009().method_14833());
                if (music != null) {
                    MusicToast.show(class_310.method_1551().method_1566(), music);
                } else {
                    String author;
                    String title;
                    LOGGER.info("Unknown music disc {}", (Object)musicDiscItem.method_8009().method_14833());
                    AtomicReference<String> namespace = new AtomicReference<String>(musicDiscItem.method_8009().method_14833().method_12836());
                    FabricLoader.getInstance().getModContainer(namespace.get()).ifPresent(modContainer -> namespace.set(modContainer.getMetadata().getName()));
                    String[] string = musicDiscItem.method_8011().getString().split(" - ");
                    if (string.length >= 2) {
                        title = string[0];
                        author = string[1];
                    } else {
                        title = string[0];
                        author = "Unknown Author";
                    }
                    MusicManager.Music m = new MusicManager.Music(musicDiscItem.method_8009().method_14833(), null, title, author, namespace.get(), AlbumCover.GENERIC, false);
                    MusicToast.show(class_310.method_1551().method_1566(), m);
                }
            }
            LOGGER.debug("Playing music disc: {}", (Object)song.method_14833());
        }
    }

    public static JsonObject parseJSONResource(class_3298 resource) throws IOException, JsonParseException {
        BufferedReader reader = resource.method_43039();
        return class_3518.method_15255((Reader)reader);
    }

    public static boolean isVolumeZero() {
        if (class_310.method_1551().field_1690.method_1630(class_3419.field_15253) == 0.0f) {
            return false;
        }
        return class_310.method_1551().field_1690.method_1630(class_3419.field_15250) != 0.0f;
    }

    public static void playAndResetTracker(class_310 client, MusicManager.Music music) {
        class_3414 soundEvent = music.getSoundEvent(soundManager);
        if (soundEvent == null) {
            LOGGER.warn("Unable to play unknown sound with id: {}", (Object)(music.customId == null ? music.identifier : music.customId));
            return;
        }
        class_1109 soundInstance = class_1109.method_4759((class_3414)soundEvent);
        client.method_1483().method_4875(null, class_3419.field_15253);
        IMixinMusicTracker musicTracker = (IMixinMusicTracker)client.method_1538();
        musicTracker.setCurrent((class_1113)soundInstance);
        client.method_1483().method_4873((class_1113)soundInstance);
        currentlyPlaying = soundInstance;
    }

    public static void drawScrollableText(class_332 context, class_327 textRenderer, class_2561 text, int centerX, int startX, int startY, int endX, int endY, int color, boolean shadow) {
        ClientMusic.drawScrollableText(context, textRenderer, text, centerX, startX, startY, endX, endY, color, shadow, startX, startY, endX, endY);
    }

    public static void drawScrollableText(class_332 context, class_327 textRenderer, class_2561 text, int centerX, int startX, int startY, int endX, int endY, int color, boolean shadow, int clipAreaX1, int clipAreaY1, int clipAreaX2, int clipAreaY2) {
        int i = textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(textRenderer);
        int j = (startY + endY - 9) / 2 + 1;
        int k = endX - startX;
        if (i > k) {
            int l = i - k;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
            context.method_44379(clipAreaX1, clipAreaY1, clipAreaX2, clipAreaY2);
            context.method_51430(textRenderer, text.method_30937(), startX - (int)g, j, color, shadow);
            context.method_44380();
        } else {
            int l = class_3532.method_15340((int)centerX, (int)(startX + i / 2), (int)(endX - i / 2));
            class_5481 orderedText = text.method_30937();
            context.method_51430(textRenderer, orderedText, l - textRenderer.method_30880(orderedText) / 2, j, color, shadow);
        }
    }

    static {
        musicHistory = new MusicHistory();
        SoundListener = (soundInstance, soundSet, range) -> {
            if (soundInstance.method_4774() != class_3419.field_15253) {
                return;
            }
            class_1111 sound = soundInstance.method_4776();
            class_2960 identifier = sound.method_4767();
            MusicManager.Music music = musicManager.get(identifier);
            if (music != null) {
                MusicToast.show(class_310.method_1551().method_1566(), music);
            } else {
                LOGGER.info("Unknown music {}", (Object)identifier.toString());
                AtomicReference<String> namespace = new AtomicReference<String>(identifier.method_12836());
                FabricLoader.getInstance().getModContainer(namespace.get()).ifPresent(modContainer -> namespace.set(modContainer.getMetadata().getName()));
                String[] idSplit = identifier.method_12832().split("/");
                MusicManager.Music m = new MusicManager.Music(identifier, null, idSplit[idSplit.length - 1], namespace.get(), identifier.toString(), Objects.equals(namespace.get(), "Minecraft") ? AlbumCover.GENERIC : AlbumCover.MODDED, false);
                MusicToast.show(class_310.method_1551().method_1566(), m);
            }
        };
    }
}

