/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import mod.crend.dynamiccrosshair.AutoHudCompat;
import mod.crend.dynamiccrosshair.DynamicCrosshair;
import mod.crend.dynamiccrosshair.component.Crosshair;
import mod.crend.dynamiccrosshair.component.CrosshairHandler;
import mod.crend.dynamiccrosshair.config.CrosshairColor;
import mod.crend.dynamiccrosshair.config.CrosshairModifier;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class CrosshairRenderer {
    public static boolean autoHudCompat = false;

    private static void setColor(CrosshairColor color, boolean forcedCrosshair) {
        int argb = color.getColor();
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        if (autoHudCompat) {
            alpha = forcedCrosshair ? (alpha *= AutoHudCompat.getMinimumAlpha()) : (alpha *= AutoHudCompat.getAlpha());
        }
        RenderSystem.setShaderColor((float)((float)(argb >> 16 & 0xFF) / 255.0f), (float)((float)(argb >> 8 & 0xFF) / 255.0f), (float)((float)(argb & 0xFF) / 255.0f), (float)alpha);
        if (color.forced() || autoHudCompat) {
            RenderSystem.defaultBlendFunc();
        } else {
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }
    }

    public static void preRender() {
        CrosshairRenderer.setColor(DynamicCrosshair.config.getColor(), false);
    }

    public static void fixCenteredCrosshairPre(class_332 context, int x, int y) {
        class_1041 window = class_310.method_1551().method_22683();
        double scale = window.method_4495();
        double i = (double)window.method_4489() / scale;
        double j = (double)window.method_4506() / scale;
        double dx = (i - 15.0) / 2.0 - (double)x;
        double dy = (j - 15.0) / 2.0 - (double)y;
        context.method_51448().method_22903();
        context.method_51448().method_22904(dx, dy, 0.0);
    }

    public static void fixCenteredCrosshairPost(class_332 context) {
        context.method_51448().method_22909();
    }

    public static void render(class_332 context, int x, int y) {
        Crosshair crosshair = CrosshairHandler.getActiveCrosshair();
        if (crosshair.hasStyle()) {
            crosshairStyle = crosshair.getCrosshairStyle();
            CrosshairRenderer.setColor(crosshairStyle.getColor(), false);
            context.method_52706(crosshairStyle.getStyle().getIdentifier(), x, y, 15, 15);
        } else if (CrosshairHandler.forceShowCrosshair) {
            crosshairStyle = Crosshair.REGULAR.getCrosshairStyle();
            CrosshairRenderer.setColor(crosshairStyle.getColor(), true);
            context.method_52706(crosshairStyle.getStyle().getIdentifier(), x, y, 15, 15);
        }
        for (CrosshairModifier modifier : crosshair.getModifiers()) {
            CrosshairRenderer.setColor(modifier.getColor(), false);
            context.method_52706(modifier.getStyle().getIdentifier(), x, y, 15, 15);
        }
    }

    public static void postRender() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
    }
}

