/*
 * Decompiled with CFR 0.152.
 */
package carpet;

import carpet.CarpetExtension;
import carpet.CarpetSettings;
import carpet.commands.CounterCommand;
import carpet.commands.DistanceCommand;
import carpet.commands.DrawCommand;
import carpet.commands.InfoCommand;
import carpet.commands.LogCommand;
import carpet.commands.MobAICommand;
import carpet.commands.PerimeterInfoCommand;
import carpet.commands.PlayerCommand;
import carpet.commands.ProfileCommand;
import carpet.commands.SpawnCommand;
import carpet.commands.TestCommand;
import carpet.helpers.HopperCounter;
import carpet.logging.HUDController;
import carpet.logging.LoggerRegistry;
import carpet.network.ServerNetworkHandler;
import carpet.script.CarpetScriptServer;
import carpet.script.ScriptCommand;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.ParticleParser;
import carpet.settings.SettingsManager;
import carpet.utils.MobAI;
import carpet.utils.SpawnReporter;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_6413;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;

public class CarpetServer {
    public static MinecraftServer minecraft_server;
    public static CarpetScriptServer scriptServer;
    public static SettingsManager settingsManager;
    public static final List<CarpetExtension> extensions;
    private static final Set<CarpetExtension> warnedOutdatedManagerProviders;

    public static void manageExtension(CarpetExtension extension) {
        extensions.add(extension);
        if (StackWalker.getInstance().walk(stream -> stream.skip(1L).anyMatch(el -> el.getClassName() == CarpetServer.class.getName())).booleanValue()) {
            CarpetSettings.LOG.warn("Extension '%s' is registering itself using a mixin into Carpet instead of a regular ModInitializer!\nThis is stupid and will crash the game in future versions!".formatted(extension.getClass().getSimpleName()));
        }
    }

    public static void onGameStarted() {
        settingsManager = new SettingsManager(CarpetSettings.carpetVersion, "carpet", "Carpet Mod");
        settingsManager.parseSettingsClass(CarpetSettings.class);
        extensions.forEach(CarpetExtension::onGameStarted);
        CarpetScriptServer.parseFunctionClasses();
    }

    public static void onServerLoaded(MinecraftServer server) {
        minecraft_server = server;
        SpawnReporter.resetSpawnStats(server, true);
        CarpetServer.forEachManager(sm -> sm.attachServer(server));
        extensions.forEach(e -> e.onServerLoaded(server));
        scriptServer = new CarpetScriptServer(server);
        Carpet.MinecraftServer_addScriptServer(server, scriptServer);
        MobAI.resetTrackers();
        LoggerRegistry.initLoggers();
    }

    public static void onServerLoadedWorlds(MinecraftServer minecraftServer) {
        HopperCounter.resetAll(minecraftServer, true);
        extensions.forEach(e -> e.onServerLoadedWorlds(minecraftServer));
        CarpetServer.forEachManager(carpet.api.settings.SettingsManager::initializeScarpetRules);
        scriptServer.initializeForWorld();
    }

    public static void tick(MinecraftServer server) {
        HUDController.update_hud(server, null);
        if (scriptServer != null) {
            scriptServer.tick();
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        extensions.forEach(e -> e.onTick(server));
    }

    public static void registerCarpetCommands(CommandDispatcher<class_2168> dispatcher, class_2170.class_5364 environment, class_7157 commandBuildContext) {
        if (settingsManager == null) {
            return;
        }
        CarpetServer.forEachManager(sm -> sm.registerCommand(dispatcher, commandBuildContext));
        ProfileCommand.register(dispatcher, commandBuildContext);
        CounterCommand.register(dispatcher, commandBuildContext);
        LogCommand.register(dispatcher, commandBuildContext);
        SpawnCommand.register(dispatcher, commandBuildContext);
        PlayerCommand.register(dispatcher, commandBuildContext);
        InfoCommand.register(dispatcher, commandBuildContext);
        DistanceCommand.register(dispatcher, commandBuildContext);
        PerimeterInfoCommand.register(dispatcher, commandBuildContext);
        DrawCommand.register(dispatcher, commandBuildContext);
        ScriptCommand.register(dispatcher, commandBuildContext);
        MobAICommand.register(dispatcher, commandBuildContext);
        extensions.forEach(e -> e.registerCommands(dispatcher, commandBuildContext));
        if (environment != class_2170.class_5364.field_25420) {
            class_6413.method_37331(dispatcher);
        }
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            TestCommand.register(dispatcher);
        }
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        ServerNetworkHandler.onPlayerJoin(player);
        LoggerRegistry.playerConnected((class_1657)player);
        extensions.forEach(e -> e.onPlayerLoggedIn(player));
        scriptServer.onPlayerJoin(player);
    }

    public static void onPlayerLoggedOut(class_3222 player, class_2561 reason) {
        CarpetScriptServer runningScriptServer;
        ServerNetworkHandler.onPlayerLoggedOut(player);
        LoggerRegistry.playerDisconnected((class_1657)player);
        extensions.forEach(e -> e.onPlayerLoggedOut(player));
        CarpetScriptServer carpetScriptServer = runningScriptServer = player.method_5682() == null ? scriptServer : Vanilla.MinecraftServer_getScriptServer(player.method_5682());
        if (runningScriptServer != null && !runningScriptServer.stopAll) {
            runningScriptServer.onPlayerLoggedOut(player, reason);
        }
    }

    public static void clientPreClosing() {
        if (scriptServer != null) {
            scriptServer.onClose();
        }
        scriptServer = null;
    }

    public static void onServerClosed(MinecraftServer server) {
        if (minecraft_server != null) {
            if (scriptServer != null) {
                scriptServer.onClose();
            }
            if (!Vanilla.MinecraftServer_getScriptServer((MinecraftServer)server).stopAll) {
                Vanilla.MinecraftServer_getScriptServer(server).onClose();
            }
            scriptServer = null;
            ServerNetworkHandler.close();
            LoggerRegistry.stopLoggers();
            HUDController.resetScarpetHUDs();
            ParticleParser.resetCache();
            extensions.forEach(e -> e.onServerClosed(server));
            minecraft_server = null;
        }
    }

    public static void onServerDoneClosing(MinecraftServer server) {
        CarpetServer.forEachManager(carpet.api.settings.SettingsManager::detachServer);
    }

    public static void forEachManager(Consumer<carpet.api.settings.SettingsManager> consumer) {
        consumer.accept(settingsManager);
        for (CarpetExtension e : extensions) {
            carpet.api.settings.SettingsManager manager = e.extensionSettingsManager();
            if (manager == null) continue;
            consumer.accept(manager);
        }
    }

    public static void registerExtensionLoggers() {
        extensions.forEach(CarpetExtension::registerLoggers);
    }

    public static void onReload(MinecraftServer server) {
        scriptServer.reload(server);
        extensions.forEach(e -> e.onReload(server));
    }

    static void warnOutdatedManager(CarpetExtension ext) {
        if (warnedOutdatedManagerProviders.add(ext)) {
            CarpetSettings.LOG.warn("%s is providing a SettingsManager from an outdated method in CarpetExtension!\nThis behaviour will not work in later Carpet versions and the manager won't be registered!".formatted(ext.getClass().getName()));
        }
    }

    static {
        extensions = new ArrayList<CarpetExtension>();
        warnedOutdatedManagerProviders = new HashSet<CarpetExtension>();
    }
}

