/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.amerebagatelle.fabricskyboxes.FabricSkyBoxesClient;
import io.github.amerebagatelle.fabricskyboxes.api.FabricSkyBoxesApi;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.AbstractSkybox;
import io.github.amerebagatelle.fabricskyboxes.skyboxes.SkyboxType;
import io.github.amerebagatelle.fabricskyboxes.util.JsonObjectWrapper;
import io.github.amerebagatelle.fabricskyboxes.util.object.internal.Metadata;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;

public class SkyboxManager
implements FabricSkyBoxesApi,
ClientTickEvents.EndWorldTick {
    private static final SkyboxManager INSTANCE = new SkyboxManager();
    private final Map<class_2960, Skybox> skyboxMap = new Object2ObjectLinkedOpenHashMap();
    private final Map<class_2960, Skybox> permanentSkyboxMap = new Object2ObjectLinkedOpenHashMap();
    private final List<Skybox> activeSkyboxes = new LinkedList<Skybox>();
    private final Predicate<? super Skybox> renderPredicate = skybox -> !this.activeSkyboxes.contains(skybox) && skybox.isActive();
    private Skybox currentSkybox = null;
    private boolean enabled = true;

    public static AbstractSkybox parseSkyboxJson(class_2960 id, JsonObjectWrapper objectWrapper) {
        Object skybox;
        Metadata metadata;
        try {
            metadata = (Metadata)((Pair)Metadata.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)objectWrapper.getFocusedObject()).getOrThrow(false, System.err::println)).getFirst();
        }
        catch (RuntimeException e) {
            FabricSkyBoxesClient.getLogger().warn("Skipping invalid skybox " + id.toString(), (Throwable)e);
            FabricSkyBoxesClient.getLogger().warn(objectWrapper.toString());
            return null;
        }
        SkyboxType type = (SkyboxType)SkyboxType.REGISTRY.method_10223(metadata.getType());
        Preconditions.checkNotNull((Object)type, (Object)("Unknown skybox type: " + metadata.getType().method_12832().replace('_', '-')));
        if (metadata.getSchemaVersion() == 1) {
            Preconditions.checkArgument((boolean)type.isLegacySupported(), (Object)("Unsupported schema version '1' for skybox type " + type.getName()));
            FabricSkyBoxesClient.getLogger().debug("Using legacy deserializer for skybox " + id.toString());
            skybox = type.instantiate();
            type.getDeserializer().getDeserializer().accept(objectWrapper, (AbstractSkybox)skybox);
        } else {
            skybox = (AbstractSkybox)((Pair)type.getCodec(metadata.getSchemaVersion()).decode((DynamicOps)JsonOps.INSTANCE, (Object)objectWrapper.getFocusedObject()).getOrThrow(false, System.err::println)).getFirst();
        }
        return skybox;
    }

    public static SkyboxManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void addSkybox(class_2960 identifier, JsonObject jsonObject) {
        AbstractSkybox skybox = SkyboxManager.parseSkyboxJson(identifier, new JsonObjectWrapper(jsonObject));
        if (skybox != null) {
            this.addSkybox(identifier, skybox);
        }
    }

    @Override
    public void addSkybox(class_2960 identifier, Skybox skybox) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier was null");
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        this.skyboxMap.put(identifier, skybox);
        this.sortSkybox();
    }

    private void sortSkybox() {
        Map newSortedMap = (Map)this.skyboxMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(Skybox::getPriority))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (skybox, skybox2) -> skybox, Object2ObjectLinkedOpenHashMap::new));
        this.skyboxMap.clear();
        this.skyboxMap.putAll(newSortedMap);
    }

    @Override
    public void addPermanentSkybox(class_2960 identifier, Skybox skybox) {
        Preconditions.checkNotNull((Object)identifier, (Object)"Identifier was null");
        Preconditions.checkNotNull((Object)skybox, (Object)"Skybox was null");
        this.permanentSkyboxMap.put(identifier, skybox);
    }

    @Override
    @ApiStatus.Internal
    public void clearSkyboxes() {
        this.skyboxMap.clear();
        this.activeSkyboxes.clear();
    }

    @ApiStatus.Internal
    public void renderSkyboxes(WorldRendererAccess worldRendererAccess, class_4587 matrices, Matrix4f matrix4f, float tickDelta, class_4184 camera, boolean thickFog) {
        this.activeSkyboxes.forEach(skybox -> {
            this.currentSkybox = skybox;
            skybox.render(worldRendererAccess, matrices, matrix4f, tickDelta, camera, thickFog);
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Skybox getCurrentSkybox() {
        return this.currentSkybox;
    }

    @Override
    public int getApiVersion() {
        return 0;
    }

    @Override
    public List<Skybox> getActiveSkyboxes() {
        return this.activeSkyboxes;
    }

    public void onEndTick(class_638 client) {
        StreamSupport.stream(Iterables.concat(this.skyboxMap.values(), this.permanentSkyboxMap.values()).spliterator(), false).forEach(skybox -> skybox.tick(client));
        this.activeSkyboxes.removeIf(skybox -> !skybox.isActive());
        this.skyboxMap.values().stream().filter(this.renderPredicate).forEach(this.activeSkyboxes::add);
        this.permanentSkyboxMap.values().stream().filter(this.renderPredicate).forEach(this.activeSkyboxes::add);
        this.activeSkyboxes.sort(Comparator.comparingInt(Skybox::getPriority));
    }

    public Map<class_2960, Skybox> getSkyboxMap() {
        return this.skyboxMap;
    }
}

