/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication;

import ch.endte.syncmatica.Feature;
import ch.endte.syncmatica.LocalLitematicState;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.CommunicationManager;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.MessageType;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.DownloadExchange;
import ch.endte.syncmatica.communication.exchange.Exchange;
import ch.endte.syncmatica.communication.exchange.ModifyExchangeServer;
import ch.endte.syncmatica.communication.exchange.UploadExchange;
import ch.endte.syncmatica.communication.exchange.VersionHandshakeServer;
import ch.endte.syncmatica.extended_core.PlayerIdentifier;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerCommunicationManager
extends CommunicationManager {
    private final Map<UUID, List<ServerPlacement>> downloadingFile = new HashMap<UUID, List<ServerPlacement>>();
    private final Map<ExchangeTarget, class_3222> playerMap = new HashMap<ExchangeTarget, class_3222>();

    public GameProfile getGameProfile(ExchangeTarget exchangeTarget) {
        return this.playerMap.get(exchangeTarget).method_7334();
    }

    public void sendMessage(ExchangeTarget client, MessageType type, String identifier) {
        if (client.getFeatureSet().hasFeature(Feature.MESSAGE)) {
            class_2540 newPacketBuf = new class_2540(Unpooled.buffer());
            newPacketBuf.method_10814(type.toString());
            newPacketBuf.method_10814(identifier);
            client.sendPacket(PacketType.MESSAGE.identifier, newPacketBuf, this.context);
        } else if (this.playerMap.containsKey(client)) {
            class_3222 player = this.playerMap.get(client);
            player.method_7353(class_2561.method_30163((String)("Syncmatica " + type.toString() + " " + identifier)), false);
        }
    }

    public void onPlayerJoin(ExchangeTarget newPlayer, class_3222 player) {
        VersionHandshakeServer hi = new VersionHandshakeServer(newPlayer, this.context);
        this.playerMap.put(newPlayer, player);
        GameProfile profile = player.method_7334();
        this.context.getPlayerIdentifierProvider().updateName(profile.getId(), profile.getName());
        this.startExchangeUnchecked(hi);
    }

    public void onPlayerLeave(ExchangeTarget oldPlayer) {
        Collection<Exchange> potentialMessageTarget = oldPlayer.getExchanges();
        if (potentialMessageTarget != null) {
            for (Exchange target : potentialMessageTarget) {
                target.close(false);
                this.handleExchange(target);
            }
        }
        this.broadcastTargets.remove(oldPlayer);
        this.playerMap.remove(oldPlayer);
    }

    @Override
    protected void handle(ExchangeTarget source, class_2960 id, class_2540 packetBuf) {
        UUID placementId;
        if (id.equals((Object)PacketType.REQUEST_LITEMATIC.identifier)) {
            UploadExchange upload;
            UUID syncmaticaId = packetBuf.method_10790();
            ServerPlacement placement = this.context.getSyncmaticManager().getPlacement(syncmaticaId);
            if (placement == null) {
                return;
            }
            File toUpload = this.context.getFileStorage().getLocalLitematic(placement);
            try {
                upload = new UploadExchange(placement, toUpload, source, this.context);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            this.startExchange(upload);
            return;
        }
        if (id.equals((Object)PacketType.REGISTER_METADATA.identifier)) {
            ServerPlacement placement = this.receiveMetaData(packetBuf, source);
            if (this.context.getSyncmaticManager().getPlacement(placement.getId()) != null) {
                this.cancelShare(source, placement);
                return;
            }
            GameProfile profile = this.playerMap.get(source).method_7334();
            PlayerIdentifier playerIdentifier = this.context.getPlayerIdentifierProvider().createOrGet(profile);
            if (!placement.getOwner().equals(playerIdentifier)) {
                placement.setOwner(playerIdentifier);
                placement.setLastModifiedBy(playerIdentifier);
            }
            if (!this.context.getFileStorage().getLocalState(placement).isLocalFileReady()) {
                if (this.context.getFileStorage().getLocalState(placement) == LocalLitematicState.DOWNLOADING_LITEMATIC) {
                    this.downloadingFile.computeIfAbsent(placement.getHash(), key -> new ArrayList()).add(placement);
                    return;
                }
                try {
                    this.download(placement, source);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            this.addPlacement(source, placement);
            return;
        }
        if (id.equals((Object)PacketType.REMOVE_SYNCMATIC.identifier)) {
            placementId = packetBuf.method_10790();
            ServerPlacement placement = this.context.getSyncmaticManager().getPlacement(placementId);
            if (placement != null) {
                Exchange modifier = this.getModifier(placement);
                if (modifier != null) {
                    modifier.close(true);
                    this.notifyClose(modifier);
                }
                this.context.getSyncmaticManager().removePlacement(placement);
                for (ExchangeTarget client : this.broadcastTargets) {
                    class_2540 newPacketBuf = new class_2540(Unpooled.buffer());
                    newPacketBuf.method_10797(placement.getId());
                    client.sendPacket(PacketType.REMOVE_SYNCMATIC.identifier, newPacketBuf, this.context);
                }
            }
        }
        if (id.equals((Object)PacketType.MODIFY_REQUEST.identifier)) {
            placementId = packetBuf.method_10790();
            ModifyExchangeServer modifier = new ModifyExchangeServer(placementId, source, this.context);
            this.startExchange(modifier);
        }
    }

    @Override
    protected void handleExchange(Exchange exchange) {
        if (exchange instanceof DownloadExchange) {
            ServerPlacement p = ((DownloadExchange)exchange).getPlacement();
            if (exchange.isSuccessful()) {
                this.addPlacement(exchange.getPartner(), p);
                if (this.downloadingFile.containsKey(p.getHash())) {
                    for (ServerPlacement placement : this.downloadingFile.get(p.getHash())) {
                        this.addPlacement(exchange.getPartner(), placement);
                    }
                }
            } else {
                this.cancelShare(exchange.getPartner(), p);
                if (this.downloadingFile.containsKey(p.getHash())) {
                    for (ServerPlacement placement : this.downloadingFile.get(p.getHash())) {
                        this.cancelShare(exchange.getPartner(), placement);
                    }
                }
            }
            this.downloadingFile.remove(p.getHash());
            return;
        }
        if (exchange instanceof VersionHandshakeServer && exchange.isSuccessful()) {
            this.broadcastTargets.add(exchange.getPartner());
        }
        if (exchange instanceof ModifyExchangeServer && exchange.isSuccessful()) {
            ServerPlacement placement = ((ModifyExchangeServer)exchange).getPlacement();
            for (ExchangeTarget client : this.broadcastTargets) {
                class_2540 buf;
                if (client.getFeatureSet().hasFeature(Feature.MODIFY)) {
                    buf = new class_2540(Unpooled.buffer());
                    buf.method_10797(placement.getId());
                    this.putPositionData(placement, buf, client);
                    if (client.getFeatureSet().hasFeature(Feature.CORE_EX)) {
                        buf.method_10797(placement.getLastModifiedBy().uuid);
                        buf.method_10814(placement.getLastModifiedBy().getName());
                    }
                    client.sendPacket(PacketType.MODIFY.identifier, buf, this.context);
                    continue;
                }
                buf = new class_2540(Unpooled.buffer());
                buf.method_10797(placement.getId());
                client.sendPacket(PacketType.REMOVE_SYNCMATIC.identifier, buf, this.context);
                class_2540 buf2 = new class_2540(Unpooled.buffer());
                this.putMetaData(placement, buf2, client);
                client.sendPacket(PacketType.REGISTER_METADATA.identifier, buf2, this.context);
            }
        }
    }

    private void addPlacement(ExchangeTarget t, ServerPlacement placement) {
        if (this.context.getSyncmaticManager().getPlacement(placement.getId()) != null) {
            this.cancelShare(t, placement);
            return;
        }
        this.context.getSyncmaticManager().addPlacement(placement);
        for (ExchangeTarget target : this.broadcastTargets) {
            this.sendMetaData(placement, target);
        }
    }

    private void cancelShare(ExchangeTarget source, ServerPlacement placement) {
        class_2540 packetByteBuf = new class_2540(Unpooled.buffer());
        packetByteBuf.method_10797(placement.getId());
        source.sendPacket(PacketType.CANCEL_SHARE.identifier, packetByteBuf, this.context);
    }
}

