/*
 * Decompiled with CFR 0.152.
 */
package ch.endte.syncmatica.communication.exchange;

import ch.endte.syncmatica.Context;
import ch.endte.syncmatica.ServerPlacement;
import ch.endte.syncmatica.communication.ExchangeTarget;
import ch.endte.syncmatica.communication.FeatureSet;
import ch.endte.syncmatica.communication.PacketType;
import ch.endte.syncmatica.communication.exchange.FeatureExchange;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;

public class VersionHandshakeServer
extends FeatureExchange {
    private String partnerVersion;

    public VersionHandshakeServer(ExchangeTarget partner, Context con) {
        super(partner, con);
    }

    @Override
    public boolean checkPacket(class_2960 id, class_2540 packetBuf) {
        return id.equals((Object)PacketType.REGISTER_VERSION.identifier) || super.checkPacket(id, packetBuf);
    }

    @Override
    public void handle(class_2960 id, class_2540 packetBuf) {
        if (id.equals((Object)PacketType.REGISTER_VERSION.identifier)) {
            this.partnerVersion = packetBuf.method_10800(Short.MAX_VALUE);
            if (!this.getContext().checkPartnerVersion(this.partnerVersion)) {
                LogManager.getLogger(VersionHandshakeServer.class).info("Denying syncmatica join due to outdated client with local version {} and client version {}", (Object)"0.3.11", (Object)this.partnerVersion);
                this.close(false);
                return;
            }
            FeatureSet fs = FeatureSet.fromVersionString(this.partnerVersion);
            if (fs == null) {
                this.requestFeatureSet();
            } else {
                this.getPartner().setFeatureSet(fs);
                this.onFeatureSetReceive();
            }
        } else {
            super.handle(id, packetBuf);
        }
    }

    @Override
    public void onFeatureSetReceive() {
        LogManager.getLogger(VersionHandshakeServer.class).info("Syncmatica client joining with local version {} and client version {}", (Object)"0.3.11", (Object)this.partnerVersion);
        class_2540 newBuf = new class_2540(Unpooled.buffer());
        Collection<ServerPlacement> l = this.getContext().getSyncmaticManager().getAll();
        newBuf.method_53002(l.size());
        for (ServerPlacement p : l) {
            this.getManager().putMetaData(p, newBuf, this.getPartner());
        }
        this.getPartner().sendPacket(PacketType.CONFIRM_USER.identifier, newBuf, this.getContext());
        this.succeed();
    }

    @Override
    public void init() {
        class_2540 newBuf = new class_2540(Unpooled.buffer());
        newBuf.method_10814("0.3.11");
        this.getPartner().sendPacket(PacketType.REGISTER_VERSION.identifier, newBuf, this.getContext());
    }
}

