/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_5348;

public class MessageRenderer {
    public static final int BASE_COLOR = 0xFFFFFF;
    private final class_437 screen;
    private Optional<Message> shownMessage = Optional.empty();

    public MessageRenderer(class_437 screen) {
        this.screen = screen;
    }

    public void addMessage(class_2561 text) {
        this.shownMessage = Optional.of(new Message(text));
    }

    public void addMessage(class_2561 text, int color) {
        this.shownMessage = Optional.of(new Message(text, color));
    }

    public void tick() {
        if (this.shownMessage.isEmpty()) {
            return;
        }
        Message current = this.shownMessage.get();
        current.tick();
        if (current.isExpired()) {
            this.shownMessage = Optional.empty();
        }
    }

    public void render(class_332 drawContext) {
        this.shownMessage.ifPresent(message -> message.render(this.screen, drawContext));
    }

    private static class Message {
        private static final int SHOW_DURATION = 40;
        private final class_2561 text;
        private final int baseTextColor;
        private int timeRemaining;

        public Message(class_2561 text) {
            this(text, 0xFFFFFF);
        }

        public Message(class_2561 text, int baseTextColor) {
            this.text = text;
            this.baseTextColor = baseTextColor;
            this.timeRemaining = 40;
        }

        public void tick() {
            --this.timeRemaining;
        }

        public void render(class_437 screen, class_332 context) {
            class_310 client = class_310.method_1551();
            class_327 textRenderer = client.field_1772;
            int width = textRenderer.method_27525((class_5348)this.text);
            int x = (screen.field_22789 - width) / 2;
            int n = screen.field_22790 - 20 - 1 - 6;
            Objects.requireNonNull(textRenderer);
            int y = n - 9;
            float opacity = class_3532.method_15363((float)((float)this.timeRemaining / 10.0f), (float)0.0f, (float)1.0f);
            int backgroundAlpha = client.field_1690.method_19344(0) >> 24 & 0xFF;
            int backgroundColor = (int)(opacity * (float)backgroundAlpha) << 24 & 0xFF000000;
            int textColor = this.baseTextColor + ((int)(opacity * 255.0f) << 24);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Objects.requireNonNull(textRenderer);
            context.method_25294(x - 2, y - 2, x + width + 2, y + 9 + 2, backgroundColor);
            context.method_27535(textRenderer, this.text, x, y, textColor);
            RenderSystem.disableBlend();
        }

        public boolean isExpired() {
            return this.timeRemaining <= 0;
        }
    }

    @FunctionalInterface
    public static interface HasMessageRenderer {
        public MessageRenderer getMessageRenderer();
    }
}

