/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.packet.c2s.SetFlagPacket;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_5348;
import net.minecraft.class_6382;

public class FlagToggleWidget
extends class_4264 {
    public static final int WIDGET_WIDTH = 16;
    public static final int WIDGET_HEIGHT = 12;
    private static final int BAR_WIDTH = 10;
    private static final class_2960 TEXTURE = new class_2960("widget/slider");
    private static final class_2960 HANDLE_TEXTURE = new class_2960("widget/slider_handle");
    private static final class_2960 HANDLE_HIGHLIGHTED_TEXTURE = new class_2960("widget/slider_handle_highlighted");
    private final ArmorStandFlag flag;
    private final boolean inverted;
    private final LabelWidget flagLabel;
    private final LabelWidget valueLabel;
    private final int widgetX;
    private final int widgetY;
    private boolean currentValue = false;

    public FlagToggleWidget(class_327 textRenderer, ArmorStandFlag flag, boolean initialValue, int x, int y) {
        super(x, y, 100, 12, flag.getDisplayName());
        this.flag = flag;
        this.inverted = flag.invertControl();
        int valueLabelWidth = 4 + Math.max(textRenderer.method_27525((class_5348)class_2561.method_43471((String)"armorstands.flagToggle.on")), textRenderer.method_27525((class_5348)class_2561.method_43471((String)"armorstands.flagToggle.off")));
        this.flagLabel = LabelWidget.builder(flag.getDisplayName(), x - 16 - 2 - valueLabelWidth - 2, y + this.field_22759 / 2).justifiedRight().alignedMiddle().shiftForPadding().build();
        this.valueLabel = LabelWidget.builder((class_2561)class_2561.method_43471((String)("armorstands.flagToggle." + (initialValue ^ this.inverted ? "on" : "off"))), x - valueLabelWidth / 2, y + this.field_22759 / 2).justifiedCenter().alignedMiddle().shiftForPadding().build();
        this.currentValue = initialValue;
        this.widgetX = x - 16 - 2 - valueLabelWidth;
        this.widgetY = y + (this.field_22759 - 12) / 2;
    }

    public void method_25306() {
        SetFlagPacket.sendToServer(this.flag, !this.currentValue);
    }

    public void method_47399(class_6382 builder) {
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && this.isWithinBounds(mouseX, mouseY);
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return this.method_25405(mouseX, mouseY);
    }

    public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.field_22762 = this.isWithinBounds(mouseX, mouseY);
        this.renderControl(drawContext, mouseX, mouseY, delta);
        this.flagLabel.method_25394(drawContext, mouseX, mouseY, delta);
        this.valueLabel.method_25394(drawContext, mouseX, mouseY, delta);
    }

    public void setValue(boolean newValue) {
        this.currentValue = newValue;
        this.valueLabel.setText((class_2561)class_2561.method_43471((String)("armorstands.flagToggle." + (newValue ^ this.inverted ? "on" : "off"))));
    }

    private void renderControl(class_332 drawContext, int mouseX, int mouseY, float delta) {
        int offset = this.currentValue ^ this.inverted ? 6 : 0;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        drawContext.method_52706(TEXTURE, this.widgetX, this.widgetY, 16, 12);
        drawContext.method_52706(this.getHandleTexture(), this.widgetX + offset, this.widgetY, 10, 12);
    }

    private boolean isWithinBounds(double mouseX, double mouseY) {
        return mouseX >= (double)this.flagLabel.getLeft() && mouseX < (double)this.valueLabel.getRight() && mouseY >= (double)this.flagLabel.getTop() && mouseY < (double)this.flagLabel.getBottom();
    }

    private class_2960 getTexture() {
        return TEXTURE;
    }

    private class_2960 getHandleTexture() {
        if (this.method_25370() || this.field_22762) {
            return HANDLE_HIGHLIGHTED_TEXTURE;
        }
        return HANDLE_TEXTURE;
    }
}

