/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.network.packet.s2c;

import io.netty.buffer.ByteBuf;
import me.roundaround.armorstands.client.gui.MessageRenderer;
import me.roundaround.armorstands.network.packet.NetworkPackets;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;

public class MessagePacket {
    private final boolean translatable;
    private final String message;
    private final boolean styled;
    private final int color;

    public MessagePacket(class_2540 buf) {
        this.translatable = buf.readBoolean();
        this.message = buf.method_19772();
        this.styled = buf.readBoolean();
        this.color = this.styled ? buf.readInt() : -1;
    }

    public MessagePacket(String message) {
        this(true, message);
    }

    public MessagePacket(String message, int color) {
        this(true, message, color);
    }

    public MessagePacket(boolean translatable, String message) {
        this(translatable, message, false, -1);
    }

    public MessagePacket(boolean translatable, String message, int color) {
        this(translatable, message, true, color);
    }

    public MessagePacket(boolean translatable, String message, boolean styled, int color) {
        this.translatable = translatable;
        this.message = message;
        this.styled = styled;
        this.color = color;
    }

    private class_2540 toPacket() {
        class_2540 buf = new class_2540((ByteBuf)PacketByteBufs.create());
        buf.method_52964(this.translatable);
        buf.method_10814(this.message);
        buf.method_52964(this.styled);
        if (this.styled) {
            buf.method_53002(this.color);
        }
        return buf;
    }

    private void handleOnClient(class_310 client, class_634 handler, PacketSender responseSender) {
        if (!(client.field_1755 instanceof MessageRenderer.HasMessageRenderer)) {
            return;
        }
        MessageRenderer messageRenderer = ((MessageRenderer.HasMessageRenderer)client.field_1755).getMessageRenderer();
        messageRenderer.addMessage((class_2561)(this.translatable ? class_2561.method_43471((String)this.message) : class_2561.method_43470((String)this.message)), this.styled ? this.color : 0xFFFFFF);
    }

    public static void sendToClient(class_3222 player, String message) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPackets.MESSAGE_PACKET, (class_2540)new MessagePacket(message).toPacket());
    }

    public static void sendToClient(class_3222 player, String message, int color) {
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPackets.MESSAGE_PACKET, (class_2540)new MessagePacket(message, color).toPacket());
    }

    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)NetworkPackets.MESSAGE_PACKET, (client, handler, buf, responseSender) -> {
            MessagePacket packet = new MessagePacket(buf);
            client.execute(() -> packet.handleOnClient(client, handler, responseSender));
        });
    }
}

