/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util;

import java.util.HashMap;
import java.util.Stack;
import java.util.UUID;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.EulerAngleParameter;
import me.roundaround.armorstands.network.PosePart;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.actions.AdjustPoseAction;
import me.roundaround.armorstands.util.actions.ArmorStandAction;
import me.roundaround.armorstands.util.actions.FlagAction;
import me.roundaround.armorstands.util.actions.MoveAction;
import me.roundaround.armorstands.util.actions.PoseAction;
import me.roundaround.armorstands.util.actions.RotateAction;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class ArmorStandEditor {
    private static HashMap<UUID, class_3545<UUID, ArmorStandEditor>> editors = new HashMap();
    private final class_3222 player;
    private final class_1531 armorStand;
    private final SizeLimitedStack<ArmorStandAction> actions = new SizeLimitedStack(30);
    private final SizeLimitedStack<ArmorStandAction> undos = new SizeLimitedStack(30);

    public static ArmorStandEditor get(class_3222 player, class_1531 armorStand) {
        class_3545<UUID, ArmorStandEditor> pair;
        UUID uuid = player.method_5667();
        if (!editors.containsKey(uuid)) {
            editors.put(uuid, (class_3545<UUID, ArmorStandEditor>)new class_3545((Object)armorStand.method_5667(), (Object)new ArmorStandEditor(player, armorStand)));
        }
        if (!((UUID)(pair = editors.get(uuid)).method_15442()).equals(armorStand.method_5667())) {
            editors.put(uuid, (class_3545<UUID, ArmorStandEditor>)new class_3545((Object)armorStand.method_5667(), (Object)new ArmorStandEditor(player, armorStand)));
        }
        return (ArmorStandEditor)editors.get(uuid).method_15441();
    }

    public static void remove(class_3222 player) {
        editors.remove(player.method_5667());
    }

    private ArmorStandEditor(class_3222 player, class_1531 armorStand) {
        this.player = player;
        this.armorStand = armorStand;
    }

    public class_1531 getArmorStand() {
        return this.armorStand;
    }

    public void applyAction(ArmorStandAction action) {
        if (action == null) {
            return;
        }
        action.apply((class_1657)this.player, this.armorStand);
        this.actions.push(action);
        this.undos.clear();
    }

    public boolean undo() {
        if (this.actions.isEmpty()) {
            return false;
        }
        ArmorStandAction action = (ArmorStandAction)this.actions.pop();
        if (action == null) {
            return false;
        }
        action.undo((class_1657)this.player, this.armorStand);
        this.undos.push(action);
        return true;
    }

    public boolean redo() {
        if (this.undos.isEmpty()) {
            return false;
        }
        ArmorStandAction action = (ArmorStandAction)this.undos.pop();
        if (action == null) {
            return false;
        }
        action.apply((class_1657)this.player, this.armorStand);
        this.actions.push(action);
        return true;
    }

    public void movePos(class_2350 direction, int pixels) {
        this.movePos(new class_243(direction.method_23955()).method_1021((double)pixels * 0.0625), true);
    }

    public void movePos(class_243 amount) {
        this.movePos(amount, false);
    }

    public void movePos(class_243 amount, boolean roundToPixel) {
        this.applyAction(MoveAction.relative(amount, roundToPixel));
    }

    public void setPos(double x, double y, double z) {
        this.setPos(new class_243(x, y, z));
    }

    public void setPos(class_243 position) {
        this.applyAction(MoveAction.absolute(position));
    }

    public void rotate(float rotation) {
        this.applyAction(RotateAction.relative(rotation));
    }

    public void setRotation(float rotation) {
        this.applyAction(RotateAction.absolute(rotation));
    }

    public void toggleFlag(ArmorStandFlag flag) {
        this.applyAction(FlagAction.toggle(flag));
    }

    public void setFlag(ArmorStandFlag flag, boolean value) {
        this.applyAction(FlagAction.set(flag, value));
    }

    public void setPose(Pose pose) {
        this.applyAction(PoseAction.fromPose(pose));
    }

    public void setPose(class_2379 head, class_2379 body, class_2379 rightArm, class_2379 leftArm, class_2379 rightLeg, class_2379 leftLeg) {
        this.setPose(new Pose(head, body, rightArm, leftArm, rightLeg, leftLeg));
    }

    public void adjustPose(PosePart part, EulerAngleParameter parameter, float amount) {
        this.applyAction(AdjustPoseAction.absolute(part, parameter, amount));
    }

    private static class SizeLimitedStack<T>
    extends Stack<T> {
        private final int limit;

        public SizeLimitedStack(int limit) {
            this.limit = limit;
        }

        @Override
        public T push(T obj) {
            while (this.size() >= this.limit) {
                this.remove(0);
            }
            return super.push(obj);
        }
    }
}

