/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import me.roundaround.armorstands.network.packet.s2c.MessagePacket;
import me.roundaround.armorstands.util.ArmorStandApplyable;
import me.roundaround.armorstands.util.ArmorStandEditor;
import me.roundaround.armorstands.util.FlagSnapshot;
import me.roundaround.armorstands.util.Pose;
import me.roundaround.armorstands.util.actions.ClipboardPasteAction;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class Clipboard {
    private static final HashMap<UUID, Entry> entries = new HashMap();

    public static void copy(class_3222 player, class_1531 armorStand) {
        entries.put(player.method_5667(), Entry.everything(armorStand));
        MessagePacket.sendToClient(player, "armorstands.message.copy");
    }

    public static boolean paste(class_3222 player, ArmorStandEditor editor) {
        if (!entries.containsKey(player.method_5667())) {
            return false;
        }
        editor.applyAction(ClipboardPasteAction.create(entries.get(player.method_5667())));
        MessagePacket.sendToClient(player, "armorstands.message.paste");
        return true;
    }

    public static void remove(class_3222 player) {
        entries.remove(player.method_5667());
    }

    public static class Entry
    implements ArmorStandApplyable {
        private Optional<Pose> pose;
        private Optional<FlagSnapshot> flags;

        private Entry(Optional<Pose> pose, Optional<FlagSnapshot> flags) {
            this.pose = pose;
            this.flags = flags;
        }

        public static Entry everything(class_1531 armorStand) {
            return new Entry(Optional.of(new Pose(armorStand)), Optional.of(FlagSnapshot.all(armorStand)));
        }

        public static Entry poseOnly(class_1531 armorStand) {
            return new Entry(Optional.of(new Pose(armorStand)), Optional.empty());
        }

        public static Entry flagsOnly(class_1531 armorStand) {
            return new Entry(Optional.empty(), Optional.of(FlagSnapshot.all(armorStand)));
        }

        @Override
        public void apply(class_1657 player, class_1531 armorStand) {
            this.pose.ifPresent(pose -> pose.apply(player, armorStand));
            this.flags.ifPresent(flags -> flags.apply(player, armorStand));
        }
    }
}

