/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.util.ArmorStandApplyable;
import net.minecraft.class_1531;
import net.minecraft.class_1657;

public class FlagSnapshot
implements ArmorStandApplyable {
    private HashMap<ArmorStandFlag, Boolean> values = new HashMap();

    private FlagSnapshot(class_1531 armorStand, Predicate<ArmorStandFlag> predicate) {
        Arrays.stream(ArmorStandFlag.values()).filter(predicate).filter(flag -> flag != ArmorStandFlag.UNKNOWN).forEach(flag -> this.values.put((ArmorStandFlag)((Object)flag), flag.getValue(armorStand)));
    }

    public static FlagSnapshot all(class_1531 armorStand) {
        return new FlagSnapshot(armorStand, flag -> true);
    }

    public static FlagSnapshot none(class_1531 armorStand) {
        return new FlagSnapshot(armorStand, flag -> false);
    }

    public static FlagSnapshot some(class_1531 armorStand, Predicate<ArmorStandFlag> predicate) {
        return new FlagSnapshot(armorStand, predicate);
    }

    public static FlagSnapshot of(class_1531 armorStand, ArmorStandFlag ... flags) {
        return new FlagSnapshot(armorStand, flag -> List.of(flags).contains(flag));
    }

    @Override
    public void apply(class_1657 player, class_1531 armorStand) {
        this.values.entrySet().forEach(entry -> ((ArmorStandFlag)((Object)((Object)entry.getKey()))).setValue(armorStand, (Boolean)entry.getValue()));
    }
}

