/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames;

import com.HiWord9.RPRenames.util.config.ConfigManager;
import com.HiWord9.RPRenames.util.config.Rename;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2287;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import net.minecraft.class_7923;

public class RPRenamesCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 commandRegistryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"rprenames").then(ClientCommandManager.literal((String)"info").executes(context -> RPRenamesCommand.info((FabricClientCommandSource)context.getSource())))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(context -> RPRenamesCommand.list((FabricClientCommandSource)context.getSource()))).then(ClientCommandManager.argument((String)"item", (ArgumentType)class_2287.method_9776((class_7157)commandRegistryAccess)).executes(context -> RPRenamesCommand.list((FabricClientCommandSource)context.getSource(), class_2287.method_9777((CommandContext)context, (String)"item").method_9785()))))).then(ClientCommandManager.literal((String)"solveRegex").then(ClientCommandManager.argument((String)"regex", (ArgumentType)StringArgumentType.greedyString()).executes(context -> RPRenamesCommand.solveRegex((FabricClientCommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"regex"))))));
    }

    public static int info(FabricClientCommandSource source) {
        class_1799 itemStack = source.getPlayer().method_5998(class_1268.field_5808);
        if (itemStack.method_7960()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)"Hold Renamed Item to view its Rename Properties!").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10978(Boolean.valueOf(true))));
        }
        Rename matchRename = null;
        String itemId = ConfigManager.getIdAndPath(itemStack.method_7909());
        ArrayList<Rename> renames = ConfigManager.getRenames(itemId);
        if (!renames.isEmpty()) {
            matchRename = RPRenamesCommand.getMatch(renames, itemStack.method_7964().getString(), itemStack.method_7947(), itemStack.method_7919(), class_1890.method_22445((class_2499)itemStack.method_7921()), itemId);
        }
        if (matchRename == null) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)"No Renames were found").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
            return 1;
        }
        source.sendFeedback((class_2561)class_2561.method_30163((String)"Found following Rename Properties:").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1054)));
        Properties properties = matchRename.getProperties();
        if (properties != null) {
            RPRenamesCommand.printProperties(properties, source);
        }
        if (matchRename.getPackName() != null && matchRename.getPath() != null) {
            RPRenamesCommand.printPath(matchRename.getPath(), matchRename.getPackName(), source);
        }
        if (matchRename.isCEM()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)"CEM Properties:").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1076)));
            RPRenamesCommand.printProperties(matchRename.getMob().properties(), source);
            if (matchRename.getPackName() != null && matchRename.getMob().path() != null) {
                RPRenamesCommand.printPath(matchRename.getMob().path(), matchRename.getPackName(), source);
            }
        }
        if (!(matchRename.getPath() != null || matchRename.isCEM() && matchRename.getMob().path() != null)) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)"Couldn't get Path to Properties File for this Rename").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
            if (matchRename.getPackName() == null) {
                source.sendFeedback((class_2561)class_2561.method_30163((String)"Couldn't get Pack Name for this Rename").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061)));
            } else {
                source.sendFeedback((class_2561)class_2561.method_30163((String)"Pack Name").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)" = ").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)matchRename.getPackName()).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1078))));
            }
        }
        return 1;
    }

    public static int list(FabricClientCommandSource source) {
        return RPRenamesCommand.list(source, source.getPlayer().method_5998(class_1268.field_5808).method_7909());
    }

    public static int list(FabricClientCommandSource source, class_1792 item) {
        ArrayList<Rename> renames = ConfigManager.getRenames(ConfigManager.getIdAndPath(item));
        if (!renames.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)"Found following Renames for ").method_27661().method_10852((class_2561)class_2561.method_43471((String)item.method_7876())).method_10852(class_2561.method_30163((String)":")));
            RPRenamesCommand.printRenameList(renames, item, source);
        } else {
            source.sendFeedback((class_2561)class_2561.method_30163((String)"No Renames for ").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061)).method_10852((class_2561)class_2561.method_43471((String)item.method_7876())).method_10852((class_2561)class_2561.method_30163((String)" were found").method_27661()));
        }
        return 1;
    }

    private static int solveRegex(FabricClientCommandSource source, String regex) {
        String result = ConfigManager.solveRegex(ConfigManager.parseEscapes(regex));
        Pattern pattern = Pattern.compile(regex);
        if (pattern.matcher(result).matches()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)result).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1076).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)regex))).method_10958(new class_2558(class_2558.class_2559.field_21462, result))));
        } else {
            source.sendError((class_2561)class_2561.method_30163((String)"Error occurred on getting string matching regex").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)regex).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1061))))));
        }
        return 1;
    }

    private static Rename getMatch(ArrayList<Rename> renames, String name, int stackSize, int damage, Map<class_1887, Integer> enchantments, String damagedItem) {
        for (Rename r : renames) {
            boolean damageValid;
            boolean stackSizeValid;
            boolean nameValid;
            String nbtName = r.getOriginalNbtDisplayName();
            boolean caseInsensitive = false;
            if (nbtName.startsWith("iregex:") || nbtName.startsWith("ipattern:")) {
                nbtName = nbtName.substring(1);
                caseInsensitive = true;
            }
            if (nbtName.startsWith("regex:") || nbtName.startsWith("pattern:")) {
                if (nbtName.startsWith("regex:")) {
                    nbtName = nbtName.substring(6);
                } else if (nbtName.startsWith("pattern:")) {
                    nbtName = nbtName.substring(8);
                    nbtName = nbtName.replace("*", ".*").replace("?", ".+");
                }
                nbtName = ConfigManager.parseEscapes(nbtName);
                Pattern pattern = Pattern.compile(caseInsensitive ? nbtName.toUpperCase(Locale.ROOT) : nbtName);
                nameValid = pattern.matcher(caseInsensitive ? name.toUpperCase(Locale.ROOT) : name).matches();
            } else {
                nameValid = name.equals(r.getName());
            }
            if (!nameValid || !(stackSizeValid = Rename.isInBounds(stackSize, r.getOriginalStackSize())) || !(damageValid = Rename.isInBounds(damage, r.getOriginalDamage(), damagedItem))) continue;
            boolean enchantmentValid = false;
            boolean enchantmentLevelValid = false;
            String enchantName = r.getEnchantment();
            if (enchantName != null) {
                for (Map.Entry<class_1887, Integer> entry : enchantments.entrySet()) {
                    class_2960 identifier;
                    class_1887 enchantment = entry.getKey();
                    if (!enchantName.contains(":")) {
                        enchantName = new class_2960(enchantName).toString();
                    }
                    if ((identifier = class_7923.field_41176.method_10221((Object)enchantment)) == null || !identifier.toString().equals(enchantName)) continue;
                    enchantmentValid = true;
                    if (!Rename.isInBounds(entry.getValue(), r.getOriginalEnchantmentLevel())) continue;
                    enchantmentLevelValid = true;
                    break;
                }
            } else {
                enchantmentValid = true;
                enchantmentLevelValid = true;
            }
            if (!enchantmentValid || !enchantmentLevelValid) continue;
            return r;
        }
        return null;
    }

    private static void printRenameList(ArrayList<Rename> renames, class_1792 item, FabricClientCommandSource source) {
        for (Rename r : renames) {
            class_1799 itemStack = new class_1799((class_1935)item);
            itemStack.method_7977(class_2561.method_30163((String)r.getName()));
            itemStack.method_7939(r.getStackSize().intValue());
            if (r.getDamage() != null && r.getDamage().damage != 0) {
                itemStack.method_7974(r.getDamage().getParsedDamage(item));
            }
            if (r.getEnchantment() != null) {
                itemStack.method_7948();
                assert (itemStack.method_7969() != null);
                if (!itemStack.method_7969().method_10573("Enchantments", 9)) {
                    itemStack.method_7969().method_10566("Enchantments", (class_2520)new class_2499());
                }
                class_2499 nbtList = itemStack.method_7969().method_10554("Enchantments", 10);
                nbtList.add((Object)class_1890.method_37426((class_2960)new class_2960(r.getEnchantment()), (int)r.getEnchantmentLevel()));
            }
            assert (itemStack.method_7969() != null);
            Object nbt = itemStack.method_7969().toString();
            if (((String)nbt).contains("Damage:0")) {
                if (((String)(nbt = ((String)nbt).replace("Damage:0", ""))).startsWith("{,")) {
                    nbt = "{" + ((String)nbt).substring(2);
                } else if (((String)nbt).endsWith(",}")) {
                    nbt = ((String)nbt).substring(0, ((String)nbt).length() - 2) + "}";
                }
            }
            String giveCommand = "/give @s " + ConfigManager.getIdAndPath(itemStack.method_7909()) + (String)nbt + (String)(r.getStackSize() == 1 ? "" : " " + r.getStackSize());
            class_2558 runGive = new class_2558(class_2558.class_2559.field_11750, giveCommand);
            source.sendFeedback((class_2561)class_2561.method_30163((String)"[/give]").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10958(runGive).method_10975(giveCommand).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Run /give Command")))).method_10852((class_2561)itemStack.method_7954().method_27661().method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_21462, r.getName())))));
        }
    }

    private static void printProperties(Properties properties, FabricClientCommandSource source) {
        for (String s : properties.stringPropertyNames()) {
            source.sendFeedback((class_2561)class_2561.method_30163((String)s).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)properties.getProperty(s)).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1060))));
        }
    }

    private static void printPath(String path, String packName, FabricClientCommandSource source) {
        String dirPath = path.substring(0, path.lastIndexOf("/"));
        source.sendFeedback((class_2561)class_2561.method_30163((String)"Located in: ").method_27661().method_10852((class_2561)class_2561.method_30163((String)path).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1054).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11746, (String)(packName.equals("server") ? "server-resource-packs/" : "resourcepacks/" + (packName.endsWith(".zip") ? packName : dirPath)))))));
    }
}

