/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftcapes.player;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraftcapes.MinecraftCapes;
import net.minecraftcapes.helpers.MinecraftApi;
import net.minecraftcapes.player.PlayerHandler;

public class DownloadManager {
    public static void prepareDownload(class_1657 player, boolean doRefresh) {
        DownloadManager.prepareDownload(player.method_5667(), player.method_7334().getName(), doRefresh);
    }

    public static void prepareDownload(class_640 playerInfo, boolean doRefresh) {
        DownloadManager.prepareDownload(playerInfo.method_2966().getId(), playerInfo.method_2966().getName(), doRefresh);
    }

    private static void prepareDownload(UUID playerUUID, String playerName, boolean doRefresh) {
        class_746 localPlayer = class_310.method_1551().field_1724;
        if (playerUUID.version() != 4 && localPlayer != null && !localPlayer.method_5667().equals(playerUUID)) {
            return;
        }
        PlayerHandler playerHandler = PlayerHandler.get(playerUUID);
        if (playerUUID.version() != 4 && !playerHandler.getHasInfo().booleanValue() && !doRefresh) {
            playerHandler.setHasInfo(true);
            Thread playerDownload = new Thread(() -> {
                UUID uuid = MinecraftApi.getUUID(playerName);
                if (uuid == null) {
                    return;
                }
                playerHandler.setPlayerUUID(uuid);
                DownloadManager.downloadProfile(playerHandler);
            });
            playerDownload.setDaemon(true);
            playerDownload.start();
        } else {
            if (playerHandler.getHasInfo().booleanValue() && !doRefresh) {
                return;
            }
            DownloadManager.downloadProfile(playerHandler);
        }
    }

    private static void downloadProfile(PlayerHandler playerHandler) {
        Thread playerDownload = new Thread(() -> {
            playerHandler.setHasInfo(true);
            try {
                MinecraftCapes.getLogger().debug("Getting profile for {}", (Object)playerHandler.getPlayerUUID());
                URL url = new URL("https://api.minecraftcapes.net/profile/" + playerHandler.getPlayerUUID().toString().replace("-", ""));
                HttpURLConnection httpurlconnection = (HttpURLConnection)url.openConnection(class_310.method_1551().method_1487());
                httpurlconnection.setDoInput(true);
                httpurlconnection.setDoOutput(false);
                httpurlconnection.connect();
                if (httpurlconnection.getResponseCode() / 100 == 2) {
                    InputStreamReader reader = new InputStreamReader(httpurlconnection.getInputStream(), StandardCharsets.UTF_8);
                    DownloadManager.readProfile(playerHandler, reader);
                    ((Reader)reader).close();
                } else {
                    MinecraftCapes.getLogger().warn("minecraftcapes.net returned a {}", (Object)httpurlconnection.getResponseCode());
                }
            }
            catch (IOException e) {
                MinecraftCapes.getLogger().warn("No connection to minecraftcapes.net detected");
            }
        });
        playerDownload.setDaemon(true);
        playerDownload.start();
    }

    private static void readProfile(PlayerHandler playerHandler, Reader reader) {
        ProfileResult profileResult = (ProfileResult)new Gson().fromJson(reader, ProfileResult.class);
        playerHandler.setHasCapeGlint(profileResult.capeGlint);
        playerHandler.setUpsideDown(profileResult.upsideDown);
        if (profileResult.textures.get("cape") != null) {
            playerHandler.applyCape(profileResult.textures.get("cape"));
        }
        if (profileResult.textures.get("ears") != null) {
            playerHandler.applyEars(profileResult.textures.get("ears"));
        }
    }

    private static class ProfileResult {
        private boolean capeGlint = false;
        private boolean upsideDown = false;
        private Map<String, String> textures = null;

        private ProfileResult() {
        }
    }
}

