/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dynamic_fps.impl.DynamicFPSMod;
import dynamic_fps.impl.PowerState;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_340;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={class_340.class})
public class DebugScreenOverlayMixin {
    @ModifyReturnValue(method={"getGameInformation"}, at={@At(value="RETURN")})
    private List<String> getGameInformation(List<String> result) {
        if (DynamicFPSMod.isDisabled()) {
            String reason = DynamicFPSMod.whyIsTheModNotWorking();
            result.add(2, this.format("\u00a7c[Dynamic FPS] Inactive! Reason: %s\u00a7r", reason));
        } else {
            PowerState status = DynamicFPSMod.powerState();
            if (status != PowerState.FOCUSED) {
                int fps = DynamicFPSMod.targetFrameRate();
                String vsync = DynamicFPSMod.enableVsync() ? " vsync" : "";
                String target = fps == 260 ? "inf" : Integer.toString(fps);
                result.add(2, this.format("\u00a7c[Dynamic FPS] FPS: %s%s P: %s\u00a7r", target, vsync, status.toString().toLowerCase(Locale.ROOT)));
            }
        }
        return result;
    }

    private String format(String template, Object ... args) {
        return String.format(Locale.ROOT, template, args);
    }
}

