/*
 * Decompiled with CFR 0.152.
 */
package dev.norbiros.emojitype;

import dev.norbiros.emojitype.config.ConfigUtil;
import dev.norbiros.emojitype.emoji.EmojiCode;
import java.util.ArrayList;
import java.util.List;

public class EmojiType {
    public static final String MOD_ID = "emojitype";
    public static final ArrayList<EmojiCode> DEFAULT_EMOJI_CODES = new ArrayList<EmojiCode>(){
        {
            this.add(new EmojiCode(":bucket:", "\ud83e\udea3"));
            this.add(new EmojiCode(":shears:", "\u2702"));
            this.add(new EmojiCode(":whiteflag:", "\u2691"));
            this.add(new EmojiCode(":bell:", "\ud83d\udd14"));
            this.add(new EmojiCode(":hunger:", "\ud83c\udf56"));
            this.add(new EmojiCode(":hourglass2:", "\u23f3"));
            this.add(new EmojiCode(":happy1:", "\u263a"));
            this.add(new EmojiCode(":happy2:", "\u263b"));
            this.add(new EmojiCode(":sad:", "\u2639"));
            this.add(new EmojiCode(":skull:", "\u2620"));
            this.add(new EmojiCode(":pickaxe:", "\u26cf"));
            this.add(new EmojiCode(":axe:", "\ud83e\ude93"));
            this.add(new EmojiCode(":fishing:", "\ud83c\udfa3"));
            this.add(new EmojiCode(":umbrella:", "\u2602"));
            this.add(new EmojiCode(":trident:", "\ud83d\udd31"));
            this.add(new EmojiCode(":sword:", "\ud83d\udde1"));
            this.add(new EmojiCode(":shield:", "\ud83d\udee1"));
            this.add(new EmojiCode(":duel:", "\u2694"));
            this.add(new EmojiCode(":bow:", "\ud83c\udff9"));
            this.add(new EmojiCode(":potion:", "\ud83e\uddea"));
            this.add(new EmojiCode(":splash:", "\u2697"));
            this.add(new EmojiCode(":copyright:", "\u00a9"));
            this.add(new EmojiCode(":registered:", "\u00ae"));
            this.add(new EmojiCode(":protected:", "\u2117"));
            this.add(new EmojiCode(":trademark:", "\u2122"));
            this.add(new EmojiCode(":globe:", "\ud83c\udf0d"));
            this.add(new EmojiCode(":globe2:", "\ud83c\udf0e"));
            this.add(new EmojiCode(":globe3:", "\ud83c\udf0f"));
            this.add(new EmojiCode(":globemeridians:", "\ud83c\udf10"));
            this.add(new EmojiCode(":anchor:", "\u2693"));
            this.add(new EmojiCode(":wave:", "\ud83c\udf0a"));
            this.add(new EmojiCode(":trademark:", "\u2122"));
            this.add(new EmojiCode(":male:", "\u2642"));
            this.add(new EmojiCode(":female:", "\u2640"));
            this.add(new EmojiCode(":intersex:", "\u26a5"));
            this.add(new EmojiCode(":left:", "\u23f4"));
            this.add(new EmojiCode(":right:", "\u23f5"));
            this.add(new EmojiCode(":up:", "\u23f6"));
            this.add(new EmojiCode(":down:", "\u23f7"));
            this.add(new EmojiCode(":handleft:", "\u261c"));
            this.add(new EmojiCode(":handright:", "\u261e"));
            this.add(new EmojiCode(":swap:", "\u21c4"));
            this.add(new EmojiCode(":yingyang:", "\u262f"));
            this.add(new EmojiCode(":peace:", "\u262e"));
            this.add(new EmojiCode(":sun:", "\u2600"));
            this.add(new EmojiCode(":cloud:", "\u2601"));
            this.add(new EmojiCode(":comet:", "\u2604"));
            this.add(new EmojiCode(":moon:", "\u263d"));
            this.add(new EmojiCode(":snowman:", "\u26c4"));
            this.add(new EmojiCode(":storm:", "\u26c8"));
            this.add(new EmojiCode(":snow:", "\u2744"));
            this.add(new EmojiCode(":eject:", "\u23cf"));
            this.add(new EmojiCode(":fastforward:", "\u23e9"));
            this.add(new EmojiCode(":fastbackward:", "\u23ea"));
            this.add(new EmojiCode(":toend:", "\u23ed"));
            this.add(new EmojiCode(":tostart:", "\u23ee"));
            this.add(new EmojiCode(":playpause:", "\u23ef"));
            this.add(new EmojiCode(":pause:", "\u23f8"));
            this.add(new EmojiCode(":poweron:", "\u23fb"));
            this.add(new EmojiCode(":poweroff:", "\u23fc"));
            this.add(new EmojiCode(":blackflag:", "\u2690"));
            this.add(new EmojiCode(":box:", "\u2610"));
            this.add(new EmojiCode(":boxyes:", "\u2611"));
            this.add(new EmojiCode(":boxno:", "\u2612"));
            this.add(new EmojiCode(":yes:", "\u2714"));
            this.add(new EmojiCode(":no:", "\u2718"));
            this.add(new EmojiCode(":square1:", "\u23f9"));
            this.add(new EmojiCode(":square2:", "\u25a1"));
            this.add(new EmojiCode(":circle1:", "\u23fa"));
            this.add(new EmojiCode(":circle2:", "\u25cb"));
            this.add(new EmojiCode(":cross:", "\u274c"));
            this.add(new EmojiCode(":heart1:", "\u2764"));
            this.add(new EmojiCode(":heart2:", "\u2763"));
            this.add(new EmojiCode(":triangle1:", "\u25b2"));
            this.add(new EmojiCode(":triangle2:", "\u25b3"));
            this.add(new EmojiCode(":diamond1:", "\u25c6"));
            this.add(new EmojiCode(":diamond2:", "\u25c7"));
            this.add(new EmojiCode(":loopedsquare:", "\u2318"));
            this.add(new EmojiCode(":target:", "\u25ce"));
            this.add(new EmojiCode(":star1:", "\u2605"));
            this.add(new EmojiCode(":star2:", "\u2606"));
            this.add(new EmojiCode(":star3:", "\u2b50"));
            this.add(new EmojiCode(":fire:", "\ud83d\udd25"));
            this.add(new EmojiCode(":unknown:", "\ufffd"));
            this.add(new EmojiCode(":house:", "\u2302"));
            this.add(new EmojiCode(":clock:", "\u231a"));
            this.add(new EmojiCode(":warning:", "\u26a0"));
            this.add(new EmojiCode(":electric:", "\u26a1"));
            this.add(new EmojiCode(":mail:", "\u2709"));
            this.add(new EmojiCode(":pencil:", "\u270e"));
            this.add(new EmojiCode(":degree:", "\u00b0"));
            this.add(new EmojiCode(":hourglass:", "\u231b"));
            this.add(new EmojiCode(":suitspade1:", "\u2660"));
            this.add(new EmojiCode(":suitspade2:", "\u2664"));
            this.add(new EmojiCode(":suitheart1:", "\u2665"));
            this.add(new EmojiCode(":suitheart2:", "\u2661"));
            this.add(new EmojiCode(":suitclub1:", "\u2663"));
            this.add(new EmojiCode(":suitclub2:", "\u2667"));
            this.add(new EmojiCode(":suitdiamond1:", "\u2666"));
            this.add(new EmojiCode(":suitdiamond2:", "\u2662"));
            this.add(new EmojiCode(":note1:", "\u2669"));
            this.add(new EmojiCode(":note2:", "\u266a"));
            this.add(new EmojiCode(":note3:", "\u266b"));
            this.add(new EmojiCode(":note4:", "\u266c"));
            this.add(new EmojiCode(":flat:", "\u266d"));
            this.add(new EmojiCode(":sharp:", "\u266e"));
            this.add(new EmojiCode(":dice1:", "\u2680"));
            this.add(new EmojiCode(":dice2:", "\u2681"));
            this.add(new EmojiCode(":dice3:", "\u2682"));
            this.add(new EmojiCode(":dice4:", "\u2683"));
            this.add(new EmojiCode(":dice5:", "\u2684"));
            this.add(new EmojiCode(":dice6:", "\u2685"));
            this.add(new EmojiCode(":z0:", "\u2580"));
            this.add(new EmojiCode(":z1:", "\u2584"));
            this.add(new EmojiCode(":z2:", "\u2588"));
            this.add(new EmojiCode(":z3:", "\u258c"));
            this.add(new EmojiCode(":z4:", "\u2590"));
            this.add(new EmojiCode(":z5:", "\u2591"));
            this.add(new EmojiCode(":z6:", "\u2592"));
            this.add(new EmojiCode(":z7:", "\u2593"));
            this.add(new EmojiCode(":za:", "\u24d0"));
            this.add(new EmojiCode(":zb:", "\u24d1"));
            this.add(new EmojiCode(":zc:", "\u24d2"));
            this.add(new EmojiCode(":zd:", "\u24d3"));
            this.add(new EmojiCode(":ze:", "\u24d4"));
            this.add(new EmojiCode(":zf:", "\u24d5"));
            this.add(new EmojiCode(":zg:", "\u24d6"));
            this.add(new EmojiCode(":zh:", "\u24d7"));
            this.add(new EmojiCode(":zi:", "\u24d8"));
            this.add(new EmojiCode(":zj:", "\u24d9"));
            this.add(new EmojiCode(":zk:", "\u24da"));
            this.add(new EmojiCode(":zl:", "\u24db"));
            this.add(new EmojiCode(":zm:", "\u24dc"));
            this.add(new EmojiCode(":zn:", "\u24dd"));
            this.add(new EmojiCode(":zo:", "\u24de"));
            this.add(new EmojiCode(":zp:", "\u24df"));
            this.add(new EmojiCode(":zq:", "\u24e0"));
            this.add(new EmojiCode(":zr:", "\u24e1"));
            this.add(new EmojiCode(":zs:", "\u24e2"));
            this.add(new EmojiCode(":zt:", "\u24e3"));
            this.add(new EmojiCode(":zu:", "\u24e4"));
            this.add(new EmojiCode(":zv:", "\u24e5"));
            this.add(new EmojiCode(":zw:", "\u24e6"));
            this.add(new EmojiCode(":zx:", "\u24e7"));
            this.add(new EmojiCode(":zy:", "\u24e8"));
            this.add(new EmojiCode(":zz:", "\u24e9"));
            this.add(new EmojiCode(":za_:", "\u24b6"));
            this.add(new EmojiCode(":zb_:", "\u24b7"));
            this.add(new EmojiCode(":zc_:", "\u24b8"));
            this.add(new EmojiCode(":zd_:", "\u24b9"));
            this.add(new EmojiCode(":ze_:", "\u24ba"));
            this.add(new EmojiCode(":zf_:", "\u24bb"));
            this.add(new EmojiCode(":zg_:", "\u24bc"));
            this.add(new EmojiCode(":zh_:", "\u24bd"));
            this.add(new EmojiCode(":zi_:", "\u24be"));
            this.add(new EmojiCode(":zj_:", "\u24bf"));
            this.add(new EmojiCode(":zk_:", "\u24c0"));
            this.add(new EmojiCode(":zl_:", "\u24c1"));
            this.add(new EmojiCode(":zm_:", "\u24c2"));
            this.add(new EmojiCode(":zn_:", "\u24c3"));
            this.add(new EmojiCode(":zo_:", "\u24c4"));
            this.add(new EmojiCode(":zp_:", "\u24c5"));
            this.add(new EmojiCode(":zq_:", "\u24c6"));
            this.add(new EmojiCode(":zr_:", "\u24c7"));
            this.add(new EmojiCode(":zs_:", "\u24c8"));
            this.add(new EmojiCode(":zt_:", "\u24c9"));
            this.add(new EmojiCode(":zu_:", "\u24ca"));
            this.add(new EmojiCode(":zv_:", "\u24cb"));
            this.add(new EmojiCode(":zw_:", "\u24cc"));
            this.add(new EmojiCode(":zx_:", "\u24cd"));
            this.add(new EmojiCode(":zy_:", "\u24ce"));
            this.add(new EmojiCode(":zz_:", "\u24cf"));
            this.add(new EmojiCode(":face1:", "(\u00b0_\u00b0)"));
            this.add(new EmojiCode(":face2:", "(\u3186_\u3186)"));
            this.add(new EmojiCode(":face3:", "(O_O)"));
            this.add(new EmojiCode(":face4:", "(\u0ca0_\u0ca0)"));
            this.add(new EmojiCode(":face5:", "(\uff61\u25d5\u203f\u203f\u25d5\uff61)"));
            this.add(new EmojiCode(":face6:", "(-\u203f-)"));
            this.add(new EmojiCode(":face7:", "(\u25e0\u203f\u25e0)"));
            this.add(new EmojiCode(":face8:", "(\u273f\u25e0\u203f\u25e0)"));
            this.add(new EmojiCode(":face9:", "(\u00b0o\u2022)"));
            this.add(new EmojiCode(":bear1:", "\u0295\u00b7\u1d25\u00b7\u0294"));
            this.add(new EmojiCode(":bear2:", "\u0295\u3063\u00b7\u1d25\u00b7\u0294\u3063"));
            this.add(new EmojiCode(":bear3:", "\u0295\u2665\u1d25\u2665\u0294"));
            this.add(new EmojiCode(":bird:", "(\u00b0v\u00b0)"));
            this.add(new EmojiCode(":cat:", "(\u00b0\u1d25\u00b0)"));
            this.add(new EmojiCode(":dog:", "(\u25d5\u1d25\u25d5\u028b)"));
            this.add(new EmojiCode(":cheer1:", "\u203b\\(^o^)/\u203b"));
            this.add(new EmojiCode(":cheer2:", "*(^_^)*"));
            this.add(new EmojiCode(":cool1:", "(\u2310\u25a0_\u25a0)"));
            this.add(new EmojiCode(":cool2:", "(\u2022_\u2022) ( \u2022_\u2022)>\u2310\u25a0-\u25a0 (\u2310\u25a0_\u25a0)"));
            this.add(new EmojiCode(":creep:", "\u0505(\u2256\u203f\u2256\u0505)"));
            this.add(new EmojiCode(":cry:", "(\u2565\ufe4f\u2565)"));
            this.add(new EmojiCode(":dance1:", "\u1555(\u2310\u25a0_\u25a0)\u1557"));
            this.add(new EmojiCode(":dance2:", "\u1555( \u141b ) \u1557"));
            this.add(new EmojiCode(":table1:", "(\u256f\u00b0\u25a1\u00b0)\u256f\ufe35 \u253b\u2501\u253b"));
            this.add(new EmojiCode(":table2:", "(\u256f\u00b0\u25a1\u00b0)\u256f\ufe35 \u0287\u025f\u0250\u0279\u0254\u01ddu\u1d09\u026f"));
            this.add(new EmojiCode(":table3:", "(\u256f\u00b0\u25a1\u00b0)\u256f\ufe35 \u0183u\u0250\u027eo\u026f"));
            this.add(new EmojiCode(":table4:", "\u2533\u2501\u2533\u30ce(\u00b0_\u00b0\u30ce)"));
            this.add(new EmojiCode(":shrug1:", "\u00af\\_(\u30c4)_/\u00af"));
            this.add(new EmojiCode(":shrug2:", "\u00af\\(\u00b0_o)/\u00af"));
            this.add(new EmojiCode(":gimme:", "\u0f3c \u3064\u25d5_\u25d5\u0f3d\u3064"));
            this.add(new EmojiCode(":lol:", "L(\u00b0O\u00b0L)"));
            this.add(new EmojiCode(":zoidberg:", "(V)(\u00b0,,,\u00b0)(V)"));
            this.add(new EmojiCode(":fly:", "\u2500=\u2261\u03a3((\u3064\u2022\u03c9\u2022)\u3064"));
        }
    };
    public static ArrayList<String> allCodes = new ArrayList();
    public static ArrayList<String> allEmoji = new ArrayList();
    public static ArrayList<String> emojiCodesCombined = new ArrayList();
    public static ArrayList<EmojiCode> emojiCodes = new ArrayList();

    public static void update(List<String> emojiCodeStrings) {
        emojiCodes.clear();
        allCodes.clear();
        allEmoji.clear();
        emojiCodesCombined.clear();
        for (String str : emojiCodeStrings) {
            EmojiCode.fromString(str).ifPresent(emojiCodes::add);
        }
        for (EmojiCode ec : emojiCodes) {
            allCodes.add(ec.getCode());
            allEmoji.add(ec.getEmoji());
            emojiCodesCombined.add(ec.getCode() + " " + ec.getEmoji());
        }
    }

    public static void init() {
        System.out.println("EmojiType initialized!");
        ConfigUtil.deserialise();
    }
}

