/*
 * Decompiled with CFR 0.152.
 */
package com.HiWord9.RPRenames.mixin;

import com.HiWord9.RPRenames.AnvilScreenMixinAccessor;
import com.HiWord9.RPRenames.RPRenames;
import com.HiWord9.RPRenames.modConfig.ModConfig;
import com.HiWord9.RPRenames.util.Tabs;
import com.HiWord9.RPRenames.util.config.ConfigManager;
import com.HiWord9.RPRenames.util.config.Rename;
import com.HiWord9.RPRenames.util.gui.GhostCraft;
import com.HiWord9.RPRenames.util.gui.Graphics;
import com.HiWord9.RPRenames.util.gui.MultiItemTooltipComponent;
import com.HiWord9.RPRenames.util.gui.RenameButtonHolder;
import com.HiWord9.RPRenames.util.gui.button.FavoriteButton;
import com.HiWord9.RPRenames.util.gui.button.OpenerButton;
import com.HiWord9.RPRenames.util.gui.button.PageButton;
import com.HiWord9.RPRenames.util.gui.button.RenameButton;
import com.HiWord9.RPRenames.util.gui.button.TabButton;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_471;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7923;
import net.minecraft.class_8001;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_471.class}, priority=1200)
public abstract class AnvilScreenMixin
extends class_437
implements AnvilScreenMixinAccessor {
    private static final ModConfig config = ModConfig.INSTANCE;
    @Shadow
    private class_342 field_2821;
    boolean open;
    private static final class_2960 MENU_TEXTURE = new class_2960("rprenames", "textures/gui/menu.png");
    final int menuTextureHeight = 166;
    final int menuWidth = 147;
    final int menuHeight = 166;
    final int menuXOffset = -1;
    final int tabOffsetY = 6;
    final int startTabOffsetY = 6;
    final int buttonOffsetY = 2;
    final int buttonXOffset = 10;
    final int highlightColor = config.getSlotHighlightRGBA();
    int page = 0;
    int maxPageElements = 5;
    int currentRenameListSize;
    final String nullItem = "air";
    String currentItem = "air";
    class_1799 itemAfterUpdate = class_1799.field_8037;
    boolean shouldNotUpdateTab = false;
    int tempPage;
    OpenerButton opener;
    TabButton searchTab;
    TabButton favoriteTab;
    TabButton inventoryTab;
    TabButton globalTab;
    FavoriteButton favoriteButton;
    class_342 searchField;
    PageButton pageDown;
    PageButton pageUp;
    class_2561 pageCount = class_2561.method_43473();
    ArrayList<RenameButtonHolder> buttons = new ArrayList();
    Tabs currentTab = Tabs.SEARCH;
    GhostCraft ghostCraft = new GhostCraft();
    ArrayList<Rename> originalRenameList = new ArrayList();
    ArrayList<Rename> currentRenameList = new ArrayList();
    class_327 renderer;
    final int menuShift = 77;
    final int searchFieldXOffset = 23;
    final class_2561 SEARCH_HINT_TEXT;
    String searchTag;
    ArrayList<String> invChangeHandler;

    protected AnvilScreenMixin(class_2561 title) {
        super(title);
        this.renderer = class_310.method_1551().field_1772;
        this.menuShift = 77;
        this.searchFieldXOffset = 23;
        this.SEARCH_HINT_TEXT = class_2561.method_43471((String)"rprenames.gui.searchHintText").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
        this.searchTag = "";
        this.invChangeHandler = new ArrayList();
    }

    @Inject(at={@At(value="HEAD")}, method={"setup"})
    private void init(CallbackInfo ci) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return;
        }
        RPRenames.LOGGER.info("Starting RPRenames modification on AnvilScreen");
        assert (this.field_22787 != null && this.field_22787.field_1755 != null);
        int x = ((class_471)this.field_22787.field_1755).field_2776;
        int y = ((class_471)this.field_22787.field_1755).field_2800;
        int menuX = x - 147 + -1;
        int pageButtonsY = y + 140;
        if (AnvilScreenMixin.config.viewMode == RenameButtonHolder.ViewMode.GRID) {
            pageButtonsY -= 4;
            this.maxPageElements = 20;
        }
        for (int i = 0; i < this.maxPageElements; ++i) {
            this.buttons.add(new RenameButtonHolder(AnvilScreenMixin.config.viewMode, i));
        }
        this.pageDown = new PageButton(menuX + 10, pageButtonsY, PageButton.Type.DOWN);
        this.pageUp = new PageButton(x + -1 - 10 - 30, pageButtonsY, PageButton.Type.UP);
        this.opener = new OpenerButton(x + 3, y + 44);
        int tabX = menuX - 30;
        int tabY = y + 6;
        this.searchTab = new TabButton(tabX, tabY, Tabs.SEARCH);
        this.favoriteTab = new TabButton(tabX, tabY + 32, Tabs.FAVORITE);
        this.inventoryTab = new TabButton(tabX, tabY + 64, Tabs.INVENTORY);
        this.globalTab = new TabButton(tabX, tabY + 128, Tabs.GLOBAL);
        this.favoriteButton = new FavoriteButton(x + 88 + AnvilScreenMixin.config.favoritePosX, y + 83 + AnvilScreenMixin.config.favoritePosY);
        this.searchField = new class_342(this.renderer, menuX + 23, y + 15, 109, 10, class_2561.method_30163((String)""));
        this.searchField.method_1863(this::onSearch);
        this.searchField.method_1858(false);
        this.searchField.method_1880(1024);
    }

    @Inject(at={@At(value="TAIL")}, method={"setup"})
    private void initTail(CallbackInfo ci) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return;
        }
        if (AnvilScreenMixin.config.openByDefault) {
            this.openMenu();
        } else {
            this.screenUpdate();
        }
    }

    @Override
    public void switchOpen() {
        if (!this.open) {
            this.openMenu();
        } else {
            this.closeMenu();
        }
    }

    @Override
    public void addOrRemoveFavorite(boolean add) {
        String favoriteName = this.field_2821.method_1882();
        String item = this.getItemInFirstSlot();
        if (!item.equals("air")) {
            if (add) {
                ConfigManager.addToFavorites(favoriteName, item);
            } else {
                ConfigManager.removeFromFavorites(favoriteName, item);
            }
            this.favoriteButtonsUpdate(this.field_2821.method_1882());
            if (this.open) {
                this.screenUpdate(this.page);
            }
        }
    }

    @Override
    public void onPageDown() {
        this.page = AnvilScreenMixin.method_25442() ? 0 : --this.page;
        this.updateWidgets();
        if (this.page == 0) {
            this.pageDown.field_22763 = false;
        }
        this.pageUp.field_22763 = true;
    }

    @Override
    public void onPageUp() {
        this.page = AnvilScreenMixin.method_25442() ? (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements - 1 : ++this.page;
        this.updateWidgets();
        this.pageDown.field_22763 = true;
        if ((this.page + 1) * this.maxPageElements > this.currentRenameListSize - 1) {
            this.pageUp.field_22763 = false;
        }
    }

    @Override
    public void setTab(Tabs tab) {
        if (tab == this.currentTab) {
            return;
        }
        this.currentTab = tab;
        this.screenUpdate();
    }

    @Override
    public Tabs getCurrentTab() {
        return this.currentTab;
    }

    @Override
    public void onRenameButton(int indexInInventory, boolean isInInventory, boolean asCurrentItem, class_1661 inventory, Rename rename, boolean enoughStackSize, boolean enoughDamage, boolean hasEnchant, boolean hasEnoughLevels) {
        this.ghostCraft.reset();
        if (indexInInventory != 36 && isInInventory) {
            this.shouldNotUpdateTab = this.currentTab == Tabs.INVENTORY || this.currentTab == Tabs.GLOBAL;
            this.tempPage = this.page;
            if (!asCurrentItem) {
                AnvilScreenMixin.putInAnvil(indexInInventory, class_310.method_1551());
            }
            this.shouldNotUpdateTab = false;
        } else if (indexInInventory != 36) {
            this.shouldNotUpdateTab = this.currentTab == Tabs.INVENTORY || this.currentTab == Tabs.GLOBAL;
            for (int s = 0; s < 2; ++s) {
                this.moveToInventory(s, inventory);
            }
            this.shouldNotUpdateTab = false;
            class_1799[] ghostCraftItems = ConfigManager.getGhostCraftItems(rename);
            this.ghostCraft.setSlots(ghostCraftItems[0], ghostCraftItems[1], ghostCraftItems[2]);
            this.ghostCraft.setRender(true);
        } else {
            this.moveToInventory(1, inventory);
        }
        if (isInInventory) {
            if (!enoughStackSize || !enoughDamage) {
                this.ghostCraft.setForceRenderBG(true, null, true);
                this.ghostCraft.setRender(true);
            }
            if (!hasEnchant || !hasEnoughLevels) {
                this.ghostCraft.setSlots(class_1799.field_8037, ConfigManager.getGhostCraftEnchant(rename), class_1799.field_8037);
                this.ghostCraft.setForceRenderBG(null, null, true);
                this.ghostCraft.setRender(true);
            }
        }
        this.field_2821.method_1852(rename.getName());
    }

    private void openMenu() {
        this.open = true;
        RPRenames.LOGGER.info("Opening RPRenames Menu");
        this.currentTab = this.currentItem.equals("air") ? Tabs.GLOBAL : Tabs.SEARCH;
        this.screenUpdate();
        this.updateMenuShift();
    }

    private void closeMenu() {
        this.open = false;
        RPRenames.LOGGER.info("Closing RPRenames Menu");
        this.searchField.method_25365(false);
        this.searchField.method_1856(false);
        this.searchField.method_1852("");
        this.removeWidgets();
        this.method_37066((class_364)this.searchField);
        this.field_2821.method_25365(true);
        this.field_2821.method_1856(false);
        this.opener.setOpen(this.open);
        this.currentTab = Tabs.SEARCH;
        this.updateMenuShift();
    }

    private void updateWidgets() {
        this.defineButtons();
        this.showButtons();
        this.updatePageWidgets();
    }

    private void screenUpdate() {
        this.screenUpdate(0);
    }

    private void screenUpdate(int savedPage) {
        this.page = savedPage;
        this.opener.field_22763 = true;
        if (this.shouldNotUpdateTab) {
            this.page = this.tempPage;
        }
        this.calcRenameList();
        if (this.open) {
            this.removeWidgets();
            this.updateSearchRequest(this.page);
            this.opener.setOpen(this.open);
            this.method_37063((class_364)this.searchField);
            this.searchField.method_1856(true);
            this.field_2821.method_25365(false);
            this.field_2821.method_1856(true);
        }
    }

    private void calcRenameList() {
        switch (this.currentTab) {
            case SEARCH: {
                this.originalRenameList = ConfigManager.getRenames(this.getItemInFirstSlot());
                break;
            }
            case FAVORITE: {
                this.originalRenameList = ConfigManager.getFavorites(this.getItemInFirstSlot());
                break;
            }
            case INVENTORY: {
                ArrayList<String> currentInvList = this.getInventory();
                ArrayList<String> checked = new ArrayList<String>();
                ArrayList<Rename> names = new ArrayList<Rename>();
                for (String item : currentInvList) {
                    if (item.equals("air") || checked.contains(item)) continue;
                    checked.add(item);
                    ArrayList<Rename> renames = ConfigManager.getRenames(item);
                    for (Rename r : renames) {
                        if (names.contains(r)) continue;
                        names.add(r);
                    }
                }
                this.originalRenameList = names;
                break;
            }
            case GLOBAL: {
                this.originalRenameList = ConfigManager.getAllRenames();
            }
        }
    }

    private void updateSearchRequest() {
        this.updateSearchRequest(0);
    }

    private void updateSearchRequest(int page) {
        this.hideButtons();
        this.currentRenameList = ConfigManager.search(this.originalRenameList, this.searchTag);
        this.page = page;
        if (this.page >= (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements) {
            this.page = (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements - 1;
            if (this.page == -1) {
                this.page = 0;
            }
        }
        this.currentRenameListSize = this.currentRenameList.size();
        this.defineButtons();
        this.showButtons();
        this.updatePageWidgets();
    }

    private String getItemInFirstSlot() {
        String item = this.currentItem;
        if (item.equals("air") && !this.ghostCraft.slot1.method_7960()) {
            item = ConfigManager.getIdAndPath(this.ghostCraft.slot1.method_7909());
        }
        return item;
    }

    @Inject(at={@At(value="RETURN")}, method={"onRenamed"})
    private void newNameEntered(String name, CallbackInfo ci) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return;
        }
        this.favoriteButtonsUpdate(name);
    }

    private void favoriteButtonsUpdate(String name) {
        if (!name.isEmpty()) {
            this.favoriteButton.field_22763 = true;
            boolean favorite = Rename.isFavorite(this.getItemInFirstSlot(), name);
            this.favoriteButton.setFavorite(favorite);
        } else {
            this.favoriteButton.field_22763 = false;
        }
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/AnvilScreen;init(Lnet/minecraft/client/MinecraftClient;II)V"), method={"resize"})
    private void onResize(class_471 instance, class_310 client, int width, int height) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            instance.method_25423(client, width, height);
            return;
        }
        this.buttons.clear();
        String tempSearchFieldText = this.searchField.method_1882();
        instance.method_25423(client, width, height);
        this.searchField.method_1852(tempSearchFieldText);
    }

    @Redirect(at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;isActive()Z"), method={"keyPressed"})
    private boolean onKeyPressedNameFieldIsActive(class_342 instance, int keyCode, int scanCode, int modifiers) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return instance.method_20315();
        }
        this.searchField.method_25404(keyCode, scanCode, modifiers);
        return instance.method_20315() || this.searchField.method_20315();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return super.method_25402(mouseX, mouseY, button);
        }
        assert (this.field_22787 != null && this.field_22787.field_1755 != null);
        int xScreenOffset = ((class_471)this.field_22787.field_1755).field_2776;
        int yScreenOffset = ((class_471)this.field_22787.field_1755).field_2800;
        if (this.ghostCraft.doRender && mouseX - (double)xScreenOffset >= 26.0 && mouseX - (double)xScreenOffset <= 151.0 && mouseY - (double)yScreenOffset >= 46.0 && mouseY - (double)yScreenOffset <= 64.0) {
            this.ghostCraft.reset();
            if (this.currentItem.equals("air")) {
                this.field_2821.method_1852("");
                if (this.currentTab == Tabs.SEARCH || this.currentTab == Tabs.FAVORITE) {
                    this.screenUpdate();
                }
            }
        }
        if (this.open) {
            for (RenameButtonHolder renameButtonHolder : this.buttons) {
                if (!renameButtonHolder.isActive()) continue;
                renameButtonHolder.getButton().method_25402(mouseX, mouseY, button);
            }
            this.pageDown.method_25402(mouseX, mouseY, button);
            this.pageUp.method_25402(mouseX, mouseY, button);
            this.searchTab.method_25402(mouseX, mouseY, button);
            this.favoriteTab.method_25402(mouseX, mouseY, button);
            this.inventoryTab.method_25402(mouseX, mouseY, button);
            this.globalTab.method_25402(mouseX, mouseY, button);
        }
        this.opener.method_25402(mouseX, mouseY, button);
        this.favoriteButton.method_25402(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    @Inject(at={@At(value="RETURN")}, method={"drawBackground"})
    private void onDrawBackground(CallbackInfo ci) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return;
        }
        if (this.invChangeHandler.isEmpty()) {
            this.invChangeHandler = this.getInventory();
            return;
        }
        ArrayList<String> temp = this.getInventory();
        boolean equal = true;
        for (int i = 0; i < temp.size() || i < this.invChangeHandler.size(); ++i) {
            if (this.invChangeHandler.size() > i && temp.size() > i) {
                if (this.invChangeHandler.get(i).equals(temp.get(i))) continue;
                equal = false;
                break;
            }
            equal = false;
            break;
        }
        if (!equal) {
            this.invChangeHandler = temp;
            if (this.open) {
                this.screenUpdate(this.page);
            }
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"onSlotUpdate"})
    private void itemUpdate(class_1703 handler, int slotId, class_1799 stack, CallbackInfo ci) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return;
        }
        if (slotId == 0 || slotId == 1) {
            this.ghostCraft.reset();
        }
        if (slotId != 0) {
            return;
        }
        this.itemAfterUpdate = stack.method_7972();
        if (stack.method_7960()) {
            this.currentItem = "air";
            this.searchField.method_1856(false);
            this.method_37066((class_364)this.searchField);
            this.searchField.method_25365(false);
        } else {
            this.currentItem = ConfigManager.getIdAndPath(stack.method_7909());
            this.searchField.method_1856(true);
            if (!this.shouldNotUpdateTab) {
                this.currentTab = Tabs.SEARCH;
            }
            this.favoriteButtonsUpdate(this.field_2821.method_1882());
        }
        if (!this.open || this.currentTab != Tabs.GLOBAL) {
            this.screenUpdate();
        } else {
            this.updateSearchRequest(this.page);
        }
    }

    private ArrayList<String> getInventory() {
        ArrayList<String> inventoryList = new ArrayList<String>();
        assert (class_310.method_1551().field_1724 != null);
        class_1661 inventory = class_310.method_1551().field_1724.method_31548();
        for (class_1799 itemStack : inventory.field_7547) {
            inventoryList.add(ConfigManager.getIdAndPath(itemStack.method_7909()));
        }
        inventoryList.add(this.currentItem);
        return inventoryList;
    }

    private void updateMenuShift() {
        if (!AnvilScreenMixin.config.offsetMenu) {
            return;
        }
        this.offsetX(77 * (this.open ? 1 : -1));
    }

    private void offsetX(int x) {
        if (this.field_22787 == null || this.field_22787.field_1755 == null) {
            return;
        }
        ((class_471)this.field_22787.field_1755).field_2776 += x;
        this.field_2821.method_46421(this.field_2821.method_46426() + x);
        this.opener.method_46421(this.opener.method_46426() + x);
        this.searchTab.method_46421(this.searchTab.method_46426() + x);
        this.favoriteTab.method_46421(this.favoriteTab.method_46426() + x);
        this.inventoryTab.method_46421(this.inventoryTab.method_46426() + x);
        this.globalTab.method_46421(this.globalTab.method_46426() + x);
        this.favoriteButton.method_46421(this.favoriteButton.method_46426() + x);
        this.searchField.method_46421(this.searchField.method_46426() + x);
        this.pageDown.method_46421(this.pageDown.method_46426() + x);
        this.pageUp.method_46421(this.pageUp.method_46426() + x);
        for (RenameButtonHolder renameButtonHolder : this.buttons) {
            RenameButton button = renameButtonHolder.getButton();
            if (button == null) continue;
            button.method_46421(button.method_46426() + x);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"drawForeground"})
    private void frameUpdate(class_332 context, int mouseX, int mouseY, CallbackInfo ci) {
        if (!AnvilScreenMixin.config.enableAnvilModification) {
            return;
        }
        if (this.field_22787 == null || this.field_22787.field_1755 == null) {
            return;
        }
        int xScreenOffset = ((class_471)this.field_22787.field_1755).field_2776;
        int yScreenOffset = ((class_471)this.field_22787.field_1755).field_2800;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(-xScreenOffset), (float)(-yScreenOffset), 0.0f);
        this.opener.method_25394(context, mouseX, mouseY, 0.0f);
        this.favoriteButton.method_25394(context, mouseX, mouseY, 0.0f);
        matrices.method_22909();
        if (!this.open) {
            this.searchField.method_25365(false);
            return;
        }
        RenderSystem.enableDepthTest();
        context.method_25291(MENU_TEXTURE, -148, 0, 0, 0.0f, 0.0f, 147, 166, 147, 166);
        matrices.method_22903();
        matrices.method_46416((float)(-xScreenOffset), (float)(-yScreenOffset), 0.0f);
        for (RenameButtonHolder renameButtonHolder : this.buttons) {
            if (!renameButtonHolder.isActive()) continue;
            renameButtonHolder.getButton().method_25394(context, mouseX, mouseY, 0.0f);
            renameButtonHolder.drawElements(context);
        }
        this.searchTab.method_25394(context, mouseX, mouseY, 0.0f);
        this.favoriteTab.method_25394(context, mouseX, mouseY, 0.0f);
        this.inventoryTab.method_25394(context, mouseX, mouseY, 0.0f);
        this.globalTab.method_25394(context, mouseX, mouseY, 0.0f);
        this.pageDown.method_25394(context, mouseX, mouseY, 0.0f);
        this.pageUp.method_25394(context, mouseX, mouseY, 0.0f);
        matrices.method_22909();
        Graphics.renderText(context, this.pageCount, -74, AnvilScreenMixin.config.viewMode == RenameButtonHolder.ViewMode.GRID ? 140 : 144, false, true);
        if (this.searchField != null && !this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
            Graphics.renderText(context, this.SEARCH_HINT_TEXT, -1, -124, 15, true, false);
        }
        this.ghostCraft.render(context, mouseX - xScreenOffset, mouseY - yScreenOffset);
        if (this.currentRenameList.isEmpty()) {
            String key = this.getItemInFirstSlot().equals("air") && (this.currentTab == Tabs.FAVORITE || this.currentTab == Tabs.SEARCH) ? "putItem" : (this.currentTab == Tabs.FAVORITE ? "noFavoriteRenamesFound" : "noRenamesFound");
            Graphics.renderText(context, (class_2561)class_2561.method_43471((String)("rprenames.gui." + key)).method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080)), -1, -74, 37, true, true);
        } else {
            for (RenameButtonHolder renameButtonHolder : this.buttons) {
                if (renameButtonHolder.getButton() == null || !renameButtonHolder.getButton().method_25405(mouseX, mouseY) || !renameButtonHolder.isActive()) continue;
                ArrayList<class_5684> tooltip = new ArrayList<class_5684>(renameButtonHolder.getTooltip());
                if (!renameButtonHolder.isCEM() && AnvilScreenMixin.config.enablePreview) {
                    if (!AnvilScreenMixin.method_25442() && !AnvilScreenMixin.config.playerPreviewByDefault) {
                        if (!AnvilScreenMixin.config.disablePlayerPreviewTips) {
                            tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43471((String)"rprenames.gui.tooltipHint.playerPreviewTip.holdShift").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))).method_30937()));
                        }
                    } else if (AnvilScreenMixin.method_25442() != AnvilScreenMixin.config.playerPreviewByDefault) {
                        this.searchField.method_25365(false);
                        this.field_2821.method_25365(false);
                        if (!AnvilScreenMixin.config.disablePlayerPreviewTips) {
                            tooltip.add(class_5684.method_32662((class_5481)class_2561.method_43471((String)"rprenames.gui.tooltipHint.playerPreviewTip.pressF").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))).method_30937()));
                        }
                    }
                }
                if ((this.currentTab == Tabs.INVENTORY || this.currentTab == Tabs.GLOBAL) && AnvilScreenMixin.config.slotHighlightColorALPHA > 0 && AnvilScreenMixin.config.highlightSlot) {
                    renameButtonHolder.highlightSlot(context, this.getInventory(), this.currentItem, this.highlightColor);
                }
                matrices.method_22903();
                matrices.method_46416((float)(-xScreenOffset), (float)(-yScreenOffset), 0.0f);
                Graphics.drawTooltip(context, class_310.method_1551().field_1772, tooltip, mouseX, mouseY, class_8001.field_41687);
                if (AnvilScreenMixin.config.enablePreview) {
                    renameButtonHolder.drawPreview(context, mouseX, mouseY, 52, 52, AnvilScreenMixin.config.scaleFactorItem, AnvilScreenMixin.config.scaleFactorEntity);
                }
                matrices.method_22909();
            }
        }
        RenderSystem.disableDepthTest();
    }

    private void showButtons() {
        for (RenameButtonHolder renameButtonHolder : this.buttons) {
            int orderOnPage = renameButtonHolder.getOrderOnPage();
            if (orderOnPage + this.page * this.maxPageElements > this.currentRenameListSize - 1) continue;
            renameButtonHolder.setActive(true);
        }
    }

    private void hideButtons() {
        for (RenameButtonHolder renameButtonHolder : this.buttons) {
            renameButtonHolder.setActive(false);
        }
    }

    private void removeWidgets() {
        this.hideButtons();
        this.pageCount = class_2561.method_43473();
    }

    private static void putInAnvil(int slotInInventory, class_310 client) {
        if (client.field_1724 == null || client.field_1761 == null) {
            return;
        }
        int syncId = client.field_1724.field_7512.field_7763;
        if (slotInInventory >= 9) {
            int i = slotInInventory - 9;
            client.field_1761.method_2906(syncId, i += 3, 0, class_1713.field_7790, (class_1657)client.field_1724);
            client.field_1761.method_2906(syncId, 0, 0, class_1713.field_7790, (class_1657)client.field_1724);
            client.field_1761.method_2906(syncId, i, 0, class_1713.field_7790, (class_1657)client.field_1724);
        } else {
            client.field_1761.method_2906(syncId, 0, slotInInventory, class_1713.field_7791, (class_1657)client.field_1724);
        }
    }

    public void moveToInventory(int slot, class_1661 inventory) {
        assert ((this.field_22787 != null ? this.field_22787.field_1724 : null) != null);
        class_1799 stack = ((class_1735)this.field_22787.field_1724.field_7512.field_7761.get(slot)).method_7677();
        if (!stack.method_7960()) {
            int syncId = this.field_22787.field_1724.field_7512.field_7763;
            assert (this.field_22787.field_1761 != null);
            if (inventory.method_7390(stack) != -1 || inventory.method_7376() != -1) {
                this.field_22787.field_1761.method_2906(syncId, slot, 0, class_1713.field_7794, (class_1657)this.field_22787.field_1724);
                this.moveToInventory(slot, inventory);
            } else {
                this.field_22787.field_1761.method_2906(syncId, slot, 99, class_1713.field_7795, (class_1657)this.field_22787.field_1724);
            }
        }
    }

    private void createButton(int orderOnPage, Rename rename) {
        int y;
        int x;
        String item;
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        class_1661 playerInventory = class_310.method_1551().field_1724.method_31548();
        ArrayList<String> inventory = this.getInventory();
        if (this.currentTab == Tabs.SEARCH) {
            item = this.getItemInFirstSlot();
        } else {
            item = rename.getItems().get(0);
            for (String s : rename.getItems()) {
                if (!inventory.contains(s)) continue;
                item = s;
                break;
            }
        }
        boolean asCurrentItem = item.equals(this.getItemInFirstSlot());
        boolean isInInventory = inventory.contains(item);
        int indexInInventory = inventory.indexOf(item);
        boolean favorite = false;
        if (this.currentTab != Tabs.SEARCH) {
            for (String s : rename.getItems()) {
                if (!Rename.isFavorite(s, rename.getName())) continue;
                favorite = true;
                break;
            }
        } else {
            favorite = Rename.isFavorite(item, rename.getName());
        }
        ArrayList<Object> tooltip = new ArrayList<Object>();
        tooltip.add(class_2561.method_30163((String)rename.getName()));
        if (rename.getDescription() != null && AnvilScreenMixin.config.showDescription) {
            ArrayList<class_2561> lines = ConfigManager.parseCustomDescription(rename.getDescription());
            tooltip.addAll(lines);
        }
        if (this.currentTab == Tabs.INVENTORY || this.currentTab == Tabs.GLOBAL) {
            ArrayList<MultiItemTooltipComponent.TooltipItem> tooltipItems = new ArrayList<MultiItemTooltipComponent.TooltipItem>();
            for (int i = 0; i < rename.getItems().size(); ++i) {
                class_1799 itemStack = ConfigManager.createItem(rename, false, i);
                tooltipItems.add(new MultiItemTooltipComponent.TooltipItem(itemStack, inventory.contains(rename.getItems().get(i))));
            }
            tooltip.add(new MultiItemTooltipComponent(tooltipItems));
        }
        if (item.equals(ConfigManager.getIdAndPath(class_1802.field_8448)) && rename.isCEM()) {
            class_2960 mob = new class_2960(rename.getMob().entity());
            class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(mob);
            tooltip.add(class_2561.method_43471((String)entityType.method_5882()).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1054)));
        }
        boolean enoughStackSize = true;
        boolean enoughDamage = true;
        boolean hasEnchant = false;
        boolean hasEnoughLevels = false;
        if (rename.getStackSize() != null && rename.getStackSize() > 1) {
            if (this.currentTab != Tabs.INVENTORY && this.currentTab != Tabs.GLOBAL || asCurrentItem) {
                enoughStackSize = Rename.isInBounds(this.itemAfterUpdate.method_7947(), rename.getOriginalStackSize());
            } else if (isInInventory) {
                enoughStackSize = Rename.isInBounds(((class_1799)playerInventory.field_7547.get(indexInInventory)).method_7947(), rename.getOriginalStackSize());
            }
            if (AnvilScreenMixin.config.showExtraProperties) {
                if (AnvilScreenMixin.config.showOriginalProperties) {
                    tooltip.add(class_2561.method_30163((String)"stackSize").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)rename.getOriginalStackSize()).method_27661().method_27696(class_2583.field_24360.method_10977(enoughStackSize ? class_124.field_1060 : class_124.field_1079))));
                } else {
                    tooltip.add(class_2561.method_30163((String)(class_2561.method_43471((String)"rprenames.gui.tooltipHint.stackSize").getString() + " " + rename.getStackSize())).method_27661().method_27696(class_2583.field_24360.method_10977(enoughStackSize ? class_124.field_1080 : class_124.field_1079)));
                }
            }
        }
        if (rename.getDamage() != null && rename.getDamage().damage > 0) {
            if (this.currentTab != Tabs.INVENTORY && this.currentTab != Tabs.GLOBAL || asCurrentItem) {
                enoughDamage = Rename.isInBounds(this.itemAfterUpdate.method_7919(), rename.getOriginalDamage(), item);
            } else if (isInInventory) {
                enoughDamage = Rename.isInBounds(((class_1799)playerInventory.field_7547.get(indexInInventory)).method_7919(), rename.getOriginalDamage(), item);
            }
            if (AnvilScreenMixin.config.showExtraProperties) {
                if (AnvilScreenMixin.config.showOriginalProperties) {
                    tooltip.add(class_2561.method_30163((String)"damage").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)rename.getOriginalDamage()).method_27661().method_27696(class_2583.field_24360.method_10977(enoughDamage ? class_124.field_1060 : class_124.field_1079))));
                } else {
                    tooltip.add(class_2561.method_30163((String)(class_2561.method_43471((String)"rprenames.gui.tooltipHint.damage").getString() + " " + rename.getDamage().damage + (rename.getDamage().percent ? "%" : ""))).method_27661().method_27696(class_2583.field_24360.method_10977(enoughDamage ? class_124.field_1080 : class_124.field_1079)));
                }
            }
        }
        if (rename.getEnchantment() == null) {
            hasEnchant = true;
            hasEnoughLevels = true;
        } else {
            Map enchantments = Maps.newLinkedHashMap();
            if (this.currentTab != Tabs.INVENTORY && this.currentTab != Tabs.GLOBAL || asCurrentItem) {
                enchantments = class_1890.method_22445((class_2499)this.itemAfterUpdate.method_7921());
            } else if (isInInventory) {
                enchantments = class_1890.method_22445((class_2499)((class_1799)playerInventory.field_7547.get(indexInInventory)).method_7921());
            }
            for (Map.Entry entry : enchantments.entrySet()) {
                class_1887 enchantment = (class_1887)entry.getKey();
                Object enchantName = rename.getEnchantment();
                if (!((String)enchantName).contains(":")) {
                    enchantName = "minecraft:" + (String)enchantName;
                }
                if (!Objects.requireNonNull(class_7923.field_41176.method_10221((Object)enchantment)).toString().equals(enchantName)) continue;
                hasEnchant = true;
                if (!Rename.isInBounds((Integer)entry.getValue(), rename.getOriginalEnchantmentLevel())) continue;
                hasEnoughLevels = true;
                break;
            }
            if (this.currentTab == Tabs.GLOBAL && !isInInventory) {
                hasEnchant = true;
                hasEnoughLevels = true;
            }
            if (AnvilScreenMixin.config.showExtraProperties) {
                if (AnvilScreenMixin.config.showOriginalProperties) {
                    tooltip.add(class_2561.method_30163((String)"enchantmentIDs").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)rename.getOriginalEnchantment()).method_27661().method_27696(class_2583.field_24360.method_10977(hasEnchant ? class_124.field_1060 : class_124.field_1079))));
                    if (rename.getOriginalEnchantmentLevel() != null) {
                        tooltip.add(class_2561.method_30163((String)"enchantmentLevels").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)"=").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))).method_10852((class_2561)class_2561.method_30163((String)rename.getOriginalEnchantmentLevel()).method_27661().method_27696(class_2583.field_24360.method_10977(hasEnoughLevels ? class_124.field_1060 : class_124.field_1079))));
                    }
                } else {
                    class_2960 enchant = class_2960.method_12838((String)rename.getEnchantment(), (char)':');
                    String namespace = enchant.method_12836();
                    String path = enchant.method_12832();
                    class_5250 translatedEnchant = class_2561.method_43471((String)("enchantment." + namespace + "." + path));
                    class_5250 translatedEnchantLevel = class_2561.method_43471((String)("enchantment.level." + rename.getEnchantmentLevel()));
                    tooltip.add(class_2561.method_30163((String)(class_2561.method_43471((String)"rprenames.gui.tooltipHint.enchantment").getString() + " " + translatedEnchant.getString() + " " + translatedEnchantLevel.getString())).method_27661().method_27696(class_2583.field_24360.method_10977(hasEnchant && hasEnoughLevels ? class_124.field_1080 : class_124.field_1079)));
                }
            }
        }
        if (AnvilScreenMixin.config.showPackName && rename.getPackName() != null) {
            String packName = rename.getPackName();
            if (packName.endsWith(".zip")) {
                tooltip.add(class_2561.method_30163((String)packName.substring(0, packName.length() - 4)).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)).method_10852((class_2561)class_2561.method_30163((String)".zip").method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1080))));
            } else {
                tooltip.add(class_2561.method_30163((String)packName).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
            }
        }
        if (AnvilScreenMixin.config.showNbtDisplayName && this.currentTab != Tabs.FAVORITE && rename.getOriginalNbtDisplayName() != null) {
            tooltip.add(class_2561.method_30163((String)("nbt.display.Name=" + rename.getOriginalNbtDisplayName())).method_27661().method_27696(class_2583.field_24360.method_10977(class_124.field_1078)));
        }
        assert (this.field_22787 != null && this.field_22787.field_1755 != null);
        int menuX = ((class_471)this.field_22787.field_1755).field_2776 - 147 + -1;
        int buttonX = menuX + 10;
        int buttonY = ((class_471)this.field_22787.field_1755).field_2800 + 30;
        if (AnvilScreenMixin.config.viewMode == RenameButtonHolder.ViewMode.LIST) {
            x = buttonX;
            y = buttonY + orderOnPage * 22;
        } else {
            x = buttonX + 1 + orderOnPage % 5 * 25;
            y = buttonY + 1 + orderOnPage / 5 * 25;
        }
        ArrayList<class_5684> tooltipComponents = new ArrayList<class_5684>();
        for (Object e : tooltip) {
            if (e instanceof class_2561) {
                tooltipComponents.add(class_5684.method_32662((class_5481)((class_2561)e).method_30937()));
                continue;
            }
            if (!(e instanceof class_5684)) continue;
            class_5684 tooltipComponent = (class_5684)e;
            tooltipComponents.add(tooltipComponent);
        }
        RenameButton renameButton = new RenameButton(x, y, AnvilScreenMixin.config.viewMode, favorite, indexInInventory, isInInventory, asCurrentItem, playerInventory, rename, enoughStackSize, enoughDamage, hasEnchant, hasEnoughLevels);
        this.buttons.get(orderOnPage).setParameters(renameButton, rename, this.page, tooltipComponents);
    }

    private void defineButtons() {
        this.hideButtons();
        for (int n = 0; n < this.maxPageElements; ++n) {
            if (n + this.page * this.maxPageElements > this.currentRenameListSize - 1) continue;
            this.createButton(n, this.currentRenameList.get(n + this.page * this.maxPageElements));
        }
    }

    private void updatePageWidgets() {
        this.pageDown.field_22763 = this.page != 0;
        this.pageUp.field_22763 = (this.page + 1) * this.maxPageElements <= this.currentRenameListSize - 1;
        this.pageCount = class_2561.method_30163((String)(this.page + 1 + "/" + (this.currentRenameList.size() + this.maxPageElements - 1) / this.maxPageElements));
    }

    private void onSearch(String search) {
        this.searchTag = search;
        if (this.open) {
            this.updateSearchRequest();
        }
    }
}

